function onConfirmAction(alert, callback = null) {
    Swal.fire({
        icon: alert.icon ?? 'error',
        title: alert.title ?? 'Lỗi',
        text: alert.text ?? 'Xảy ra lỗi không xác định',
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Xác nhận',
        cancelButtonText: 'Hủy'
    }).then((result) => {
        if (result.isConfirmed) {
            try {
                if (callback) {
                    callback()
                }
            } catch (error) {
                Swal.fire({
                    icon: 'error',
                    title: 'Thao tác thất bại!',
                })
            }

        }
    })
}

function fixInpSweet() {
    $(function () {
        $.fn.offcanvas.Constructor.prototype._initializeFocusTrap
            = () => ({ activate: () => { }, deactivate: () => { } });
    })
}

function onConfirmActionWithInp(alert, callback = null, required = false) {
    Swal.fire({
        icon: alert.icon ?? 'warning',
        title: alert.title ?? 'Thông báo',
        text: alert.text ?? 'Bạn có chắc chắn',
        input: "textarea",
        inputLabel: "Nhập ghi chú",
        inputAttributes: {
            autocapitalize: "off"
        },
        showCancelButton: true,
        confirmButtonText: "Xác nhận",
        showLoaderOnConfirm: true,
        preConfirm: async (inp) => {
            if (!inp && required) {
                Swal.showValidationMessage('Vui lòng nhập ghi chú!');
                return false;
            }
            return inp;
        },
        allowOutsideClick: () => !Swal.isLoading()
    }).then((result) => {
        if (result.isConfirmed) {
            if (callback) {
                callback(result.value)
            }
        }
    });
}

function showMessage(event = {}) {
    if (event.hasOwnProperty('message')) {
        event = event.message;
    }
    event = Object.keys(event).length < 10 ? event : {
        icon: 'warning',
        title: 'Thông báo',
        text: event ?? 'Đã xảy ra lỗi không xác định',
    };

    Swal.fire({
        icon: event.icon ?? 'warning',
        title: event.title ?? 'Thông báo',
        text: event.text ?? 'Đã xảy ra lỗi không xác định',
    });
}

function showMessageTopRight(events = []) {
    const toastContainer = document.getElementById('toast-container');

    events.forEach(event => {
        if (event.hasOwnProperty('message')) {
            event = event.message;
        }
        event = Object.keys(event).length < 10 ? event : {
            icon: 'warning',
            title: 'Thông báo',
            text: event ?? 'Đã xảy ra lỗi không xác định',
        };

        const toastId = `toast-${Date.now()}`;
        const toastHtml = `
            <div id="${toastId}" class="toast" role="alert" aria-live="assertive" aria-atomic="true">
                <div class="toast-header bg-${event.icon}">
                    <strong class="me-auto">${event.title}</strong>
                    <small class="text-muted">hiện tại</small>
                    <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
                <div class="toast-body bg-white">
                    ${event.text}
                </div>
            </div>
        `;

        toastContainer.insertAdjacentHTML('beforeend', toastHtml);

        const toastElement = document.getElementById(toastId);
        const toast = new bootstrap.Toast(toastElement, {
            delay: 3000
        });
        toast.show();
    });
}

function confirmEvent(event) {
    Swal.fire({
        icon: event.icon,
        title: event.title,
        text: event.text,
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        confirmButtonText: 'Xác Nhận',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Hủy',
    }).then((result) => {
        if (result.isConfirmed) {
            window[event.type](event.data);
        }
    })
}

function onConfirmActionSweet(alert) {
    return Swal.fire({
        icon: alert.icon ?? 'question',
        title: alert.title ?? 'Thông báo',
        text: alert.text ?? 'Bạn có chắc chắn',
        html: alert.html ?? '',
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        confirmButtonText: 'Xác Nhận',
        cancelButtonColor: "#d33",
        cancelButtonText: 'Hủy',
    }).then((result) => {
        return result.isConfirmed
    });
}

let pubLoadingSwal = null;
function onLoadingSweet(params) {
    if (params) {
        pubLoadingSwal = Swal.fire({
            title: 'Loading...',
            html: 'Vui lòng chờ trong giây lát...',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });
    } else {
        if (pubLoadingSwal) {
            pubLoadingSwal.close();
            pubLoadingSwal = null;
        }
    }
}

if (document.getElementById('message_session_success')) {
    const message_session_success = document.getElementById('message_session_success').innerHTML;
    Swal.fire({
        icon: 'success',
        title: 'Thông báo',
        text: message_session_success,
    })
}

if (document.getElementById('message_session_error')) {
    const message_session_error = document.getElementById('message_session_error').innerHTML;
    Swal.fire({
        icon: 'error',
        title: 'Thông báo',
        text: message_session_error,
    })
}