var tab_form_add_ticket = false, tab_form_list_ticket = false, tab_form_ticket_detail = false;
var ticket_id = null;

async function onGetTickets() {
    ticket_id = null;
    try {
        let data = {
            is_api: false,
            limit: 20,
            page: 1
        }
        let result = await sendRequest(`${window.location.origin}/tickets/me`, 'POST', data);
        if (result.status == 200) {
            $('#tab_ticket_waiting').html(result.data.processing);
            $('#tab_ticket_no_process').html(result.data.pending);
            $('#tab_ticket_processed').html(result.data.done);
        }
    } catch (error) {
        showMessage(error.message);
    }
}

let DropzoneTicketFiles = new Dropzone("#ticket_files", {
    url: "/upload",
    autoProcessQueue: false,
    paramName: "file",
    clickable: true,
    maxFilesize: 5,
    maxFiles: 4,
    addRemoveLinks: true,
    dictDefaultMessage: "Tải file ở đây",
    init: function () {
        this.on("complete", function (file) {

        });
        this.on("addedfile", function (file) {
            if (file.size > 5 * 1024 * 1024) {
                alert("File size exceeds the limit of 5MB");
                this.removeFile(file);
            } else if (this.files.length >= this.options.maxFiles) {
                alert("You have reached the maximum number of files");
                this.removeFile(file);
            }
        });
        this.on("removedfile", function (file) {

        });
    }
});

$('.btn-popup-open').click(async function () {
    $('#form_detail_ticket').addClass('d-none');
    $('#form_enter_message').addClass('d-none');
    $('#form_add_ticket').addClass('d-none');
    $('#form_list_ticket').removeClass('d-none');
    $('#btn_add_button').removeClass('d-none');
    await onGetTickets();
});

$('#back_tab_ticket').click(async function () {
    if (!$('#form_list_ticket').hasClass('d-none')) {
        $('.hk-chat-popup').removeClass('d-flex');	
        $('.btn-popup-open').removeClass('d-none');	
    }
    if (tab_form_add_ticket) {
        $('#form_add_ticket').addClass('d-none');
        $('#form_list_ticket').removeClass('d-none');
        tab_form_add_ticket = false;
    }
    if (tab_form_ticket_detail) {
        await onGetTickets();
        $('#form_detail_ticket').addClass('d-none');
        $('#form_enter_message').addClass('d-none');
        $('#form_list_ticket').removeClass('d-none');
        $('#btn_add_button').removeClass('d-none');
        tab_form_ticket_detail = false;
    }
});

$('#on_add_ticket').click(async function () {
    if (tab_form_add_ticket) {
        $(this).attr('disabled', true);
        try {
            let data = new FormData();
            data.append('is_api', false);
            data.append('ticket_kind', $('[name="ticket_kind"]').val());
            data.append('ticket_transaction_code', $('[name="ticket_transaction_code"]').val());
            data.append('ticket_title', $('[name="ticket_title"]').val());
            data.append('ticket_message_content', $('[name="ticket_message_content"]').val());
            for (let i = 0; i < DropzoneTicketFiles.files.length; i++) {
                data.append(`file_${i}`, DropzoneTicketFiles.files[i]);
            }
            let result = await sendRequest(`${window.location.origin}/tickets/add`, 'POST', data, true);
            if (result.status == 200) {
                await onGetTickets();

                $('#form_add_ticket').addClass('d-none');
                $('#form_list_ticket').removeClass('d-none');
                tab_form_add_ticket = false;

                $('[name="ticket_kind"]').val('1');
                $('[name="ticket_transaction_code"]').val('');
                $('[name="ticket_title"]').val('');
                $('[name="ticket_message_content"]').val('');
                DropzoneTicketFiles.removeAllFiles();
            }
            showMessage(result.message);
            $(this).attr('disabled', false);
        } catch (error) {
            if (error.status != 422) {
                showMessage(error.message);
            }
            $(this).attr('disabled', false);
        }
    } else {
        tab_form_add_ticket = true;
        $('#form_add_ticket').removeClass('d-none');
        $('#form_list_ticket').addClass('d-none');

    }
});

async function onGetTicketDetail(ticket) {
    try {
        ticket_id = ticket;
        let data = {
            is_api: false,
            ticket_id: ticket_id
        }
        let result = await sendRequest(`${window.location.origin}/tickets/detail`, 'POST', data);
        if (result.status == 200) {
            $('#form_detail_ticket').html(result.html);
            tab_form_ticket_detail = true;
            if (result.ticket_status != 2) {
                $('#form_enter_message').removeClass('d-none');
            } else {
                $('#form_enter_message').addClass('d-none');
            }
            $('#form_detail_ticket').removeClass('d-none');
            $('#form_detail_ticket').removeClass('d-none');
            $('#btn_add_button').addClass('d-none');
            $('#form_list_ticket').addClass('d-none');

            let demoScroll = document.querySelector('.chat-popup-body .simplebar-content-wrapper');
            demoScroll.scrollTo({ top: 100000, behavior: "smooth" });
        } else {
            showMessage(error.message);
        }
    } catch (error) {
        showMessage(error.message);
    }
}

$('#on_send_message_ticket').on('click', async function () {
    if (tab_form_ticket_detail) {
        $(this).attr('disabled', true);
        try {
            let data = {
                is_api: false,
                ticket_id: ticket_id,
                ticket_message_content: $('[name="input_chat_popup"]').val()
            }
            let result = await sendRequest(`${window.location.origin}/tickets/add-message`, 'POST', data);
            if (result.status == 200) {
                $('#form_detail_ticket').append(`
                    <li class="media sent">
                        <div class="media-body">
                            <div class="msg-box">
                                <div>
                                    <p>${ result.ticket_message_content }</p>
                                    <span class="chat-time">${ result.created_at }</span>
                                </div>
                            </div>
                        </div>
                    </li>
                `);
                $('[name="input_chat_popup"]').val('');
                let demoScroll = document.querySelector('.chat-popup-body .simplebar-content-wrapper');
                demoScroll.scrollTo({ top: 100000});
            }else{
                showMessage(result.message);
            }
            $(this).attr('disabled', false);
        } catch (error) {
            if (error.status != 422) {
                showMessage(error.message);
            }
            $(this).attr('disabled', false);
        }
    }
});

$('[name="input_chat_popup"]').on('keydown', async function (e) {
    if (e.keyCode === 13 && $(this).is(':focus')) {
        e.preventDefault();
        $('#on_send_message_ticket').click();
    }
});