var checked_all_users = false;
var users_checked = [];

$(document).ready(function () {
    onGetUsersSendSmsHoliday();
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    const page = $(this).attr('href').split('page=')[1];
    onGetUsersSendSmsHoliday(page);
});

$(document).on('change', '#search-send-sms-holiday, #limit-send-sms-holiday', function () {
    onGetUsersSendSmsHoliday();
});

async function onGetUsersSendSmsHoliday(page = 1) {
    try {
        let data = {
            filters:{
                keywords: $("#search-send-sms-holiday").val(),
            },
            page: page,
            limit: $("#limit-send-sms-holiday").val(),
        };
        const result = await sendRequest(`${window.location.origin}/sms-manager/get-users-send-sms-holiday`, 'POST', data);
        if (result.status == 200) {
            $("#table-users-send-sms-holiday").html(result.html);
            $("#checked-all-users").prop("checked", checked_all_users);
            $(".checked-use-send-sms-holiday").each(function () {
                const phone = $(this).val();
                if (users_checked.includes(phone)) {
                    $(this).prop("checked", true);
                }
            });
        }
    } catch (error) {
        showMessage(error.message);
    }
}

$(document).on("click", "#checked-all-users",async function () {
    onLoadingSweet(true);
    checked_all_users = $("#checked-all-users").prop("checked");
    if (checked_all_users) {
        try {
            let result = await sendRequest(`${window.location.origin}/sms-manager/checked-all-users-send-sms-holiday`, 'POST');
            if (result.status == 200) {
                users_checked = result.phones;
                $.each(result.phones, function (index, value) {
                    $(".checked-use-send-sms-holiday").each(function () {
                        if ($(this).val() == value) {
                            $(this).prop("checked", true);
                        }
                    });
                });
            }else{
                showMessage(result.message);
            }
        } catch (error) {
            showMessage(error.message);
        }
    } else {
        users_checked = [];
        $(".checked-use-send-sms-holiday").each(function () {
            $(this).prop("checked", false);
        });
    }
    setTimeout(function() {
        onLoadingSweet(false);
    }, 1000);
});

$(document).on("click", "#send-sms-holiday-test", async function () {
    $("#send-sms-holiday-test").prop("disabled", true);
    try {
        let data = {
            holiday_name: $('[name="holiday_name"]').val(),
            congratulation: $('[name="congratulation"]').val(),
            phone_test: $('[name="phone_test"]').val(),
        };
        const result = await sendRequest(`${window.location.origin}/sms-manager/send-sms-holiday-test`, 'POST', data);
        showMessage(result.message);
        $("#send-sms-holiday-test").prop("disabled", false);
    } catch (error) {
        if (error.status == 422) {
            showMessage({
                'title': 'Lỗi',
                'text': 'Vui lòng nhập đúng và đầy đủ thông tin',
                'icon': 'warning'
            });
        }else{
            showMessage(error.message);
        }
        $("#send-sms-holiday-test").prop("disabled", false);
    }
});

$(document).on("click", "#send-sms-holiday", async function () {
    $("#send-sms-holiday").prop("disabled", true);
    try {
        let data = {
            holiday_name: $('[name="holiday_name"]').val(),
            congratulation: $('[name="congratulation"]').val(),
            phones: users_checked,
        };
        const result = await sendRequest(`${window.location.origin}/sms-manager/send-sms-holiday`, 'POST', data);
        showMessage(result.message);
        $("#send-sms-holiday").prop("disabled", false);
    } catch (error) {
        if (error.status == 422) {
            showMessage({
                'title': 'Lỗi',
                'text': 'Vui lòng nhập đúng và đầy đủ thông tin',
                'icon': 'warning'
            });
        }else{
            showMessage(error.message);
        }
        $("#send-sms-holiday").prop("disabled", false);
    }
});