$(document).ready(function () {
    $(document).on("click", "#edit_print_label", async function () {
        $(this).attr("disabled", true);
        try {
            const data = {
                shipment_code: shipment_code,
                receiver_contact_name: $(
                    '[name="receiver_contact_name"]'
                ).val(),
                receiver_address_1: $('[name="receiver_address_1"]').val(),
                receiver_city_state_post_code: $(
                    '[name="receiver_city_state_post_code"]'
                ).val(),
                select_country: $("#select_country").val(),
            };

            const result = await sendRequest(
                `${window.location.origin}/shipments/print/label-v2-changed`,
                "POST",
                data
            );

            
            const width = window.innerWidth;
            const height = window.innerHeight;
            const printWindow = window.open("", "", `width=${width},height=${height}`);

            printWindow.document.write(result.html);
            printWindow.document.close();
            printWindow.focus();
            printWindow.print();

            $(this).attr("disabled", false);
        } catch (error) {
            showMessage(error.message);
            $(this).attr("disabled", false);
        }
    });
});
