
Dropzone.autoDiscover = false;


$('#exampleModalShipmentOperatingCosts').on('shown.bs.modal', async function (e) {
    $('#on_save_operating_costs').attr('disabled', true);
    try {
        let data = {
            is_api: false,
            shipment_code: shipment_code
        };
        const result = await sendRequest(`${window.location.origin}/shipments/detail/shipment-operating-costs`, 'POST', data);
        if (result.status == 200) {
            $('#exampleModalShipmentOperatingCostsBody').html(result.html);
        } else {
            showMessage(result.message);
        }
        $('#on_save_operating_costs').attr('disabled', false);
    } catch (error) {
        showMessage(error);
        $('#on_save_operating_costs').attr('disabled', false);
    }
})

$('#exampleModalShipmentOperatingCosts').on('hidden.bs.modal', function (e) {
    $('#exampleModalShipmentOperatingCostsBody').html('');
});

$('#on_save_operating_costs').on('click', async function (e) {
    e.preventDefault();
    $('#on_save_operating_costs').attr('disabled', true);
    let operating_costs = {};
    let form_data = $('#exampleModalShipmentOperatingCosts input');

    $.each(form_data, function (index, value) {
        let input_id = value.id.replace('operating-costs_', '');
        input_id = input_id.replace(/_/g, '.');
        var parts = input_id.split('.');
        if (input_id.includes('shipment-operating-cost')) {
            if ($(`#operating-costs_${[parts[0]]}_${[parts[1]]}_${[parts[2]]}_${['operating-cost-id']}`).prop('checked')) {
                operating_costs = setData(operating_costs, input_id, $(`#${value.id}`).val());
            }
        } else if (input_id == 'receiver-sms-name' || input_id == 'receiver-sms-phone') {
            operating_costs = setData(operating_costs, input_id, $(`#${value.id}`).val());
        }
    });

    let data = {
        is_api: false,
        shipment_code: shipment_code,
        operating_costs: operating_costs
    };

    try {
        const result = await sendRequest(`${window.location.origin}/shipments/detail/save-shipment-operating-costs`, 'POST', data);
        if (result.status == 200) {
            $('#table_tbody_shipment_operating_costs').html('');
            $.each(result.shipment_operating_costs, function (index, value) {
                let row = `<tr>
                    <td>${value.operating_cost_name}</td>
                    <td>${formatNumberThousand(value.shipment_operating_cost_amount)} đ</td>
                    <td>${value.shipment_operating_cost_quantity}</td>
                    <td>${formatNumberThousand(value.shipment_operating_cost_total_amount)} đ</td>
                </tr>`;
                $('#table_tbody_shipment_operating_costs').append(row);
            });
            let html_profit = `<p class="${result.shipment_amount_profit >= 0 ? 'text-success' : 'text-danger'} fw-bold">
                                    - Lợi nhuận thực tế:
                                    ${formatNumberThousand(result.shipment_amount_profit)}đ
                                </p>`;
            $('#content_profit').html(html_profit)
            $('#amount_wallet_user').html(`Số dư: ${formatNumberThousand(result.amount_wallet)}đ`)
            $('#exampleModalShipmentOperatingCosts').modal('hide');
        }
        showMessage(result.message);
        restHtmlFee(result.shipment);
        $('#on_save_operating_costs').attr('disabled', false);
    } catch (error) {
        showMessage(error);
        $('#on_save_operating_costs').attr('disabled', false);
    }
});


if (document.getElementById('fileLabel')) {
    new Dropzone("#fileLabel", {
        url: "/upload",
        autoProcessQueue: false,
        paramName: "file",
        clickable: true,
        maxFilesize: 10,
        addRemoveLinks: true,
        acceptedFiles: '.pdf',
        dictDefaultMessage: "Tải file ở đây",
    });

}


$('#save_advance').on('click', async function (e) {

    let _url = window.location.origin + '/shipments/update-label';
    let _data = {
        shipment_code: shipment_code,
        file_label: Dropzone.forElement("#fileLabel").files[0],
    }

    let res = await ajaxContants2(_url, 'POST', _data, true);

    if (res.status === 200) {
        var newUrl = window.location.origin + '/' + res.url;
        let btn = document.getElementById('a_file_label');
        // Check if the anchor tag with id 'a_file_label' exists
        if (btn) {
            // If it exists, change the href attribute
            btn.href = '';
            btn.href = newUrl;
        } else {
            // If it does not exist, create a new anchor tag and append it to the container
            var newAnchor = $('<a>', {
                href: newUrl,
                target: '_blank',
                class: 'btn btn-primary btn-sm',
                id: 'a_file_label',
                html: 'Hiển thị <i class="far fa-eye"></i>'
            });
            $('#btn_content_label').append(newAnchor);
        }
        showMessage({
            icon: 'success',
            title: 'Thông báo',
            text: 'Cập nhật thành công'
        });

    } else {
        showMessage(res.message);
    }

})

if (document.getElementById('fileMethod')) {
    new Dropzone("#fileMethod", {
        url: "/upload",
        autoProcessQueue: false,
        paramName: "file",
        clickable: true,
        maxFilesize: 10,
        addRemoveLinks: true,
        acceptedFiles: '.png,.jpg',
        dictDefaultMessage: "Tải hình ảnh ở đây",
    });

}

$('#save_method').on('click', async function (e) {

    var dataURLs = [];

    let files = Dropzone.forElement("#fileMethod").files;
    if (files.length === 0) {
        showMessage({
            icon: 'error',
            title: 'Lỗi',
            text: 'Không có tệp nào được chọn.'
        });
        return;  // Dừng quá trình nếu không có tệp
    }

    for (let file of files) {
        try {
            let base64 = await readFileAsBase64(file);
            dataURLs.push(base64);
        } catch (error) {
            console.error('Lỗi khi đọc tệp:', error);
        }
    }
    onLoadingSweet(true);
    let _url = window.location.origin + '/shipments/update-method';
    let _data = {
        shipment_code: shipment_code,
        file_method: dataURLs,
        shipment_payment_method: selectedValue = $('input[name="shipmentPaymentMethod"]:checked').val()
    }

    let res = await ajaxContants2(_url, 'POST', _data);
    onLoadingSweet(false);

    if (res.status === 200) {
        showMessage({
            icon: 'success',
            title: 'Thông báo',
            text: 'Cập nhật thành công'
        });
        window.location.reload();
    } else {
        showMessage(res.message);
    }

})

$(document).on('click', '#on_save_shipment_fee', async function (e) {
    try {
        setTextNullValidate();
        let _url = window.location.origin + '/shipments/update-freight';
        let _data = {
            shipment_code: shipment_code,
            shipment_domestic_charges: $('#shipment_domestic_charges').val(),
            shipment_amount_surcharge: $('#shipment_amount_surcharge').val(),
            shipment_collection_fee: $('#shipment_collection_fee').val(),
            shipment_amount_insurance: $('#shipment_amount_insurance').val(),
            shipment_amount_vat: $('#shipment_amount_vat').val(),
            shipment_amount_original: $('#shipment_amount_original').val(),
            shipment_amount_total_customer: $('#shipment_amount_total_customer').val(),
            shipment_amount_residential: $('#shipment_amount_residential').val(),
            shipment_amount_peak: $('#shipment_amount_peak').val(),
        }

        const response = await sendRequest(_url, 'POST', _data);

        showMessage(response.message);
        restHtmlFee(response.shipment)
    } catch (error) {
        if (error.status == 422) {
            var errors = error.responseJSON.errors;
            $.each(errors, function (key, value) {
                $('#' + key + '_err').text(value[0]);
            });
        } else {
            showMessage(error.message);
        }
    }
});



function setTextNullValidate() {
    $('#shipment_domestic_charges_err').text('');
    $('#shipment_amount_surcharge_err').text('');
    $('#shipment_collection_fee_err').text('');
    $('#shipment_amount_insurance_err').text('');
    $('#shipment_amount_vat_err').text('');
    $('#shipment_amount_original_err').text('');
    $('#shipment_amount_total_customer_err').text('');
}


function restHtmlFee(data) {
    let html_table = `<table class="table">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th scope="col">Nội dung</th>
                                                                <th scope="col">Số tiền</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr>
                                                                <td>Cước nội địa</td>
                                                                <td>${formatNumberThousand(data.shipment_domestic_charges)}đ
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Cước phụ thu</td>
                                                                <td>${formatNumberThousand(data.shipment_amount_surcharge)}đ
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Cước thu hộ</td>
                                                                <td>${formatNumberThousand(data.shipment_collection_fee)}đ
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Cước phí bảo hiểm</td>
                                                                <td>${formatNumberThousand(data.shipment_amount_insurance)}đ
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Giá cước VAT</td>
                                                                <td>${formatNumberThousand(data.shipment_amount_vat)}đ
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>Cước gốc</td>
                                                                <td>
                                                                    ${formatNumberThousand(data.shipment_amount_original)}đ
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>`;
    $('#content_table_freight').html(html_table)

    let html_profit = `<p class="${data.shipment_amount_profit >= 0 ? 'text-success' : 'text-danger'} fw-bold">
                                                    - Lợi nhuận thực tế:
                                                    ${formatNumberThousand(data.shipment_amount_profit)}đ
                                                </p>`;
    $('#content_profit').html(html_profit)

    $('#content_total_customer').text(formatNumberThousand(data.shipment_amount_total_customer));

}
showTablePackages();
function showTablePackages() {
    let url = window.location.origin + '/shipments/list/package'
    let data = {
        shipment_code: shipment_code
    }
    ajaxPostHTML(url, data, 'table-packages');
}

// update surchage_goods 
let package_hawb_code = null;
let surchage_goods = [];
let surchage_goods_choosed = [];

let arrItemSurchage = [];
getSurchageGoods();

const itemSurchage = (surcharge_goods_id = "", count = 0, price = 0) => {
    return {
        surcharge_goods_id: surcharge_goods_id,
        count: count,
        price: price
    }
}

async function getSurchageGoods() {
    try {
        let _url = window.location.origin + '/scan/list/surchage-goods'
        let res = await ajaxContants2(_url, 'POST', [])
        if (res.status === 200) {
            surchage_goods = res.surchage_goods
        } else {
            showMessage(res.message)
        }
    } catch (error) {
    }
}

function addSurchageGood() {
    let cont = surchage_goods_choosed.length
    if (surchage_goods.length > 0) {
        if (surchage_goods[cont]) {
            let surchage_good = surchage_goods[cont];
            surchage_goods_choosed.push(itemSurchage(surchage_good.surcharge_goods_id, 1, surchage_good.surcharge_goods_price))
            getHtmlSurchageGoods();
        } else {
            showMessage({
                icon: 'warning',
                title: 'Thông báo',
                text: 'Danh sách hàng hóa phụ thu đã hết',
            })
        }
    } else {
        showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Danh sách hàng hóa phụ thu trống',
        })
    }
}

function getHtmlSurchageGoods() {
    $('#content-modal').html('');
    surchage_goods_choosed.forEach((item, index) => {
        getHtmlSelect(item, index);
    });
    $(".select2").select2();

}


const getHtmlSelect = (data, index) => {
    let otp = '';
    surchage_goods.forEach((item, index) => {
        const select = data.surcharge_goods_id == item.surcharge_goods_id ? 'selected' : ''
        const name_opt = item.surcharge_goods_name + "[" + item.surcharge_goods_price + "/" + item.surcharge_goods_type + "]"

        let exists = surchage_goods_choosed.some(obj => obj.surcharge_goods_id === item.surcharge_goods_id);
        if (!(exists && select !== 'selected')) {
            otp += `<option value="${item.surcharge_goods_id}" ${select}>${name_opt}</option>`;
        }

    });


    let html = `
        <div class="row mb-3" id="item-surchage_${data.surcharge_goods_id}">
            <div class="col-7">
                <label for="form-label">Mặt hàng</label>
                <select class="form-control select2" onchange="chooseSurchageSelect2(this.value, ${index})">
                    ${otp}
                </select>
            </div>
            <div class="col-3">
                <label for="form-label">Số lượng</label>
                <input type="number" value="${data.count}" class="form-control" onchange="setCountSurchage(this.value, ${index}, ${data.surcharge_goods_price})">
            </div>
            <div class="col-1 mb-3">
                <button class="btn btn-danger mt-4" onclick="onDeleteSurchage(${index})"><i class="far fa-times-circle"></i></button>
            </div>
            <small class="text-danger" id="err_count_${index}"></small>
        </div>
    `
    $('#content-modal').append(html);
}

function chooseSurchageSelect2(value, index, price) {
    surchage_goods_choosed[index].surcharge_goods_id = parseInt(value);
    surchage_goods_choosed[index].surcharge_goods_price = price;
    getHtmlSurchageGoods()
}

function setCountSurchage(value, index) {
    surchage_goods_choosed[index].count = parseInt(value);
}

function onDeleteSurchage(index) {
    surchage_goods_choosed.splice(index, 1);
    getHtmlSurchageGoods()
}

function openModal() {
    var myModal = new bootstrap.Modal(document.getElementById('importModal'));
    myModal.show();
}

function closeModal() {
    var myModalEl = document.getElementById('importModal');
    var modal = bootstrap.Modal.getInstance(myModalEl);
    modal.hide();
    surchage_goods_choosed = [];


}

document.addEventListener('DOMContentLoaded', function () {
    var importModal = document.getElementById('importModal');

    if (importModal) {
        importModal.addEventListener('hidden.bs.modal', function (event) {
            // Code xử lý khi modal bị ẩn đi
            surchage_goods_choosed = [];
            package_hawb_code = null;
            $('#content-modal').html('');
            // Thêm mã của bạn ở đây
            $('#btn_update_package').attr('disabled', false)
            $('#btn_update_package').html('Xác nhận')
        });
    }
});

async function getPackageDetail(_code) {
    let _url = window.location.origin + "/shipments/detail/package"
    package_hawb_code = _code;
    let _data = {
        code: _code
    }
    let _res = await ajaxContants2(_url, 'POST', _data)
    if (_res.status === 200) {
        let _package = _res.package
        $('#importModalLabel').text('Mã MAWB: ' + _code)
        $('#package_length').val(_package.package_length);
        $('#package_width').val(_package.package_width);
        $('#package_height').val(_package.package_height);

        const packageSG = _res.packageSg;
        surchage_goods_choosed = [];
        packageSG.forEach(element => {
            surchage_goods_choosed.push(itemSurchage(element.surcharge_goods_id, element.count, element.price))
        });

        getHtmlSurchageGoods()


        openModal()
    } else {
        showMessage(_res.message)
    }
}

$('#btn_update_package').click(async function () {
    $('#btn_update_package').attr('disabled', true)
    $('#btn_update_package').html(iconLoadingHtml())

    let url = window.location.origin + '/shipments/update/package-sg'
    let data = {
        package_hawb_code: package_hawb_code,
        package_sg: surchage_goods_choosed
    }

    let res = await ajaxContants2(url, "POST", data);

    if (res.status === 200) {
        showTablePackages();
        closeModal();
    }

    showMessage(res.message);
    $('#btn_update_package').attr('disabled', false)
    $('#btn_update_package').html('Xác nhận')
})

async function onCreateLabelReload(params) {
    try {
        $('#btn_create_label_reload').attr('disabled', true)
        $('#btn_create_label_reload').html(iconLoadingHtml())

        let url = window.location.origin + '/shipments/create-label-reload'
        let data = {
            shipment_id: params
        }
        let res = await ajaxContants2(url, "POST", data);

        if (res.status === 200) {
            window.location.reload();
        }
        showMessage(res.message);
        $('#btn_create_label_reload').attr('disabled', false)
        $('#btn_create_label_reload').html('<span class="icon"><i class="fas fa-file-download"></i></span>')
    } catch (error) {
        showMessage({
            icon: 'error',
            title: 'Lỗi khi gọi đến serve'
        })
        $('#btn_create_label_reload').attr('disabled', false)
        $('#btn_create_label_reload').html('<span class="icon"><i class="fas fa-file-download"></i></span>')
    }
}

$(document).on('click', '#btn_check_hold_shipment', async function () {
    $(this).attr('disabled', true);
    try {
        const data = {
            shipment_code: $(this).data('shipment_code')
        }

        const result = await sendRequest(`${window.location.origin}/shipments/check-hold-shipment`, 'POST', data);

        if (result.status == 200) {
            window.location.reload();
        } else {
            $(this).attr('disabled', false);
        }
    } catch (error) {
        showMessage(error.message);
        $(this).attr('disabled', false);
    }
});

async function onPrintFile(file) {
    try {
        const response = await fetch(`${window.location.origin}/${file}`);
        let html = await response.text();

        const css = `
            <style>
                @page {
                    margin-left: 0in;
                    margin-right: 0in;
                    margin-top: 0in;
                    margin-bottom: 0;
                }
            </style>
        `;
        html = css + html;

        const width = window.innerWidth;
        const height = window.innerHeight;
        const printWindow = window.open("", "", `width=${width},height=${height}`);

        printWindow.document.write(html);
        printWindow.document.close();
        printWindow.focus();
        setTimeout(() => {
            printWindow.print();
        }, 1000);
    } catch (error) {
        console.error('Error printing file:', error);
    }
}

function onReloadPaidBy() {
    onConfirmAction({
        icon: 'question',
        title: 'Xác nhận',
        text: 'Cập nhật lại phương thức thanh toán. Lưu ý việc này sẽ xóa các bằng chứng thanh toán hệ thống.',
    }, async () => {
        try {
            const url = `${window.location.origin}/shipments/detail/reload-paid-by`;
            const data = {
                shipment_code: shipment_code,
            };
            const result = await ajaxContants2(url, 'POST', data);

            if (result.status == 200) {
                window.location.reload();
            } else {
                showMessage(result.message);
            }
        } catch (error) {
            showMessage(error.message);
        }
    });
}
