var shipment = {};
var receiver_id = null;


jQuery(document).ready(function ($) {
    $('body').scrollspy({ target: '#scrollspy_demo_h' });

    // Khởi tạo Select2
    $('.select2').select2();

    $(window).on('activate.bs.scrollspy', function () {
        $('.select2').select2('close').select2('open');
    });

    formShipment();

    shipment['packages'] = {};
    shipment['packages'][0] = {
        package_quantity: 1,
        package_type: 0,
        package_length: 0,
        package_width: 0,
        package_height: 0,
        package_weight: 0,
    };
    onDisplayPackages();

    shipment['invoices'] = {};
    shipment['invoices'][0] = {
        invoice_goods_details: '',
        invoice_quantity: 0,
        invoice_unit: 0,
        invoice_price: 0,
        invoice_total_price: 0,
    };

    onDisplayInvoices();

    $('#form_shipment').on('submit', function (event) {
        event.preventDefault();
        if (document.querySelector(`#$form-info form`).checkValidity()) {
            onUpdateShipment();
        }
    });
});

function formShipment() {
    shipment['sender_company_name'] = $('[name="sender_company_name"]').val();
    shipment['sender_contact_name'] = $('[name="sender_contact_name"]').val();
    shipment['sender_telephone'] = $('[name="sender_telephone"]').val();
    shipment['sender_city'] = $('[name="sender_city"]').val();
    shipment['sender_district'] = $('[name="sender_district"]').val();
    shipment['sender_ward'] = $('[name="sender_ward"]').val();
    shipment['sender_address'] = $('[name="sender_address"]').val();
    shipment['sender_longitude'] = pub_longitude_map;
    shipment['serder_latitude'] = pub_latitude_map;

    shipment['receiver_id'] = $('[name="receiver_id"]').val();
    shipment['receiver_company_name'] = $('[name="receiver_company_name"]').val();
    shipment['receiver_contact_name'] = $('[name="receiver_contact_name"]').val();
    shipment['receiver_telephone'] = $('[name="receiver_telephone"]').val();
    shipment['receiver_country_id'] = $('[name="receiver_country_id"]').val();
    shipment['receiver_state_id'] = $('[name="receiver_state_id"]').val();
    shipment['receiver_state_name'] = $('[name="receiver_state_name"]').val();
    shipment['receiver_city_id'] = $('[name="receiver_city_id"]').val();
    shipment['receiver_postal_code'] = $('[name="receiver_postal_code"]').val();
    shipment['receiver_address_1'] = $('[name="receiver_address_1"]').val();
    shipment['receiver_address_2'] = $('[name="receiver_address_2"]').val();
    shipment['receiver_address_3'] = $('[name="receiver_address_3"]').val();
    shipment['save_receiver_flg'] = $('[name="save_receiver_flg"]').is(':checked');

    shipment['shipment_service_id'] = $('[name="shipment_service_id"]').val();
    shipment['shipment_signature_flg'] = $('[name="shipment_signature_flg"]').is(':checked');
    shipment['shipment_branch_id'] = $('[name="shipment_branch_id"]').val();
    shipment['shipment_reference_code'] = $('[name="shipment_reference_code"]').val();
    shipment['agree_terms_use_service'] = $('[name="agree_terms_use_service"]').is(':checked');
    shipment['shipment_goods_name'] = $('[name="shipment_goods_name"]').val();
    shipment['shipment_value'] = $('[name="shipment_value"]').val();
    shipment['shipment_export_as'] = $('[name="shipment_export_as"]').val();

    shipment['sale_id'] = $('[name="sale_id"]') ? $('[name="sale_id"]').val() : null;

    // AmountFreight
    shipment['shipment_domestic_charges'] = $('#shipment_domestic_charges').val();
    shipment['shipment_amount_surcharge'] = $('#shipment_amount_surcharge').val();
    shipment['shipment_collection_fee'] = $('#shipment_collection_fee').val();
    shipment['shipment_amount_insurance'] = $('#shipment_amount_insurance').val();
    shipment['shipment_amount_vat'] = $('#shipment_amount_vat').val();
    shipment['shipment_amount_original'] = $('#shipment_amount_original').val();
    shipment['shipment_amount_total_customer'] = $('#shipment_amount_total_customer').val();

    if (document.getElementsByClassName('shipment_paid_by')) {
        shipment['shipment_paid_by'] = $('input[name="shipment_paid_by"]:checked').val();
    }

}

function setTextNullValidate() {
    $('#shipment_domestic_charges_err').text('');
    $('#shipment_amount_surcharge_err').text('');
    $('#shipment_collection_fee_err').text('');
    $('#shipment_amount_insurance_err').text('');
    $('#shipment_amount_vat_err').text('');
    $('#shipment_amount_original_err').text('');
    $('#shipment_amount_total_customer_err').text('');
}

$('#shipment_service_promotion_id').change(async function () {
    $('#form-choose-payment-type').addClass('d-none');
    if ($('#shipment_service_promotion_id').val() != 2) {
        $('#form-choose-payment-type').removeClass('d-none');
    }
    await getServicesByCountry($('[name="receiver_country_id"]').val(), 'shipment_service_id', false);

});

async function getAreasInVietNam(key_city = null, key_district = null, key_element_district, key_element_ward, is_name = true) {
    if (!key_district) {
        $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).find('option').not('[value=""]').remove();
        $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).attr("disabled", true);
    }
    $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).find('option').not('[value=""]').remove();
    $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).attr("disabled", true);
    try {
        let data = {
            city: key_city,
            district: key_district,
        }
        const result = await sendRequest(`${window.location.origin}/areas-in-viet-nam`, 'POST', data);
        if (result.status == 200) {
            if (!key_district) {
                $.each(result.areas.districts, function (key, district) {
                    $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).append($('<option>', {
                        value: key,
                        text: `${district}`
                    }));
                });
            }
            $.each(result.areas.wards, function (key, ward) {
                $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).append($('<option>', {
                    value: key,
                    text: `${ward}`
                }));
            });
        } else {
            showMessage(result.message);
        }
        $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).attr("disabled", false);
        $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).attr("disabled", false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $(is_name ? `[name="${key_element_district}"]` : `#${key_element_district}`).attr("disabled", false);
        $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).attr("disabled", false);
    }

}

async function getServicesByCountry(country_id = null, key_element_shipment_service_id, is_name = true) {
    $(is_name ? `[name="${key_element_shipment_service_id}"]` : `#${key_element_shipment_service_id}`).find('option').not('[value=""]').remove();
    $(is_name ? `[name="${key_element_shipment_service_id}"]` : `#${key_element_shipment_service_id}`).attr("disabled", true);
    try {
        let data = {
            country_id: country_id,
            service_promotion_id: $('#shipment_service_promotion_id').val() ?? 0,
        }
        const result = await sendRequest(`${window.location.origin}/services-by-country`, 'POST', data);
        if (result.status == 200) {
            $.each(result.services, function (key, service) {
                $(is_name ? `[name="${key_element_shipment_service_id}"]` : `#${key_element_shipment_service_id}`).append($('<option>', {
                    value: service.service_id,
                    text: `${service.service_name}`
                }));
            });
        } else {
            showMessage(result.message);
        }
        $(is_name ? `[name="${key_element_shipment_service_id}"]` : `#${key_element_shipment_service_id}`).attr("disabled", false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $(is_name ? `[name="${key_element_shipment_service_id}"]` : `#${key_element_shipment_service_id}`).attr("disabled", false);
    }
}

$('document').ready(async function () {
    
    $('#sender_city').on('change', async function () {
        $('div.actions.clearfix').addClass('d-none');
        await getAreasInVietNam($('[name="sender_city"]').val(), null, 'sender_district', 'sender_ward', false);
        $('div.actions.clearfix').removeClass('d-none');
    });

    $('#sender_district').on('change', async function () {
        $('div.actions.clearfix').addClass('d-none');
        await getAreasInVietNam($('[name="sender_city"]').val(), $('[name="sender_district"]').val(), 'sender_district', 'sender_ward', false)
        $('div.actions.clearfix').removeClass('d-none');
    });
});




$('#receiver_country_id').on('change', async function () {
    $('div.actions.clearfix').addClass('d-none');
    // await getAreasForWorld($('[name="receiver_country_id"]').val(), null, 'receiver_country_id', 'receiver_state_id', 'receiver_city_id', false);
    await getServicesByCountry($('[name="receiver_country_id"]').val(), 'shipment_service_id', false);
    $('div.actions.clearfix').removeClass('d-none');

    //biến của view modals-area
    pub_country_id_for_modal = $('[name="receiver_country_id"]').val();
    $('#receiver_city_id').val('');
    $('#receiver_city_name').val('');
    $('#receiver_state_id').val('');
    $('#receiver_state_name').val('');
});

$('#receiver_state_name').on('input', function () {
    pub_state_id_for_modal = null;
    $('[name="receiver_state_id"]').val('');
});

$('#receiver_state_id').on('change', async function () {

    // var selectedText = $(this).find("option:selected").text();
    // if ($('#receiver_state_id').val() == "" || $('#receiver_state_id').val() == null) {
    //     $('#receiver_state_name').attr('disabled', false);
    //     $('#receiver_state_name').val("");
    // } else {
    //     $('#receiver_state_name').attr('disabled', true);
    //     $('#receiver_state_name').val(selectedText);
    // }

    $('div.actions.clearfix').addClass('d-none');
    // await getAreasForWorld($('[name="receiver_country_id"]').val(), $('[name="receiver_state_id"]').val(), 'receiver_country_id', 'receiver_state_id', 'receiver_city_id', false)
    $('div.actions.clearfix').removeClass('d-none');

    //biến của view modals-area
    pub_state_id_for_modal = $('[name="receiver_state_id"]').val();
});


$('#receiver_id').on('change', async function () {
    $('div.actions.clearfix').addClass('d-none');
    if (!$('[name="receiver_id"]').val()) {
        receiver_id = null;
        $('[name="receiver_company_name"]').val('');
        $('[name="receiver_contact_name"]').val('');
        $('[name="receiver_telephone"]').val('');
        $('#receiver_country_id').val('');
        $('#receiver_state_id').val('');
        $('#receiver_state_name').val('');
        $('#receiver_city_id').val('');
        $('#receiver_city_name').val('');
        $('[name="receiver_postal_code"]').val('');
        $('[name="receiver_address_1"]').val('');
        $('[name="receiver_address_2"]').val('');
        $('[name="receiver_address_3"]').val('');
        return false;
    }
    $('[name="receiver_id"]').attr("disabled", true);
    try {
        receiver_id = $('[name="receiver_id"]').val();
        let data = {
            receiver_id: receiver_id,
        }
        const result = await sendRequest(`${window.location.origin}/receiver-information`, 'POST', data);
        if (result.status == 200) {
            // await getAreasForWorld(result.receiver.receiver_country_id, result.receiver.receiver_state_id, 'receiver_country_id', 'receiver_state_id', 'receiver_city_id', false);
            await getServicesByCountry($('[name="receiver_country_id"]').val(), 'shipment_service_id', false);
            $('[name="receiver_company_name"]').val(result.receiver.receiver_company_name);
            $('[name="receiver_contact_name"]').val(result.receiver.receiver_contact_name);
            $('[name="receiver_telephone"]').val(result.receiver.receiver_telephone);
            // $('#receiver_country_id').val(result.receiver.receiver_country_id);
            $('#receiver_country_id').val(result.receiver.receiver_country_id).trigger('change');
            $('#receiver_state_id').val(result.receiver.receiver_state_id);
            $('#receiver_state_name').val('');
            $('#receiver_city_id').val(result.receiver.receiver_city_id);
            $('#receiver_city_name').val(result.receiver.city_name);
            $('[name="receiver_postal_code"]').val(result.receiver.receiver_postal_code);
            $('[name="receiver_address_1"]').val(result.receiver.receiver_address_1);
            $('[name="receiver_address_2"]').val(result.receiver.receiver_address_2);
            $('[name="receiver_address_3"]').val(result.receiver.receiver_address_3);
        } else {
            showMessage(result.message);
        }
        $('[name="receiver_id"]').attr("disabled", false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('[name="receiver_id"]').attr("disabled", false);
    }
    $('div.actions.clearfix').removeClass('d-none');
})

function setInformationInStepInformationShipment() {
    $('#info_sender_company').html($('[name="sender_company_name"]').val());
    $('#info_sender_contact_name').html($('[name="sender_contact_name"]').val());
    $('#info_sender_phone').html($('[name="sender_telephone"]').val());
    // $('#shipment_iosscode').html($('[name="shipment_iosscode"]').val());
    $('#info_shipment_service').html($('[name="shipment_service_id"] option:selected').text());
    $('#info_shipment_branch').html($('[name="shipment_branch_id"] option:selected').text());
    $('#info_shipment_signature').html($('[name="shipment_signature_flg"]').is(':checked') ? 'Có' : 'Không');
    $('#info_receiver_company').html($('[name="receiver_company_name"]').val());
    $('#info_receiver_contact_name').html($('[name="receiver_contact_name"]').val());
    $('#info_receiver_phone').html($('[name="receiver_telephone"]').val());
    $('#info_receiver_address').html($('[name="receiver_address_1"]').val());
    $('#info_receiver_city').html($('[name="receiver_city_id"] option:selected').text());
    $('#info_receiver_country').html($('[name="receiver_country_id"] option:selected').text());
}

$('input').on('change', function () {
    setInformationInStepInformationShipment();
});

$('select').on('change', function () {
    setInformationInStepInformationShipment();
});

$('#btn_add_package').on('click', function () {
    let key = Object.keys(shipment['packages']).length;
    shipment['packages'][key] = {
        package_quantity: 1,
        package_type: 0,
        package_length: 0,
        package_width: 0,
        package_height: 0,
        package_weight: 0,
    };
    onDisplayPackages();
});

function onDisplayPackages() {
    $('#table_tbody_packages').html('');
    $.each(shipment['packages'], function (key, package) {
        $('#table_tbody_packages').append(`
            <tr id="table_tbody_tr_packages_${key}">
                <td>
                    <input type="number" class="form-control required" name="shipment.packages.${key}.package_quantity" 
                        value="${package.package_quantity}" min="1">
                </td>
                <td>
                    <select class="form-control required" name="shipment.packages.${key}.package_type">
                        ${package_types.map((type, index) => `<option value="${index}">${type}</option>`).join('')}
                    </select>
                </td>
                <td>
                    <input type="number" class="form-control required" name="shipment.packages.${key}.package_length" 
                        value="${package.package_length}" min="0" step="0.1">
                </td>
                <td>
                    <input type="number" class="form-control required" name="shipment.packages.${key}.package_width"
                        value="${package.package_width}" min="0" step="0.1">
                </td>
                <td>
                    <input type="number" class="form-control required" name="shipment.packages.${key}.package_height"
                        value="${package.package_height}" min="0" step="0.1">
                </td>
                <td>
                    <input type="number" class="form-control required" name="shipment.packages.${key}.package_weight"
                        value="${package.package_weight}" min="0" step="0.1">
                </td>
                <td>
                    <button type="button" class="btn btn-sm btn-danger" onclick="onDeletePackage(${key})">
                        <i class="fa fa-trash"></i>
                    </button>
                </td>
            </tr>
        `);
    });
}

function onDeletePackage(key) {
    if (Object.keys(shipment['packages']).length > 1) {
        delete shipment['packages'][key];
        $(`#table_tbody_tr_packages_${key}`).remove();
        onDisplayPackages();
    } else {
        alert('Phải có ít nhất 1 kiện hàng');
    }
}

$('#btn_add_invoice').on('click', function () {
    let key = Object.keys(shipment['invoices']).length;
    shipment['invoices'][key] = {
        invoice_goods_details: '',
        invoice_quantity: 0,
        invoice_unit: 0,
        invoice_price: 0,
        invoice_total_price: 0,
    };
    onDisplayInvoices();
});

function onDisplayInvoices(is_reload_shipment_value = false) {
    let shipment_value = is_reload_shipment_value ? 0 : $('[name="shipment_value"]').val();
    $('#table_tbody_invoices').html('');
    $.each(shipment['invoices'], function (key, invoice) {
        shipment['invoices'][key]['invoice_total_price'] = invoice['invoice_quantity'] * invoice['invoice_price'];
        if (is_reload_shipment_value) {
            shipment_value += shipment['invoices'][key]['invoice_total_price'];
        }
        $('#table_tbody_invoices').append(`
            <tr id="table_tbody_tr_invoices_${key}">
                <td>
                    <textarea type="text" class="form-control required" name="shipment.invoices.${key}.invoice_goods_details">${invoice.invoice_goods_details}</textarea>
                </td>
                <td>
                    <input type="number" class="form-control required" name="shipment.invoices.${key}.invoice_quantity" 
                        value="${invoice.invoice_quantity}" min="0">
                </td>
                <td>
                    <select class="form-control required" name="shipment.invoices.${key}.invoice_unit">
                        ${invoice_units.map((unit, index) => `<option value="${index}">${unit}</option>`).join('')}
                    </select>
                </td>
                <td>
                    <input type="number" class="form-control required" name="shipment.invoices.${key}.invoice_price"
                        value="${invoice.invoice_price}" min="0" step="0.01">
                </td>
                <td class="text-center">${invoice.invoice_total_price}</td>
                <td>
                    <button type="button" class="btn btn-sm btn-danger" onclick="onDeleteInvoice(${key})">
                        <i class="fa fa-trash"></i>
                    </button>
                </td>
            <tr>    
        `);
    });
    $('[name="shipment_value"]').val(shipment_value);
}

function onDeleteInvoice(key) {
    if (Object.keys(shipment['invoices']).length > 0) {
        delete shipment['invoices'][key];
        $(`#table_tbody_tr_invoices_${key}`).remove();
        onDisplayInvoices();
    } else {
        alert('Phải có ít nhất 1 sản phẩm trong hóa đơn');
    }
}

$('body').on('change', '[name^="shipment."]', function () {
    let value = $(this).val();
    let input_name = $(this).attr('name');
    var parts = input_name.split('.');
    let last_part = parts[parts.length - 1];
    let is_reload_shipment_value = false;
    if (last_part == 'invoice_quantity' || last_part == 'invoice_price') {
        is_reload_shipment_value = true;
    }
    if (parts.length > 1) {
        input_name = input_name.replace('shipment.', '');
    }
    shipment = setData(shipment, input_name, value);
    // onDisplayPackages();
    onDisplayInvoices(is_reload_shipment_value);
});



async function onUpdateShipment() {
    await formShipment();

    // if (!$(`#form-info`)[0].checkValidity()) {
    //     return showMessage({
    //         icon: 'warning',
    //         title: 'Thông báo',
    //         text: 'Vui lòng kiểm tra dữ liệu nhập vào'
    //     })
    // }
    let order_pickup = false;

    if ($('#isCreatePickup').is(':checked')) {
        if (!pub_latitude_map || !pub_longitude_map) {
            return showMessage({
                icon: 'warning',
                title: 'Cảnh báo',
                text: 'Để tạo order pickup vui lòng chọn địa chỉ trên google map'
            })
        }
        order_pickup = true;
    }

    let event = {
        title: 'Xác nhận hành vi!',
        text: `Bạn có chắc muốn tạo đơn hàng này không?`,
        icon: 'question',
        type: 'agreeUpdateShipment',
        data: {
            is_api: false,
            shipment: shipment,
            shipment_service_promotion_id: $('#shipment_service_promotion_id').val() ?? 0,
            order_pickup: order_pickup
        }
    };
    confirmEvent(event);
}

async function agreeUpdateShipment(data) {
    $('div.actions.clearfix').addClass('d-none');
    try {
        onLoadingSweet(true)
        let result = await sendRequest(`${window.location.origin}/shipments/create`, 'POST', data);
        if (result.status == 200) {
            window.location.href = result.redirect_url;
        } else {
            showMessage(result.message);
            $('div.actions.clearfix').removeClass('d-none');
        }
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        } else if (error.status == 422) {
            showMessage(error.responseJSON.message);
            // showMessage({
            //     icon: 'warning',
            //     title: 'Thông báo',
            //     text: 'Dữ liệu truyền lên bị thiếu vui lòng kiểm tra lại'
            // });
        }
        $('div.actions.clearfix').removeClass('d-none');
    }
    onLoadingSweet(false)
}


if ($('#sale_id')) {
    $('#sale_id').change(async function () {
        if ($('#sale_id').val()) {
            let url = window.location.origin + '/profile/info';
            let data = {
                user_id: $('#sale_id').val(),
            }
            let res = await ajaxContants2(url, 'POST', data);

            if (res.status == 200) {
                const sender = res.data;
                $('[name="sender_company_name"]').val(sender.user_company_name);
                $('[name="sender_contact_name"]').val(sender.user_contact_name);
                $('[name="sender_telephone"]').val(sender.user_phone);
                $('[name="sender_city"]').val(sender.user_address_1);
                $('[name="sender_district"]').val(sender.user_address_2);
                $('[name="sender_ward"]').val(sender.user_address_3);
                // $('[name="sender_address"]').val(sender.user_address);
                if (sender.user_latitude && sender.user_latitude != '' && sender.user_longitude && sender.user_longitude != '') {
                    updateMapWithLatLng(sender.user_latitude, sender.user_longitude);
                } else {
                    $('[name="sender_address"]').val('');
                }
            } else {
                showMessage(res.message);
            }
        } else {

        }
    })
}

