let page = 1;
let limit = 50;
let filters = null;

function setFilters(filters) {
    return filters;
}

let excels = [];
document.getElementById('upload-file-excel').addEventListener('change', function (event) {
    var file = event.target.files[0];
    if (!file) return;
    $('#create_bill').html(iconLoadingHtml())
    $('#create_bill').prop('disabled', true);


    let reader = new FileReader();
    reader.readAsArrayBuffer(event.target.files[0]);

    // var reader = new FileReader();
    // reader.onload = function (event) {
    //     var data = new Uint8Array(event.target.result);
    //     var workbook = XLSX.read(data, { type: 'array' });
    //     var firstSheetName = workbook.SheetNames[0];
    //     var worksheet = workbook.Sheets[firstSheetName];
    //     var json = XLSX.utils.sheet_to_json(worksheet);
    //     if (json.length < 1) {
    //         $('#upload-file-excel').val();
    //         return showMessage({
    //             text: 'Dữ liệu excel trống'
    //         })
    //     }

    //     setDataExcel(json);
    //     $('#create_bill').html('Tạo Bill')
    //     $('#create_bill').prop('disabled', false);
    // };

    reader.onload = function (e) {
        let data = new Uint8Array(e.target.result);
        let workbook = XLSX.read(data, { type: 'array' });

        let sheet = workbook.Sheets[workbook.SheetNames[0]];
        let jsonData = XLSX.utils.sheet_to_json(sheet);

        let data_post = [];
        jsonData.forEach((item, index) => {
            let packages = [{
                weight: item.weight,
                width: item.width,
                height: item.height,
                length: item.length,
                package_type: item.package_type ?? 0,
                count_package: item.count_package ?? 1
            }]

            if (index > 0 && (Object.keys(item).length == 5 || Object.keys(item).length == 6)) {

                let package = {
                    weight: item.weight,
                    width: item.width,
                    height: item.height,
                    length: item.length,
                    package_type: item.package_type ?? 0,
                    count_package: item.count_package ?? 1
                }
                data_post[data_post.length - 1].packages.push(package);
            } else {
                item.packages = packages;
                data_post.push(item);
            }
        });

        excels = data_post;
        $('#create_bill').html('Tạo Bill')
        $('#create_bill').prop('disabled', false);
    };
});

async function setDataExcel(data) {
    // Hàm để xóa khoảng trắng ở đầu và cuối tên thuộc tính
    const trimObjectKeys = (obj) => {
        const trimmedObj = {};
        for (const key in obj) {
            if (obj.hasOwnProperty(key)) {
                const trimmedKey = key.trim();
                trimmedObj[trimmedKey] = obj[key];

                if (condition) {

                }
            }
            console.log(obj, obj[key]);

        }
        return trimmedObj;
    };
    excels = trimObjectKeys(data);
}

$("#create_bill").click(function () {
    handleBulkUpload();
});

async function handleBulkUpload() {
    if (excels.length < 1) {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: "Không có dữ liệu để khởi tạo"
        })
    }
    try {
        $('#create_bill').html(iconLoadingHtml())
        $('#create_bill').prop('disabled', true);
        let _data = {
            data_excel: excels
        }
        let _url = window.location.origin + '/bulk-upload/handle';
        let res = await sendRequest(_url, 'POST', _data);

        $('#upload-file-excel').val('');
        excels = [];

        window.location.href = res.redirect_url;
    } catch (error) {
        const message = error.responseJSON ? error.responseJSON.message : error.message;
        showMessage(message)
        $('#create_bill').html('Tạo Bill')
        $('#create_bill').prop('disabled', false);
    }
}

getTableServices();

$(document).on('click', '.pagination a', function (event) {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    filters = setFilters({
        key_type: 'all',
        keywords: $('#keywords').val(),
        country_id: $('[name="receiver_country_id"]').val(),
        promotion_flg: $('#promotion_flg').val(),
    });
    getTableServices(null, false);
});

$('#keywords').on('input', function () {
    filters = setFilters({
        key_type: 'all',
        keywords: $('#keywords').val(),
        promotion_flg: $('#promotion_flg').val(),
    });
    getTableServices(null, false);
});

function getTableServices(url = null, loading = true) {
    let _url = url ? url : window.location.origin + '/util/countries-service'

    let _data = {
        page: page,
        limit: limit,
        filters: filters
    }

    ajaxPostHTML(_url, _data, 'content-service', null, loading);
}

$('#receiver_country_id').on('change', async function () {
    $('div.actions.clearfix').addClass('d-none');
    $('div.actions.clearfix').removeClass('d-none');

    filters = setFilters({
        key_type: 'all',
        keywords: $('#keywords').val(),
        country_id: $('[name="receiver_country_id"]').val(),
        promotion_flg: $('#promotion_flg').val(),
    });
    getTableServices(null, false);

    getLabel();
});

$('#promotion_flg').on('change', async function () {
    $('div.actions.clearfix').addClass('d-none');
    $('div.actions.clearfix').removeClass('d-none');

    filters = setFilters({
        key_type: 'all',
        keywords: $('#keywords').val(),
        country_id: $('[name="receiver_country_id"]').val(),
        promotion_flg: $('#promotion_flg').val(),
    });
    getTableServices(null, false);

    getLabel();
});

function getLabel() {
    const label_country = `To Country: ${$('#receiver_country_id option:selected').text()}`;
    $('#label_country').text(label_country);

    const label_promotion_flg = `Loại dịch vụ: ${$('#promotion_flg option:selected').text()}`;
    $('#label_promotion_flg').text(label_promotion_flg);
}