let limit = 30;
let page = 1;

$(document).ready(function () {
    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {
        page = 1;
        fetchData();
    });
    fetchData()
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    fetchData();
});

$('#service_ids').on('change', function () {
    page = 1;
    fetchData();
});

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        page = 1;
        fetchData();
    }
})

function getFilters() {
    return {
        keywords: $('#keywords').val(),
        service_ids: $('#service_ids').val(),
        date_range: {
            start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        }
    }
}


function fetchData(_url = null, _page = null, _limit = null) {

    if (!_url) {
        _url = window.location.origin + '/list/scan-table'
    }

    let _data = {
        status: status_scan,
        over_time: over_time,
        paginate: {
            limit: _limit === null ? limit : _limit,
            page: _page === null ? page : _page,
        },
        filters: getFilters()
    }
    ajaxPostHTML(_url, _data, 'content')

}

function onDelete(history_id) {

    const call = async () => {
        let _url = window.location.origin + '/list/cancel-status'
        let _data = {
            history_id: history_id,
        }

        let res = await ajaxContants2(_url, 'POST', _data)
        if (res.status == 200) {
            showMessage({
                icon: 'success',
                title: 'Thông báo',
                text: 'Hủy bỏ thành công'
            })
            fetchData(null, 1);
        } else {
            showMessage(res.message)
        }
    }

    let alert = {
        icon: 'question',
        title: 'Thông báo',
        text: 'Bạn có chắc chắn đưa đớn hàng này về trạng thái created'
    }
    onConfirmAction(alert, call)
}