const SHIPMENT_STATUS_IMPORTED = 1
const SHIPMENT_STATUS_EXPORED = 2
const SHIPMENT_STATUS_RETURNED = 3

let sm_tracktry_id = null;
if (document.getElementById('sm_tracktry_id')) {
    sm_tracktry_id = document.getElementById('sm_tracktry_id').value;
}
let limit = 50;
let page = 1;
function getFilters() {
    return {
        keywords: $('#keywords').val()
    }
}

getSurchageGoods();

if (status_scan == SHIPMENT_STATUS_EXPORED) {
    fetchData();
}
$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        fetchData();
    }
})

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];

    fetchData();
});

function fetchData(_url = null, _page = null, _limit = null, filters = null) {
    if (!_url) {
        _url = window.location.origin + '/mawb-manager/list-sm-tracktry'
    }

    let _data = {
        paginate: {
            limit: _limit === null ? limit : _limit,
            page: _page === null ? page : _page,

        },
        template: true,
        filters: {
            keywords: $('#keywords').val()
        }
    }

    ajaxPostHTML(_url, _data, 'content')
}


function chooseMawb(id, name) {
    sm_tracktry_id = id;
    $('#listMawb').offcanvas('hide');
    $('#name_mawb').val(name);
}



async function onConfirmScan(_data = null) {

    $('#btn_scan').html(iconLoadingHtml());
    const text_alert = [
        'error!!!!!!!',
        'Bạn có chắc chắn import đơn hàng này không',
        'Bạn có chắc chắn export đơn hàng này không',
        'Bạn có chắc chắn return đơn hàng này không',
    ];
    try {
        const call = async () => {

            let _url = window.location.origin + '/scan/update-status'
            if (!_data) {
                _data = {
                    status: status_scan,
                    code: $('#scan_code').val(),
                }
            }
            if (status_scan == SHIPMENT_STATUS_EXPORED) {
                var dataURLs = [];
                let inputFiles = $('#inputContainer input[type="file"]');
                for (const input of inputFiles) {
                    if (input.files.length > 0) {
                        let base64 = await readFileAsBase64(input.files[0]);
                        dataURLs.push(base64);
                    }
                }
                if (dataURLs.length == 0) {
                    showMessage({
                        icon: 'error',
                        title: 'Lỗi',
                        text: 'Không có tệp nào được chọn.'
                    });
                    return;
                }

                _data.sm_tracktry_id = $('#id_mawb').val();
                _data.bag_code = $('#bag_code').val();
                _data.package_image = dataURLs
            }
            if (status_scan == SHIPMENT_STATUS_IMPORTED) {
                _data.package_length = $('#package_length').val();
                _data.package_width = $('#package_width').val();
                _data.package_height = $('#package_height').val();
                _data.package_weight = $('#package_weight').val();
            }

            let res = await ajaxContants2(_url, 'POST', _data)
            if (res.status === 200) {
                showMessage({
                    icon: 'success',
                    title: 'Thông báo',
                    text: 'Scan thành công'
                })

                if (status_scan == SHIPMENT_STATUS_EXPORED) {
                    window.location.href = window.location.origin + '/scan/bag-code?awb_code=' + res.awb_code
                    status_scan = SHIPMENT_STATUS_EXPORED;
                }
                closeModal();
                $('#scan_code').val('');
                if (status_scan == SHIPMENT_STATUS_IMPORTED) {
                    window.location.reload();
                }
            } else if (res.status === 422) {
                var errors = res.error;
                $.each(errors, function (key, value) {
                    $('#' + key + '_err').text(value[0]);
                });
            } else {
                showMessage(res.message)
            }


        }

        let alert = {
            icon: 'question',
            title: 'Thông báo',
            text: text_alert[status_scan]
        }
        onConfirmAction(alert, call)
    } catch (error) {
    }

    $('#btn_scan').html(
        `<span>
            <span>Xác nhận</span>
            <span class="icon"><i class="fa fa-barcode"></i></span>
        </span>`
    );

}

$('document').ready(function () { })

$('#btn_scan').click(async function (e) {
    onStartScan();
})

async function onStartScan() {
    try {
        let _code = $('#scan_code').val();

        if (_code == '') {
            return showMessage({
                icon: 'warning',
                title: 'Thông báo',
                text: 'Không có mã code để cập nhật'
            })
        }

        if (status_scan == SHIPMENT_STATUS_IMPORTED) {
            let _url = window.location.origin + "/scan/export/modal"
            let _data = {
                code: _code,
                status: status_scan,
            }

            let _res = await ajaxContants2(_url, 'POST', _data)
            if (_res.status == 200) {
                let _package = _res.package;

                $('#importModalLabel').text('Mã MAWB: ' + _code)
                $('#package_length').val(_package.package_length);
                $('#package_width').val(_package.package_width);
                $('#package_height').val(_package.package_height);
                $('#shipment_code').html(_res.shipment_code);
                // $('#package_weight').val(_package.package_weight);
                document.getElementById('package_weight').value = _package.package_weight
                // openModal()
                window.location.href = _res.route;
            } else {
                showMessage(_res.message)
            }
        } else if (status_scan == SHIPMENT_STATUS_EXPORED) {

            onConfirmScan();
        } else if (status_scan == SHIPMENT_STATUS_RETURNED) {
            onConfirmScan();
        }
    } catch (error) {
        if (error.responseJSON.message) {
            showMessage(error.responseJSON.message)
        } else {
            showMessage()
        }

    }
}

// Dành riêng cho chức năng scan imported
let surchage_goods = [];
let surchage_goods_choosed = [];

let arrItemSurchage = [];
const itemSurchage = (surcharge_goods_id = "", count = 0, price = 0) => {
    return {
        surcharge_goods_id: surcharge_goods_id,
        count: count,
        price: price
    }
}
$('#btn_imported').click(() => {
    scanImported()
})

function scanImported() {

    let _check_err = false;
    surchage_goods_choosed.forEach((item, index) => {
        $('#err_count_' + index).text('');
        if (item.count <= 0) {
            $('#err_count_' + index).text('*Số lượng mặt hàng phụ thu phải lớn hơn 0');
            _check_err = true;
        }
    })
    if (_check_err) {
        return
    }

    let _data = {
        status: status_scan,
        code: $('#scan_code').val(),
        surchage_goods: surchage_goods_choosed
    }
    onConfirmScan(_data);
}

async function getSurchageGoods() {
    let _url = window.location.origin + '/scan/list/surchage-goods'
    let res = await ajaxContants2(_url, 'POST', [])
    if (res.status === 200) {
        surchage_goods = res.surchage_goods
    } else {
        showMessage(res.message)
    }
}

function addSurchageGood() {
    let cont = surchage_goods_choosed.length
    if (surchage_goods.length > 0) {
        if (surchage_goods[cont]) {
            let surchage_good = surchage_goods[cont];
            surchage_goods_choosed.push(itemSurchage(surchage_good.surcharge_goods_id, 1, surchage_good.surcharge_goods_price))
            getHtmlSurchageGoods()
        } else {
            showMessage({
                icon: 'warning',
                title: 'Thông báo',
                text: 'Danh sách hàng hóa phụ thu đã hết',
            })
        }
    } else {
        showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Danh sách hàng hóa phụ thu trống',
        })
    }
}

function getHtmlSurchageGoods() {
    $('#content-modal').html('');
    surchage_goods_choosed.forEach(async (item, index) => {
        await getHtmlSelect(item, index);
    });
    $('.select2').select2({
        minimumResultsForSearch: 0, // Đảm bảo ô tìm kiếm hiển thị
        dropdownParent: $("#importModal") // Thêm nếu Select2 nằm trong modal
    });
}


function getHtmlSurchageGoods() {
    $('#content-modal').html('');
    let fragment = $(document.createDocumentFragment());

    surchage_goods_choosed.forEach((item, index) => {
        fragment.append(getHtmlSelect(item, index));
    });

    $('#content-modal').append(fragment);

    $('.select2').select2({
        minimumResultsForSearch: 0, // Đảm bảo ô tìm kiếm hiển thị
        dropdownParent: $("#importModal") // Thêm nếu Select2 nằm trong modal
    });
}

const getHtmlSelect = (data, index) => {
    let otp = '';
    surchage_goods.forEach((item) => {
        const select = data.surcharge_goods_id == item.surcharge_goods_id ? 'selected' : '';
        const name_opt = item.surcharge_goods_name + "[" + item.surcharge_goods_price + "/" + item.surcharge_goods_type + "]";

        let exists = surchage_goods_choosed.some(obj => obj.surcharge_goods_id === item.surcharge_goods_id);
        if (!(exists && select !== 'selected')) {
            otp += `<option value="${item.surcharge_goods_id}" ${select}>${name_opt}</option>`;
        }
    });

    return `
        <div class="row mb-3" id="item-surchage_${data.surcharge_goods_id}">
            <div class="col-7">
                <label for="form-label">Mặt hàng</label>
                <select class="form-control select2" onchange="chooseSurchageSelect2(this.value, ${index})">
                    ${otp}
                </select>
            </div>
            <div class="col-3">
                <label for="form-label">Số lượng</label>
                <input type="number" value="${data.count}" class="form-control" onchange="setCountSurchage(this.value, ${index}, ${data.surcharge_goods_price})">
            </div>
            <div class="col-1 mb-3">
                <button class="btn btn-danger mt-4" onclick="onDeleteSurchage(${index})"><i class="far fa-times-circle"></i></button>
            </div>
            <small class="text-danger" id="err_count_${index}"></small>
        </div>
    `;
};

function chooseSurchageSelect2(value, index, price) {
    surchage_goods_choosed[index].surcharge_goods_id = parseInt(value);
    surchage_goods_choosed[index].surcharge_goods_price = price;
    getHtmlSurchageGoods()
}

function setCountSurchage(value, index) {
    surchage_goods_choosed[index].count = parseInt(value);
}

function onDeleteSurchage(index) {
    surchage_goods_choosed.splice(index, 1);
    getHtmlSurchageGoods()
}

function openModal() {
    var myModal = new bootstrap.Modal(document.getElementById('importModal'));
    myModal.show();
}

function closeModal() {
    var myModalEl = document.getElementById('importModal');
    var modal = bootstrap.Modal.getInstance(myModalEl);
    modal.hide();
    surchage_goods_choosed = [];
}

document.addEventListener('DOMContentLoaded', function () {
    var importModal = document.getElementById('importModal');

    if (importModal) {
        importModal.addEventListener('hidden.bs.modal', function (event) {
            // Code xử lý khi modal bị ẩn đi
            surchage_goods_choosed = [];
            $('#content-modal').html('');
            // Thêm mã của bạn ở đây
        });
    }
});

// end

$('#btn_scan_barcode').click(async function () {
    if (sm_tracktry_id == '') {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Bạn cần chọn MAWB để có thể cập nhật'
        })
    }

    if (!$('#scan_code').val()) {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Bạn chưa scan?'
        })
    }

    let _url = window.location.origin + "/scan/bag-code/check"
    let _data = {
        bag_code: $('#scan_code').val(),
        sm_tracktry_id: sm_tracktry_id,
    }
    let _res = await ajaxContants2(_url, 'POST', _data)

    if (_res.status === 200) {
        window.location.href = _res.route
    } else if (_res.status === 422) {
        var errors = _res.error;
        let text = "";
        $.each(errors, function (key, value) {
            text += key + ": " + value[0] + "<br>";
        });
        showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: text,
        });
    } else {
        showMessage(_res.message);
    }
})

$('#btn_scan_export').click(async function () {
    try {
        if (!$('#scan_code').val()) {
            return showMessage({
                icon: 'warning',
                title: 'Thông báo',
                text: 'Bạn chưa scan?'
            })
        }

        let _url = window.location.origin + "/scan/export/modal"
        let _data = {
            bag_code: $('#bag_code').val(),
            sm_tracktry_id: $('#id_mawb').val(),
            code: $('#scan_code').val(),
            status: status_scan,
        }
        let res = await ajaxContants2(_url, 'POST', _data)

        if (res.status === 200) {
            $('#content-modal').html(res.html)

            $('#detailPackage').modal('show');


            $('#input-file-now').on('change', function () {
                if (this.files && this.files[0]) {
                    $('#footer-modal').html('<button type="button" class="btn btn-primary" onclick="onStartScan()">Tiếp tục scan</button>');
                } else {
                    $('#footer-modal').html('');
                }
            });
        } else {
            showMessage(res.message)
        }
    } catch (error) {
        showMessage()

    }
})


function addInputGroup() {
    // Tạo phần tử input-group mới
    const inputGroup = $('<div>', { class: 'input-group mb-3' });

    // Tạo input file
    const inputFile = $('<input>', {
        type: 'file',
        class: 'form-control',
        name: 'exported_images[]',
        accept: 'image/*'  // Chỉ cho phép chọn hình ảnh
    });

    // Tạo nút xóa
    const deleteButton = $('<button>', {
        class: 'btn btn-danger',
        type: 'button',
        html: '<i class="fas fa-times"></i>'
    });

    // Xử lý sự kiện xóa phần tử khi nhấn nút
    deleteButton.on('click', function () {
        inputGroup.remove();  // Xóa input group khi nhấn nút
    });

    // Thêm input và button vào input-group
    inputGroup.append(inputFile);
    inputGroup.append(deleteButton);

    // Thêm input-group vào container
    $('#inputContainer').append(inputGroup);
}
