let surchage_goods = [];
let surchage_goods_choosed = [];

let arrItemSurchage = [];
const itemSurchage = (surcharge_goods_id = "", count = 0, price = 0) => {
    return {
        surcharge_goods_id: surcharge_goods_id,
        count: count,
        price: price
    }
}

async function getSurchageGoods() {
    let _url = window.location.origin + '/scan/list/surchage-goods'
    let res = await ajaxContants2(_url, 'POST', [])
    if (res.status === 200) {
        surchage_goods = res.surchage_goods;
        $('#add-surchage').prop('disabled', false);
    } else {
        showMessage(res.message)
    }
}
getSurchageGoods();

function addSurchageGood() {
    let cont = surchage_goods_choosed.length
    if (surchage_goods.length > 0) {
        if (surchage_goods[cont]) {
            let surchage_good = surchage_goods[cont];
            surchage_goods_choosed.push(itemSurchage(surchage_good.surcharge_goods_id, 1, surchage_good
                .surcharge_goods_price))
            getHtmlSurchageGoods()
        } else {
            showMessage({
                icon: 'warning',
                title: 'Thông báo',
                text: 'Danh sách hàng hóa phụ thu đã hết',
            })
        }
    } else {
        showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Danh sách hàng hóa phụ thu trống',
        })
    }
}



function getHtmlSurchageGoods() {
    $('#content-modal').html('');
    let fragment = $(document.createDocumentFragment());

    surchage_goods_choosed.forEach((item, index) => {
        fragment.append(getHtmlSelect(item, index));
    });

    $('#content-modal').append(fragment);

    $('.select2').select2({
        minimumResultsForSearch: 0, // Đảm bảo ô tìm kiếm hiển thị
        // dropdownParent: $("#importModal") // Thêm nếu Select2 nằm trong modal
    });

}

const getHtmlSelect = (data, index) => {
    let otp = '';
    surchage_goods.forEach((item) => {
        const isSelected = data.surcharge_goods_id === item.surcharge_goods_id ? 'selected' : '';
        const name_opt =
            `${item.surcharge_goods_name} [${item.surcharge_goods_price}/${item.surcharge_goods_type}]`;

        // Kiểm tra xem mặt hàng đã chọn chưa
        let exists = surchage_goods_choosed.some(obj => obj.surcharge_goods_id === item
            .surcharge_goods_id);
        if (!(exists && isSelected !== 'selected')) {
            otp += `<option value="${item.surcharge_goods_id}" ${isSelected}>${name_opt}</option>`;
        }
    });

    // Trả về HTML
    return `
        <div class="row mb-3" id="item-surchage_${data.surcharge_goods_id}">
            <div class="col-12 mb-3">
                <label for="form-label">Mặt hàng</label>
                <select class="select2 form-control" onchange="chooseSurchageSelect2(this.value, ${index})">
                    ${otp}
                </select>
            </div>
            <div class="col-8 mb-3">
                <label for="form-label">Số lượng</label>
                <input type="number" value="${data.count}" class="form-control" 
                       onchange="setCountSurchage(this.value, ${index}, ${data.surcharge_goods_price})">
            </div>
            <div class="col-4 mb-3">
                <button class="btn btn-danger mt-4" onclick="onDeleteSurchage(${index})">
                    <i class="far fa-times-circle"></i>
                </button>
            </div>
            <small class="text-danger" id="err_count_${index}"></small>
        </div>
    `;
};

function chooseSurchageSelect2(value, index, price) {
    surchage_goods_choosed[index].surcharge_goods_id = parseInt(value);
    surchage_goods_choosed[index].surcharge_goods_price = price;
    getHtmlSurchageGoods()
}

function setCountSurchage(value, index) {
    surchage_goods_choosed[index].count = parseInt(value);
}

function onDeleteSurchage(index) {
    surchage_goods_choosed.splice(index, 1);
    getHtmlSurchageGoods()
}

function openModal() {
    var myModal = new bootstrap.Modal(document.getElementById('importModal'));
    myModal.show();
}

function closeModal() {
    var myModalEl = document.getElementById('importModal');
    var modal = bootstrap.Modal.getInstance(myModalEl);
    modal.hide();
    surchage_goods_choosed = [];
}

$('#btn_imported').click(async function (e) {
    let _check_err = false;
    surchage_goods_choosed.forEach((item, index) => {
        $('#err_count_' + index).text('');
        if (item.count <= 0) {
            $('#err_count_' + index).text('*Số lượng mặt hàng phụ thu phải lớn hơn 0');
            _check_err = true;
        }
    })
    if (_check_err) {
        return
    }

    Swal.fire({
        icon: 'question',
        title: 'Xác nhận',
        text: 'Bạn có muốn nhập hàng không?',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Xác nhận',
        cancelButtonText: 'Hủy'
    }).then(async (result) => {
        if (result.isConfirmed) {
            onScanImported();
        }

    })
})

async function onScanImported() {
    try {
        onLoadingSweet(true);
        const data = {
            status: status_scan,
            code: $('#scan_code').val(),
            surchage_goods: surchage_goods_choosed,
            package_length: $('#package_length').val(),
            package_width: $('#package_width').val(),
            package_height: $('#package_height').val(),
            package_weight: $('#package_weight').val(),
        }
        const url = window.location.origin + '/scan/update-status';
        const res = await ajaxContants2(url, 'POST', data)

        if (res.status === 200) {
            window.location.href = window.location.origin + '/scan/import';
        } else if (res.status === 422) {
            var errors = res.error;
            $.each(errors, function (key, value) {
                $('#' + key + '_err').text(value[0]);
            });
        } else {
            showMessage(res.message)
        }
    } catch (error) {
        onLoadingSweet(false);
    }
    onLoadingSweet(false);
}