var limit = 50, page = 1;
const url_get_notifications = `${window.location.href}`;

$(document).ready(function () {
    onPagination(url_get_notifications);
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    onPagination(url_get_notifications);
});

function filters() {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    // return {
    //     date_range: {
    //         start_date: $('input[name="order_pickup_date_range"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
    //         end_date: $('input[name="order_pickup_date_range"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
    //     },
    //     order_pickup_status: order_pickup_status,
    //     branch_id: $('[name="order_pickup_branch_id"]').val(),
    //     keywords: $('[name="order_pickup_keywords"]').val(),
    // };
    return {};
}

async function onPagination(_url) {
    $('#show_table_content').html('');
    try {
        let data = {
            is_api: false,
            limit: limit,
            page: page,
            filters: JSON.stringify(Object.assign({}, filters())),
        };
        const result = await sendRequest(_url, 'POST', data);
        if (result.status == 200) {
            $('#show_table_content').html(result.html);
        }else{
            showMessage(result.message);
        }
        $('#loading_show_table_content').removeClass('d-block');
        $('#loading_show_table_content').addClass('d-none');
    } catch (error) {
        $('#loading_show_table_content').removeClass('d-block');
        $('#loading_show_table_content').addClass('d-none');
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function onDeleteNotification(notification_id) {
    let event = {
        title: 'Xác nhận hành vi!',
        text: 'Bạn có chắc muốn xóa thông báo này!',
        icon: 'question',
        type: 'agreeDeleteNotification',
        data: {
            is_api: false,
            notification_id: notification_id,
        }
    };
    confirmEvent(event);
}

async function agreeDeleteNotification(data) {
    $(`#btn_delete_notification_${data.notification_id}`).attr('disabled', true);
    try {
        const result = await sendRequest(`${url_get_notifications}/delete`, 'POST', data);
        if (result.status == 200) {
            limit = 20;
            page = 1;
            onPagination(url_get_notifications);
        }
        showMessage(result.message);
        $(`#btn_delete_notification_${data.notification_id}`).attr('disabled', false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $(`#btn_delete_notification_${data.notification_id}`).attr('disabled', false);
    }
}