$(document).ready(function () {
    editor.plugins.get('FileRepository').createUploadAdapter = (loader) => {
        return {
            upload: () => {
                return loader.file
                    .then(file => new Promise((resolve, reject) => {
                        const reader = new FileReader();
                        reader.readAsDataURL(file);
                        reader.onload = () => resolve({
                            default: reader.result
                        });
                        reader.onerror = error => reject(error);
                    }));
            }
        };
    };

    editor.setData(notification_content);
});

let editor;
ClassicEditor
    .create(document.querySelector('#editor'), {
        mediaEmbed: {
            previewsInData: true
        },
    })
    .then(newEditor => {
        editor = newEditor;
    })
    .catch(error => {
        console.error(error);
    });

$('#submit_edit_notifications').on('click', async function () {
    $('#back_to_notifications').attr('disabled', true);
    $('#submit_edit_notifications').attr('disabled', true);
    let form_validate = ['notification_title', 'notifications_content'];
    try {
        let data = new FormData();
        data.append('is_api', false);
        data.append('notification_id', notification_id);
        data.append('notification_title', $('[name="notification_title"]').val());
        data.append('notification_important', $('[name="notification_important"]').prop('checked'));
        data.append('notification_content', editor.getData());

        const result = await sendRequest(`${window.location.origin}/notifications/edit`, 'POST', data, true);

        if (result.status == 200) {
            window.location = result.redirect;
        }else{
            showMessage(result.message);
            $('#back_to_notifications').attr('disabled', false);
            $('#submit_edit_notifications').attr('disabled', false);
        }
        $.each(form_validate, function (key, value) {
            $(`#error_${value}`).html('');
        });
    } catch (error) {
        if (error.status == 422) {
            $.each(form_validate, function (key, value) {
                if (error.responseJSON.errors[value]) {
                    $(`#error_${value}`).html(error.responseJSON.errors[value][0]);
                } else {
                    $(`#error_${value}`).html('');
                }
            });
        }
        if (error.status != 422) {
            showMessage(error.message);
        }
        $('#back_to_notifications').attr('disabled', false);
        $('#submit_edit_notifications').attr('disabled', false);
    }
});