let limit = 50;
let page = 1;

function getFilters() {
    return {
        keywords: $('#keywords').val()
    }
}

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        fetchData();
    }
})

$(document).ready(function () {
    fetchData()
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    fetchData();
});

function fetchData(_url = null, _page = null, _limit = null, filters = null) {
    if (!_url) {
        _url = window.location.origin + '/mawb-manager/list-package-bill'
    }

    let _data = {
        sm_tracktry_id: sm_tracktry_id,
        paginate: {
            limit: _limit === null ? limit : _limit,
            page: _page === null ? page : _page,
        },
        filters: filters === null ? getFilters() : filters,
    }

    ajaxPostHTML(_url, _data, 'content')
}

$('#btn_trackingDropzone').click(async function (e) {
    let html = $('#btn_trackingDropzone').html();
    try {
        onLoadingIcon('btn_trackingDropzone')
        if (excels_tracking.length <= 0) {
            return showMessage({
                icon: 'warining',
                title: 'Thông báo',
                text: 'Dữ liệu excel trống'
            })
        }
        onLoadingSweet(true);
        let data = {
            sm_tracktry_id: sm_tracktry_id,
            create_tracking: true,
            excels: excels_tracking
        }

        onUpdatePackage(data)
    } catch (error) {

    }
    onLoadingIcon('btn_trackingDropzone', false, html)
    onLoadingSweet(false);
})

$('#btn_dubaiDropzone').click(async function (e) {
    let html = $('#btn_dubaiDropzone').html();
    try {
        onLoadingIcon('btn_dubaiDropzone')
        if (excels_dubai.length <= 0) {
            return showMessage({
                icon: 'warining',
                title: 'Thông báo',
                text: 'Dữ liệu excel trống'
            })
        }
        onLoadingSweet(true);

        let data = {
            sm_tracktry_id: sm_tracktry_id,
            create_tracking: false,
            excels: excels_dubai
        }

        onUpdatePackage(data);
    } catch (error) {

    }
    onLoadingIcon('btn_dubaiDropzone', false, html)
    onLoadingSweet(false);
})

function convertFileTracking(excels) {

    return convertedExcels = excels.map(item => {
        return {
            hawb: item.HAWB + "",
            tracking_code: item.Tracking_Code + ""
        };
    });
}

async function onUpdatePackage(_data) {

    let _url = window.location.origin + '/mawb-manager/update-tracking'

    let res = await ajaxContants2(_url, 'POST', _data);
    if (res.status == 200) {
        fetchData();
    }
    showMessage(res.message)
}


let excels_tracking = [];
let excels_dubai = [];


function convertDataExcelMawb(json) {
    // Chuyển đổi mảng dữ liệu JSON từ Excel thành mảng với định dạng mong muốn
    return json.map(item => ({
        hawb: item.HAWB || '',  // Lấy giá trị của HAWB, nếu không có thì để trống
        tracking_code: item.Tracking_Code || ''  // Lấy giá trị của Tracking_Code, nếu không có thì để trống
    }));
}

new Dropzone("#trackingDropzone", {
    url: "/fake/location",
    maxFiles: 1,
    autoProcessQueue: false,
    paramName: "file",
    clickable: true,
    maxFilesize: 10,
    addRemoveLinks: true,
    acceptedFiles: '.csv,.xlsx',
    dictDefaultMessage: "Tải file excel ở đây",
    init: function () {
        this.on("addedfile", function (file) {
            let html = $('#btn_trackingDropzone').html;
            onLoadingIcon('btn_trackingDropzone')
            // Xử lý khi một tệp mới được thêm vào Dropzone
            var reader = new FileReader();
            reader.onload = async function (e) {
                var data = new Uint8Array(e.target.result);
                var workbook = XLSX.read(data, { type: 'array' });
                var firstSheetName = workbook.SheetNames[0];
                var worksheet = workbook.Sheets[firstSheetName];
                var json = XLSX.utils.sheet_to_json(worksheet, { raw: false, defval: '' });
                if (json.length < 1) {
                    $('#upload-file-excel').val();
                    return showMessage({
                        text: 'Dữ liệu excel trống'
                    })
                }

                excels_tracking = await convertDataExcelMawb(json);
                console.log(excels_tracking);
                onLoadingIcon('btn_trackingDropzone', false, html)
            };
            reader.readAsArrayBuffer(file);

        });

        this.on("uploadprogress", function (file, progress) {
            // Xử lý khi tệp đang được tải lên
            console.log("Tiến trình tải lên:", progress, "%", " cho tệp ", file.name);
        });

        this.on("success", function (file, response) {
            // Xử lý khi tệp được tải lên thành công
            console.log("Tải lên thành công:", file.name, " Phản hồi từ server:", response);
        });

        this.on("error", function (file, errorMessage) {
            // Xử lý khi có lỗi xảy ra trong quá trình tải lên
            console.log("Lỗi tải lên:", file.name, " Thông báo lỗi:", errorMessage);
        });
    }
    // Dropzone.forElement("#adminRechargeDropzone").files[0];
    //Dropzone.forElement("#adminRechargeDropzone").removeAllFiles(true);
})

new Dropzone("#dubaiDropzone", {
    url: "/upload",
    maxFiles: 1,
    autoProcessQueue: false,
    paramName: "file",
    clickable: true,
    maxFilesize: 10,
    addRemoveLinks: true,
    acceptedFiles: '.csv,.xlsx',
    dictDefaultMessage: "Tải file excel ở đây",
    init: function () {
        this.on("addedfile", function (file) {
            let html = $('#btn_dubaiDropzone').html;
            onLoadingIcon('btn_dubaiDropzone')
            // Xử lý khi một tệp mới được thêm vào Dropzone
            var reader = new FileReader();
            reader.onload = async function (e) {
                var data = new Uint8Array(e.target.result);
                var workbook = XLSX.read(data, { type: 'array' });
                var firstSheetName = workbook.SheetNames[0];
                var worksheet = workbook.Sheets[firstSheetName];
                var json = XLSX.utils.sheet_to_json(worksheet, { raw: false, defval: '' });
                if (json.length < 1) {
                    $('#upload-file-excel').val();
                    return showMessage({
                        text: 'Dữ liệu excel trống'
                    })
                }


                excels_dubai = await convertDataExcelMawb(json);
                // $('#btn_dubaiDropzone').prop('disabled', false);
                onLoadingIcon('btn_dubaiDropzone', false, html)
            };
            reader.readAsArrayBuffer(file);
        });
        this.on("uploadprogress", function (file, progress) {
        });
        this.on("success", function (file, response) {
        });
        this.on("error", function (file, errorMessage) {
        });
    }
});


async function removePackageTracking(hawb) {
    const call = async () => {
        let _url = window.location.origin + '/mawb-manager/remove-tracking'
        let _data = {
            hawb_code: hawb,
        }
        let res = await ajaxContants2(_url, 'POST', _data);
        if (res.status == 200) {
            fetchData();
        }
        showMessage(res.message)
    }

    let alert = {
        icon: 'question',
        title: 'Thông báo',
        text: 'Bạn có chắn chắn remove đối tượng này ra khỏi mawb không'
    }
    onConfirmAction(alert, call)
}


async function onExportExcel(excel_type, name) {
    onLoadingSweet(true)
    try {
        let url = window.location.origin + '/mawb-manager/bill-package/export-excel';
        let data = {
            excel_type: excel_type,
            sm_tracktry_id: sm_tracktry_id,
        }

        const response = await fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(data)
        });

        if (response.ok) {
            const blob = await response.blob(); // Chuyển kết quả sang dạng blob
            const link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            link.download = excel_type + `[${name}]` + '.xlsx'; // Tên file tải về
            link.click(); // Tự động tải file
        } else {
            showMessage()
        }
        onLoadingSweet(false)

    } catch (error) {
        // if (error.responseJSON.message) {
        //     showMessage(error.responseJSON.message)
        // }
        showMessage()
        onLoadingSweet(false)
    }
}