let pub_page = 1;
let pub_limit = 50;

$(document).ready(function () {
    fetchData();
})

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();
});

function fetchData() {
    let url = window.location.origin + '/mawb-manager/add-tracking/paginate'
    let data = {
        shipment_tracktry_id: pub_shipment_tracktry_id,
        paginate: {
            limit: pub_limit,
            page: pub_page
        },

    }

    ajaxPostHTML(url, data, 'content')
}

function onAddPackageTracking() {
    onShowModal('#addPackageTracking');
}


function onDeleteTrackingStatus(key) {
    const callback = async () => {
        let url = window.location.origin + '/mawb-manager/add-tracking/delete';
        let data = {
            tracking_status_id: key,
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            fetchData();
        }
        showMessage(res.message);
    }

    onConfirmAction({
        icon: 'question',
        title: 'Xác nhận!',
        text: 'Bạn có chắc chắn muốn xóa trạng thái này không?'
    }, callback);
}


function emptyValidate() {
    $('#tracking_status_address_err').html('');
    $('#tracking_status_note_err').html('');
    $('#tracking_status_date_err').html('');
}

function emptyData() {
    $('#tracking_status_address').val("");
    $('#tracking_status_note').val("");
    $('#tracking_status_date').val("");
}

$('#form_tracking_status').on('submit', function (e) {
    e.preventDefault(); // Ngăn không cho form chuyển trang
    // Thực hiện các thao tác khác ở đây
    handleShipmentStatusCreate();
});

async function handleShipmentStatusCreate() {
    try {
        onBtnLoading('#btn_submit_create');
        emptyValidate();
        let url = window.location.origin + '/mawb-manager/add-tracking';
        let data = {
            shipment_tracktry_id: pub_shipment_tracktry_id,
            tracking_status_date: $('#tracking_status_date').val(),
            tracking_status_address: $('#tracking_status_address').val(),
            tracking_status_note: $('#tracking_status_note').val(),
        }

        let res = await ajaxContants2(url, 'POST', data);

        if (res.status == 200) {
            fetchData();
        } else if (res.status == 422) {
            var errors = res.error;
            $.each(errors, function (key, value) {
                // Hiển thị thông điệp lỗi tương ứng với mỗi trường
                $('#' + key + '_err').text(value[0]);
            });
        }

        showMessage(res.message);
        onBtnLoading('#btn_submit_create', false, 'Thêm trạng thái');
    } catch (error) {
        onBtnLoading('#btn_submit_create', false, 'Thêm trạng thái');
        if (error.responseJSON.message) {
            showMessage(error.responseJSON.message);
        } else {
            showMessage({
                icon: 'error',
                title: 'Thông báo',
                text: 'Xảy ra lỗi khi gọi lên serve'
            });
        }
    }

}


async function updateStatusHawbByMawb() {
    try {
        onLoadingSweet(true);
        let url = window.location.origin + '/mawb-manager/update-tracking-hawb-by-mawb';
        let data = {
            shipment_tracktry_id: pub_shipment_tracktry_id,
        }
        let res = await ajaxContants2(url, 'POST', data);
        onLoadingSweet(false);
        showMessage(res.message);
    } catch (error) {
        // onBtnLoading('#btn_submit_create', false, 'Thêm trạng thái');
        onLoadingSweet(false);
        showMessage();
    }
}