let pub_page = 1;
let pub_limit = 30;

$(document).on('click', '.pagination a', async function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();
});

$(window).ready(function () {
    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        }
    }, function (start, end, label) {
        // pub_content = CONTENT_LIST;
        fetchData();
    });
    fetchData();
    getDataSelectFwds()
})


$('#keywords').on('keypress', function (e) {
    if (e.which === 13) {
        fetchData()
    }
})

function fetchData() {
    let url = window.location.origin + '/manages/sale/fwd/list-link';
    let data = {
        sale_id: pub_sale_id,
        paginate: {
            page: pub_page,
            limit: pub_limit
        },
        filters: {
            date_range: {
                start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
                end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
            },
            keywords: $('#keywords').val()
        }
    };
    ajaxPostHTML(url, data, 'content');

}

async function getDataSelectFwds() {
    $('#select_fwds').html('');
    $('#select_fwds').attr('disabled', true);
    let url = window.location.origin + '/manages/sale/fwd/no-link';
    let data = {}

    let res = await ajaxContants2(url, 'POST', data);
    if (res.status == 200) {
        let fwds = res.fwds;
        fwds.forEach(function (option) {
            let name = `[${option.user_code}] ${option.user_company_name}`;
            let value = option.user_id
            $('#select_fwds').append(new Option(name, value));
        });
        $('#select_fwds').select2()
    } else {
        showMessage(res.message)
    }
    $('#select_fwds').attr('disabled', false);
}


async function onCreateLinks() {
    try {
        var selectedValues = $('#select_fwds').val();
        if (selectedValues.length < 1) {
            showMessage({
                icon: 'warning',
                title: 'Thông báo',
                text: 'Hãy chọn ít nhất 1 công ty để liên kết'
            })
        }

        $('#btn-modal-create').html(iconLoadingHtml());
        $('#btn-modal-create').attr('disabled', true);
        let url = window.location.origin + '/manages/sale/fwd/create-link';
        let data = {
            sale_id: pub_sale_id ? pub_sale_id : $('#select_sale').val(),
            fwd_ids: selectedValues
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            $('#btn-modal-create').html('Liên kết');
            $('#btn-modal-create').attr('disabled', false);

            $('#linkFwdModal').modal('hide');
            fetchData()
        }
        showMessage(res.message)
    } catch (error) {
        $('#btn-modal-create').html('Liên kết');
        $('#btn-modal-create').attr('disabled', false);
    }


}

function onDeleteLink(key) {
    try {
        const callback = async () => {
            let url = window.location.origin + '/manages/sale/fwd/delete-link';
            let data = {
                key_id: key
            }
            let res = await ajaxContants2(url, 'POST', data);
            if (res.status == 200) {
                pub_choosed_id = [];
                pub_page = 1;
                $('#keywords-cost').val('');
                fetchData();
            }
            showMessage(res.message);

        }

        onConfirmAction({
            icon: 'question',
            title: 'Thông báo',
            text: `Bạn có chắc muốn xóa fwd này khỏi danh sách?`
        }, callback)
    } catch (error) {
    }
}


$('#btn_export_excel').click(async function () {
    try {
        onLoadingSweet(true);
        let url = window.location.origin + '/manages/sale/fwd/list-link2';
        let data = {
            is_excel: true,
            sale_id: pub_sale_id,
            paginate: {
                page: pub_page,
                limit: pub_limit
            },
            filters: {
                date_range: {
                    start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
                    end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
                },
                keywords: $('#keywords').val()
            }
        };

        let res = await ajaxContants2(url, 'POST', data);

        if (res.status != 200) {
            onLoadingSweet(false);
            return showMessage(res.message);
        }
        let data_ex = res.data;
        let excels = [];
        data_ex.forEach(function (item, index) {
            let _item = {
                "STT": index + 1,
                "Mã công ty": item.company_code,
                "Tên công ty": item.company_name,
                "Sale phụ trách": item.sale_name,
                "Leader team": item.leader_name,
                "CW": item.total_charged_weight,
                "Hoa hồng sale": item.sale_code == item.leader_code ? item.total_leader_cost : item.total_member_cost,
                "Hoa hồng cho leader": item.leader_code && item.sale_code != item.leader_code ? item.total_leader_member_cost : null,
                "Từ ngày": res.start_date,
                "Đến ngày": res.end_date,
            }
            excels.push(_item)
        })

        // Convert your JSON data to a worksheet
        const worksheet = XLSX.utils.json_to_sheet(excels);

        // Define the column widths
        worksheet['!cols'] = [
            { wch: 5 },  // Chiều rộng cho cột "STT"
            { wch: 15 }, // Chiều rộng cho cột "Mã công ty"
            { wch: 30 }, // Chiều rộng cho cột "Tên công ty"
            { wch: 20 }, // Chiều rộng cho cột "Sale phụ trách"
            { wch: 20 }, // Chiều rộng cho cột "Leader team"
            { wch: 10 }, // Chiều rộng cho cột "CW"
            { wch: 20 }, // Chiều rộng cho cột "Hoa hồng sale"
            { wch: 20 },  // Chiều rộng cho cột "Hoa hồng cho leader"
            { wch: 25 }, // Chiều rộng cho cột "Ngày bd"
            { wch: 25 } // Chiều rộng cho cột "Ngày kt"
        ];

        // Create a new workbook and add the worksheet to it
        const workbook = XLSX.utils.book_new();
        XLSX.utils.book_append_sheet(workbook, worksheet, 'Sheet1');

        // Write the workbook to a file
        const excelBuffer = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });

        // Create a Blob and use FileSaver.js to save the file
        const blob = new Blob([excelBuffer], { type: 'application/octet-stream' });
        saveAs(blob, 'danh-sach-fwd.xlsx');
        onLoadingSweet(false);
    } catch (error) {
        onLoadingSweet(false);
        showMessage({
            icon: 'error',
            title: 'Thông báo',
            text: 'Xảy ra lỗi không xác định khi cố gọi lên serve'
        });
        console.log(error);

    }
})