let pub_limit = 50;
let pub_page = 1;
let pub_list_kind = 'leaders'
let pub_leaders_add = [];
let pub_team_id = null;

const SALE_MEMBER = 0;
const SALE_LEADER = 1;

const USERS = 'users'
const LEADERS = 'leaders'

$(document).ready(function () {
    const monthInput = document.getElementById('monthDate');
    // Lấy ngày hiện tại
    const today = new Date();
    const month = (today.getMonth() + 1).toString().padStart(2, '0');
    const year = today.getFullYear();
    monthInput.value = `${year}-${month}`;;

    fetchData(window.location.origin + '/manages/sale/leader-list')

    console.log(document.getElementById('monthDate').value);
})

$('#monthDate').on('change', function (e) {
    fetchData(window.location.origin + '/manages/sale/leader-list')
})

$(document).on('click', '.pagination a', async function (event) {
    event.preventDefault();
    let fullUrl = $(this).attr('href');
    pub_page = fullUrl.split('page=')[1];
    let urlWithoutParams = fullUrl.split('?')[0];

    fetchData(urlWithoutParams);
});

function getStartAndEndDate() {
    const monthInput = document.getElementById('monthDate').value;

    // Nếu người dùng đã chọn tháng
    if (monthInput) {
        const [currentYear, currentMonth] = monthInput.split('-');

        // Ngày bắt đầu và ngày kết thúc của tháng đã chọn
        const startDate = new Date(Date.UTC(currentYear, currentMonth - 1, 1));
        const endDate = new Date(Date.UTC(currentYear, currentMonth, 0));

        // Định dạng ngày theo yyyy-mm-dd
        const formatDate = (date) => date.toISOString().split('T')[0];

        return {
            start_date: formatDate(startDate),
            end_date: formatDate(endDate)
        };
    } else {
        const today = new Date();
        const currentYear = today.getUTCFullYear();
        const currentMonth = today.getUTCMonth();

        // Ngày bắt đầu và ngày kết thúc của tháng hiện tại
        const startDate = new Date(Date.UTC(currentYear, currentMonth, 1));
        const endDate = new Date(Date.UTC(currentYear, currentMonth + 1, 0));

        // Định dạng ngày theo yyyy-mm-dd
        const formatDate = (date) => date.toISOString().split('T')[0];

        return {
            start_date: formatDate(startDate),
            end_date: formatDate(endDate)
        };
    }
}

function onExportSaleTeam(team_id) {
    const monthDate = document.getElementById('monthDate').value;
    const url = window.location.origin + '/manages/sale/export-sale-team' + '?team_id=' + team_id + '&&monthDate=' + monthDate;
    window.open(url, '_blank');
}

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) {
        fetchData(window.location.origin + '/manages/sale/leader-list');
    }
})

$('#keywords-user').on('keypress', function (e) {
    if (e.which === 13) {
        fetchData(window.location.origin + '/manages/sale/leader-users');
    }
})

async function fetchData(url = null) {

    let data = {};
    let loading = true;
    let html_id = '';
    if (pub_list_kind == LEADERS) {
        pub_limit = 8;
        html_id = 'content';
        data = {
            leader_id: pub_leader_id,
            paginate: {
                limit: pub_limit,
                page: pub_page,
            },
            filters: {
                keywords: $('#keywords').val(),
                date_range: getStartAndEndDate()
            }
        }

    } else if (pub_list_kind == USERS) {
        pub_limit = 50;
        loading = false;
        data = {
            paginate: {
                limit: pub_limit,
                page: pub_page,
            },
            position_name: 'sale',
            user_not_in: pub_leaders_add.map(leader => leader.leader_id),
            filters: {
                keywords: $('#keywords-user').val(),
            }
        }
        html_id = 'content-user';
    } else {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Xảy ra lỗi khi thao tác đến serve'
        })
    }


    ajaxPostHTML(url, data, html_id, null, loading);
}

function modalAddLeader(params, team_id = null, text = null) {

    if (params) {
        $('#modalAddLeaderLabel').html('Thêm sale leader');
        pub_team_id = null;
    } else if (!params && team_id) {

        $('#modalAddLeaderLabel').html(text);
        pub_team_id = team_id;
    }
}

// Khi modal được mở
var myModal = document.getElementById('modalAddLeader');
myModal.addEventListener('show.bs.modal', function (event) {
    // Xử lý khi modal được mở
    pub_list_kind = USERS;
    $('#keywords-user').val('');
    let url = window.location.origin + '/manages/sale/leader-users';
    fetchData(url)
});

// Khi modal bị ẩn đi
myModal.addEventListener('hidden.bs.modal', function (event) {
    // Xử lý khi modal bị ẩn đi
    pub_leaders_add = [];
    $('#content-choosed-user').html('');
    pub_list_kind = LEADERS;
    // pub_team_id = null;
    let url = window.location.origin + '/manages/sale/leader-list';
});


function chooseAddLeader(id, code, name, email) {
    const exists = pub_leaders_add.some(leader => leader.leader_id === id);

    if (!exists) {
        // Nếu chưa tồn tại, thêm vào mảng
        let new_leader = {
            leader_id: id,
            leader_code: code,
            leader_name: name,
            leader_email: email,
        };
        pub_leaders_add.push(new_leader);

        renderViewLeaderChoosed()
        $('#leader_key_' + id).remove();

        let url = window.location.origin + '/manages/sale/leader-users';
        fetchData(url)
    }
}

function removeLeaderChoosed(id) {
    const index = pub_leaders_add.findIndex(leader => leader.leader_id === id);

    if (index !== -1) {
        // Nếu phần tử tồn tại, xóa nó khỏi mảng
        pub_leaders_add.splice(index, 1);
        renderViewLeaderChoosed()
        let url = window.location.origin + '/manages/sale/leader-users';
        fetchData(url)
    }
}


function renderViewLeaderChoosed() {
    let html = '';

    pub_leaders_add.forEach(function (leader, index) {
        html = html + `<tr>
                    <td>${leader.leader_code}</td>
                    <td>${leader.leader_name}</td>
                    <td>${leader.leader_email}</td>
                    <td><button class="btn btn-icon btn-soft-danger btn-sm" onclick="removeLeaderChoosed(${leader.leader_id})">
                        <span class="icon"><i class="fas fa-minus"></i></span>
                    </button></td>
                </tr>`
    });



    $('#content-choosed-user').html(html);
}


async function addMiltipleLeader() {

    let data = {
        arr_user_id: pub_leaders_add.map(leader => leader.leader_id),
    }
    let url = window.location.origin + '/manages/sale/add-miltiple-leader';

    if (pub_leader_id || pub_team_id) {
        url = window.location.origin + '/manages/sale/add-miltiple-member';
        data.leader_id = pub_leader_id ?? null;
        data.sale_team_id = pub_team_id ?? null;
    }


    let res = await ajaxContants2(url, 'POST', data);
    if (res.status === 200) {
        pub_page = 1;
        pub_list_kind = LEADERS;
        let url = window.location.origin + '/manages/sale/leader-list';
        fetchData(url);
        $('#close-modal-team').click();
    }

    showMessage(res.message);
}

function kickMemberOutOfTeam(team_id, member_id) {
    const callback = async () => {
        let url = window.location.origin + '/manages/sale/update-member-team';
        let data = {
            team_id: team_id,
            member_id: member_id,
            kind: 0 // 0 là kick
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            let url = window.location.origin + '/manages/sale/leader-list';
            fetchData(url);
        }
        showMessage(res.message);
    }

    onConfirmAction({
        icon: 'warning',
        title: 'Thông báo',
        text: 'Bạn có chắc muốn xóa thành viên này ra khỏi team không không?'
    }, callback);
}

function changeMemberToLeader(team_id, member_id) {
    const callback = async () => {
        let url = window.location.origin + '/manages/sale/update-member-team';
        let data = {
            team_id: team_id,
            member_id: member_id,
            kind: 1 // thăng lên làm leader
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            let url = window.location.origin + '/manages/sale/leader-list';
            fetchData(url);
        }
        showMessage(res.message);
    }

    onConfirmAction({
        icon: 'question',
        title: 'Thông báo',
        text: 'Bạn có chắc muốn chuyển thành viên này thành leader không?'
    }, callback);
}

function onDeleteTeam(team_id) {
    const callback = async () => {
        let url = window.location.origin + '/manages/sale/delete-team';
        let data = {
            team_id: team_id,
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            let url = window.location.origin + '/manages/sale/leader-list';
            fetchData(url);
        }
        showMessage(res.message);
    }

    onConfirmAction({
        icon: 'question',
        title: 'Thông báo',
        text: 'Bạn có chắc chắn muốn xóa team này không?'
    }, callback);
}


function onDeleteTeam(team_id) {
    const callback = async () => {
        let url = window.location.origin + '/manages/sale/delete-team';
        let data = {
            team_id: team_id,
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            let url = window.location.origin + '/manages/sale/leader-list';
            fetchData(url);
        }
        showMessage(res.message);
    }

    onConfirmAction({
        icon: 'question',
        title: 'Thông báo',
        text: 'Bạn có chắc chắn muốn xóa team này không?'
    }, callback);
}

async function transferMemberToTeam(team_id, member_id) {

    let url = window.location.origin + '/manages/sale/leader-list';
    let data = {
        only_id: 'only_id',
        team_id: team_id,
    }

    let res = await ajaxContants2(url, 'POST', data);
    if (res.status != 200) {
        return showMessage(res.message);
    }

    const { value: team } = await Swal.fire({
        icon: 'question',
        title: "Thông báo",
        text: 'Bạn có chắc chắn muốn chuyển thành viên sang nhóm khác không',
        input: "select",
        inputOptions: res.teams,
        inputPlaceholder: "Chọn nhóm bạn muốn chuyển sang",
        showCancelButton: true,
        inputValidator: (value) => {
            return new Promise((resolve) => {
                if (value) {
                    resolve();
                } else {
                    resolve("Bạn cần chọn team để cập nhật");
                }
            });
        }
    });
    if (team) {

        url = window.location.origin + '/manages/sale/transfer-to-team';
        data = {
            member_id: member_id,
            team_id: team,
        }
        console.log(data);

        res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            let url = window.location.origin + '/manages/sale/leader-list';
            fetchData(url);
        }
        showMessage(res.message);
    }
}



