let pub_page = 1;
let pub_limit = 50;
// Lấy phần tử input
if (document.getElementById('monthDate')) {
    document.getElementById('monthDate').value = pub_monthDate;
}

$(document).ready(function () {
    fetchData();
});

function getStartAndEndDate() {
    const monthInput = document.getElementById('monthDate').value;

    // Nếu người dùng đã chọn tháng
    if (monthInput) {
        const [currentYear, currentMonth] = monthInput.split('-');

        // Ngày bắt đầu và ngày kết thúc của tháng đã chọn
        const startDate = new Date(Date.UTC(currentYear, currentMonth - 1, 1));
        const endDate = new Date(Date.UTC(currentYear, currentMonth, 0));

        // Định dạng ngày theo yyyy-mm-dd
        const formatDate = (date) => date.toISOString().split('T')[0];

        return {
            start_date: formatDate(startDate),
            end_date: formatDate(endDate)
        };
    } else {
        const today = new Date();
        const currentYear = today.getUTCFullYear();
        const currentMonth = today.getUTCMonth();

        // Ngày bắt đầu và ngày kết thúc của tháng hiện tại
        const startDate = new Date(Date.UTC(currentYear, currentMonth, 1));
        const endDate = new Date(Date.UTC(currentYear, currentMonth + 1, 0));

        // Định dạng ngày theo yyyy-mm-dd
        const formatDate = (date) => date.toISOString().split('T')[0];

        return {
            start_date: formatDate(startDate),
            end_date: formatDate(endDate)
        };
    }
}


function onFiltersDate() {
    window.location.href = window.location.origin + '/manages/sale/detail' + '?sale_code=' + pub_user_code
        + '&monthDate=' + $('#monthDate').val();
}

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();
});

function fetchData() {

    let url = window.location.origin + '/manages/sale/detail/shipments';
    let data = {
        user_id: pub_user_id,
        page: pub_page,
        limit: pub_limit,
        filters: {
            date_range: getStartAndEndDate(),
        }

    }

    ajaxPostHTML(url, data, 'table-shipments');
}


let pub_shipment_code = null;


function getDetailShipmentCost(data) {

    pub_shipment_code = data.code;

    let body_modal = `
        <div class="row">
            <div class="col-md-6 mb-3">
                <strong>Date: </strong> ${data.created_at}
            </div>
            <div class="col-md-6 mb-3">
                <strong>ID Bill: </strong> <span><a href="">${data.code}</a></span>
            </div>
            <div class="col-md-6 mb-3">
                <strong>Chi nhánh: </strong> ${data.branch}
            </div>
            <div class="col-md-6 mb-3">
                <strong>Dich vụ: </strong> ${data.service}
            </div>
            <div class="col-md-6 mb-3">
                <strong>Người nhận: </strong> ${data.reciver}
            </div>
            <div class="col-md-6 mb-3">
                <strong>Số kiện: </strong> ${data.count_pg}
            </div>
            <div class="col-md-6 mb-3">
                <strong>Charge weight: </strong> ${data.charge_w}
            </div>
            <div class="col-md-6 mb-3">
                <strong>Total: </strong> ${data.total}
            </div>
            <div class="col-md-6 mb-3">
                <label for="" class="form-label">Phụ thu</label>
                <input type="number" class="form-control" id="shipment_amount_surcharge"
                    value="${data.shipment_amount_surcharge}">
                    <small class="text-danger" id="shipment_amount_surcharge_err"></small>
            </div>
            <div class="col-md-6 mb-3">
                <label for="" class="form-label">Nội địa</label>
                <input type="number" class="form-control" id="shipment_domestic_charges"
                    value="${data.shipment_domestic_charges}">
                    <small class="text-danger" id="shipment_domestic_charges_err"></small>
            </div>
            <div class="col-md-6 mb-3">
                <label for="" class="form-label">Thu hộ</label>
                <input type="number" class="form-control" id="shipment_collection_fee"
                    value="${data.shipment_collection_fee}">
                    <small class="text-danger" id="shipment_collection_fee_err"></small>
            </div>
            <div class="col-md-6 mb-3">
                <label for="" class="form-label">Bảo hiển</label>
                <input type="number" class="form-control" id="shipment_amount_insurance"
                    value="${data.shipment_amount_insurance}">
                    <small class="text-danger" id="shipment_amount_insurance_err"></small>
            </div>
            <div class="col-md-6 mb-3">
                <label for="" class="form-label">Vat</label>
                <input type="number" class="form-control" id="shipment_amount_vat"
                    value="${data.shipment_amount_vat}">
                    <small class="text-danger" id="shipment_amount_vat_err"></small>
            </div>
            <div class="col-md-6 mb-3">
                <label for="" class="form-label">Cước gốc</label>
                <input type="number" class="form-control" id="shipment_amount_original"
                    value="${data.shipment_amount_original}">
            </div>
            <div class="col-md-12 mb-3">
                <label for="" class="form-label">Thu tiền khách</label>
                <input type="number" class="form-control" id="shipment_amount_total_customer"
                    value="${data.shipment_amount_total_customer}">
                    <small class="text-danger" id="shipment_amount_total_customer_err"></small>
            </div>
            <div class="col-md-6 mb-3">
                <strong>CPVH: </strong> ${data.shipment_amount_operating_costs}
            </div>
            <div class="col-md-6 mb-3">
                <strong>Status: </strong> ${data.status}
            </div>
            <div class="col-md-6 mb-3">
                <strong>Lợi nhuận: </strong> <span
                    class="text-primary">${data.shipment_amount_profit}</span>
            </div>
            <div class="col-md-6 mb-3">
                <strong>Payment: ${data.payment}
            </div>

        </div>
    `;
    $('#body-modal-content').html(body_modal)
}

$('#on_save_shipment_fee').on('click', async function (e) {
    setTextNullValidate();
    let _url = window.location.origin + '/shipments/update-freight';
    let _data = {
        shipment_code: pub_shipment_code,

        shipment_domestic_charges: $('#shipment_domestic_charges').val(),
        shipment_amount_surcharge: $('#shipment_amount_surcharge').val(),
        shipment_collection_fee: $('#shipment_collection_fee').val(),
        shipment_amount_insurance: $('#shipment_amount_insurance').val(),
        shipment_amount_vat: $('#shipment_amount_vat').val(),
        shipment_amount_original: $('#shipment_amount_original').val(),

        shipment_amount_total_customer: $('#shipment_amount_total_customer').val(),
    }
    let res = await ajaxContants2(_url, 'POST', _data);
    if (res.status == 200) {
        showMessage(res.message);
        $('#close-modal-fee').click();
        fetchData();
    } else if (res.status == 422) {
        var errors = res.error;
        $.each(errors, function (key, value) {
            $('#' + key + '_err').text(value[0]);
        });
    } else {
        showMessage(res.message);
    }
});

$('#editTableModal').on('hidden.bs.modal', function () {
    pub_shipment_code = null;

});

function setTextNullValidate() {
    $('#shipment_domestic_charges_err').text('');
    $('#shipment_amount_surcharge_err').text('');
    $('#shipment_collection_fee_err').text('');
    $('#shipment_amount_insurance_err').text('');
    $('#shipment_amount_vat_err').text('');
    $('#shipment_amount_original_err').text('');

    $('#shipment_amount_total_customer_err').text('');
}


function onExportSale(user_code) {
    const monthInput = document.getElementById('monthDate').value;
    const saleStatistic = document.getElementById('sale_statistic').value;

    const url = window.location.origin + '/manages/sale/detail/report?'
        + `user_code=${user_code}`
        + `&monthDate=${monthInput}`
        + `&sale_statistic=${saleStatistic}`;

    return window.open(url, '_blank');
}