let pub_limit = 50;
let pub_page = 1;


$(window).ready(function () {

    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        }
    }, function (start, end, label) {
        pub_content = CONTENT_LIST;
        fetchData();
    });

    fetchData();
})

$(document).on('click', '.pagination a', async function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();

});

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        fetchData();
    }
})

function fetchData() {
    let url = window.location.origin + '/manages/sale/confirm-account';
    let data = {
        action_kind: public_action_kind,
        paginate: {
            page: pub_page,
            limit: pub_limit
        },
        filters: {
            date_range: {
                start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
                end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
            },
            keywords: $('#keywords').val(),
        }
    };

    ajaxPostHTML(url, data, 'content');

}

function onConfirm(first_id, second_id) {

    const callback = async () => {
        let url = window.location.origin + '/manages/sale/confirm-action';
        let data = {
            action_kind: public_action_kind,
            first_id: first_id, // fwd // member
            second_id: second_id, // sale // sale_team_id
        }

        let res = await ajaxContants2(url, 'POST', data);
        if (res.status == 200) {
            fetchData();
        }
        showMessage(res.message);
    }


    onConfirmAction({
        icon: 'question',
        title: 'Thông báo',
        text: 'Bạn có chắc chắn muốn xác nhận yêu cầu này không?'
    }, callback);
}

function onCancel(key) {
    const callback = async () => {
        let url = window.location.origin + '/manages/sale/cancel-action';
        let data = {
            action_kind: public_action_kind,
            key: key,
        }

        let res = await ajaxContants2(url, 'POST', data);

        if (res.status == 200) {
            fetchData();
        }
        showMessage(res.message);
    }


    onConfirmAction({
        icon: 'question',
        title: 'Thông báo',
        text: 'Bạn có chắc chắn muốn hủy yêu cầu này không?'
    }, callback);
}