let pub_limit = 50;
let pub_page = 1;


$(window).ready(function () {
    fetchData();
})

$(document).on('click', '.pagination a', async function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();

});

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        pub_page = 1;
        fetchData();
    }
})

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        pub_page = 1;
        fetchData();
    }
})

function fetchData() {
    let url = window.location.origin + '/manages/sale/all';
    let data = {
        paginate: {
            page: pub_page,
            limit: pub_limit
        },
        filters: {
            keywords: $('#keywords').val(),
            date_range: getStartAndEndDate(),
        }
    };

    ajaxPostHTML(url, data, 'content');

}

function getStartAndEndDate() {
    const monthInput = document.getElementById('monthDate').value;

    // Nếu người dùng đã chọn tháng
    if (monthInput) {
        const [currentYear, currentMonth] = monthInput.split('-');

        // Ngày bắt đầu và ngày kết thúc của tháng đã chọn
        const startDate = new Date(Date.UTC(currentYear, currentMonth - 1, 1));
        const endDate = new Date(Date.UTC(currentYear, currentMonth, 0));

        // Định dạng ngày theo yyyy-mm-dd
        const formatDate = (date) => date.toISOString().split('T')[0];

        return {
            start_date: formatDate(startDate),
            end_date: formatDate(endDate)
        };
    } else {
        const today = new Date();
        const currentYear = today.getUTCFullYear();
        const currentMonth = today.getUTCMonth();

        // Ngày bắt đầu và ngày kết thúc của tháng hiện tại
        const startDate = new Date(Date.UTC(currentYear, currentMonth, 1));
        const endDate = new Date(Date.UTC(currentYear, currentMonth + 1, 0));

        // Định dạng ngày theo yyyy-mm-dd
        const formatDate = (date) => date.toISOString().split('T')[0];

        return {
            start_date: formatDate(startDate),
            end_date: formatDate(endDate)
        };
    }
}

