getStatiscal()

$(document).ready(function () {
    $('input[name="discount_user_daterange"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(2, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        }
    }, function (start, end, label) {
    });
});


$(document).on('click', '.pagination a', function (event) {
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    event.preventDefault();
    let page = $(this).attr('href').split('page=')[1];
    getListRecharge(page);
});

getListRecharge();

async function getListRecharge(page = 1, limit = 10, url = null) {
    $('#content-recharge').html(onLoadContentHTML);
    try {
        let _url = window.location.origin + '/recharge/list'
        if (url) {
            _url = url;
        }
        let _data = {
            limit: limit,
            page: page,
            get: 'all',
            filters: {
                // start_date: $('#start_date').val(),
                // end_date: $('#end_date').val(),
                discount_start_date: $('input[name="discount_user_daterange"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
                discount_end_date: $('input[name="discount_user_daterange"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
                key_type: $('#key_type').val(),
                keywords: $('#keywords').val(),
                status: $('#status').val()
            }
        }
        ajaxPostHTML(_url, _data, 'content-recharge')
        // let res = await ajaxContants2(_url, "POST", _data);

        // if (res.status == 200) {
        //     $('#content-recharge').html(res.html);

        // } else {
        //     showMessage({
        //         icon: 'error',
        //         title: 'Lỗi',
        //         text: res.message
        //     });
        //     $('#content-recharge').html('<p class="text-center text-secondary">Xảy ra lỗi khi tải dữ liệu</p>');
        // }
    } catch (error) {
        $('#content-recharge').html('<p class="text-center text-secondary">Xảy ra lỗi khi tải dữ liệu</p>');
    }
}

function onFail(key) {

    let alert = {
        icon: 'warning',
        title: 'Thông báo',
        text: 'Bạn có chắc chắn muốn hủy bỏ yêu cầu này không'
    }

    actionRecharge('fail', key, alert)
}

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        getListRecharge();
    }
})

function onSuccess(key) {

    let alert = {
        icon: 'warning',
        title: 'Thông báo',
        text: 'Bạn có muốn xác nhận giao dịch thành công với yêu cầu này không'
    }

    actionRecharge('success', key, alert)
}



fixInpSweet()

function actionRecharge(type, key, alert) {
    const callback = async (text) => {
        // confirmFail(key)
        let _url = window.location.origin + "/recharge/detail/" + type;
        let _data = {
            key: key,
            admin_note: text
        };

        let res = await ajaxContants2(_url, "POST", _data);
        if (res.status === 200) {
            showMessage({
                icon: "success",
                title: "Thông báo",
                text: res.message
            });
            showDetail(key);
            getListRecharge();
        } else {
            showMessage({
                icon: "error",
                title: "Thông báo",
                text: res.message
            });
        }
    }


    onConfirmActionWithInp(alert, callback);
}



function showDetail(key) {

    let _url = window.location.origin + '/recharge/detail'
    let _data = {
        recharge_id: key,
    };
    ajaxPostHTML(_url, _data, 'content-recharge-detail');
}

$("#adminRechargeDropzone").dropzone({
    url: "/fake/location",
    autoProcessQueue: false,
    paramName: "file",
    clickable: true,
    maxFilesize: 1,
    addRemoveLinks: true,
    acceptedFiles: '.png,.jpg',
    dictDefaultMessage: "Tải hình ảnh ở đây",
    init: function () {
        this.on("complete", function (file) {

        });
        this.on("addedfile", function (file) {
            adminRechargeDropzone = file;
        });
        this.on("removedfile", function (file) {

        });
    }
})



async function onCreateRechargeAdmin() {
    try {
        emptyVal();
        let image = Dropzone.forElement("#adminRechargeDropzone").files[0];


        let _url = window.location.origin + "/recharge/create";

        let _data = {
            amount: convertStringToNumber($("#admin_amount_recharge").val()),
            note: $("#admin_note_recharge").val(),
            created_by: 'admin',
            image: null,
            type: 0,
            user_id: $('#recharge-user').val(),
        }
        
        
        // cho thanh toán VNPAY
        _data.type = $('input[name="admin_pay_kind"]:checked').val();
        if ($('#admin_pay_vnpay').is(':checked')) {
            _url = window.location.origin + "/sepay/recharge";
        } else {
            _data.image = Dropzone.forElement("#adminRechargeDropzone").files[0];
            if (!_data.image) {
                return showMessage({
                    icon: 'warning',
                    tittle: 'Thông báo',
                    text: 'Cần phải có hình ảnh'
                })
            }
        }
        if (!image && _data.type != 1) {
            $('#admin_image_recharge_err').text('Không được để trống hình ảnh');
            $('#admin_image_recharge_err').addClass('d-block');
            return
        }

        let res = await ajaxContants(_url, "POST", _data);
        if (res.status == 200) {
            if (res.url) {
                window.location.href = res.url;
            }
            showMessage({
                icon: "success",
                title: "Thành công",
                text: res.message
            });
            Dropzone.forElement("#adminRechargeDropzone").removeAllFiles(true);
            getListRecharge();
            $("#admin_amount_recharge").val('')
            $("#admin_note_recharge").val('')
        } else {
            if (res.status == 422) {
                var errors = res.error; // Lấy thông điệp lỗi từ phản hồi JSON
                $.each(errors, function (key, value) {
                    // Hiển thị thông điệp lỗi tương ứng với mỗi trường
                    $('#admin_' + key + '_recharge_err').text(value[0]);
                    $('#admin_' + key + '_recharge_err').addClass('d-block');
                });
            } else {
                showMessage({
                    icon: "error",
                    title: "Thất bại",
                    text: res.message
                });
            }

        }

    } catch (error) {
        console.log(error);

    }
}

function emptyVal() {
    $('#recharge-user_err').text('');
    $('#recharge-user_err').removeClass('d-block')
    $('#admin_amount_recharge_err').text('');
    $('#admin_amount_recharge_err').removeClass('d-block')
    $('#admin_note_recharge_err').text('');
    $('#admin_note_recharge_err').removeClass('d-block')
    $('#admin_image_recharge_err').text('');
    $('#admin_image_recharge_err').removeClass('d-block')
}

$('input[name="discount_user_daterange"]').on('apply.daterangepicker', function (ev, picker) {
    getStatiscal()
});

async function getStatiscal() {

    let discount_start_date = $('input[name="discount_user_daterange"]').data('daterangepicker').startDate.format('DD-MM-YYYY')
    let discount_end_date = $('input[name="discount_user_daterange"]').data('daterangepicker').endDate.format('DD-MM-YYYY')


    let _url = window.location.origin + "/recharge/statistical";
    let _data = {
        start_date: discount_start_date,
        end_date: discount_end_date,
        kind: $('#kind_chart').val(),
        status: $('#status_chart').val()
    };


    let res = await ajaxContants2(_url, "POST", _data);

    if (res.status === 200) {
        if (res.data.revenue_chart.length > 0) {
            chartColum("column_chart_1", res.data)
        } else {
            $('#column_chart_1').html('<div class="text-center">Không có dữ liệu</div>')
        }
    } else {
        showMessage({
            icon: 'error',
            title: 'Thông báo',
            text: 'Xảy ra lỗi'
        })
    }
}
var chart;
function chartColum(id, data) {
    if (chart) {
        chart.destroy();
    }
    var options = {
        series: [{
            name: data.name_tbl,
            data: data.revenue_chart
        }],
        chart: {
            type: 'bar',
            height: 350
        },
        plotOptions: {
            bar: {
                horizontal: false,
                columnWidth: '55%',
            },
        },
        dataLabels: {
            enabled: false
        },
        stroke: {
            show: true,
            width: 2,
            colors: ['transparent']
        },
        xaxis: {
            categories: data.name_chart,
        },
        // yaxis: {
        //     title: {
        //         text: "Doanh thu "
        //     }
        // },
        yaxis: {
            title: {
                text: ""
            },
            labels: {
                formatter: function (value) {
                    return value.toLocaleString() + " vnd"; // Định dạng số với dấu phân cách hàng nghìn
                },
            },
        },
        fill: {
            opacity: 1
        },
        tooltip: {
            y: {
                formatter: function (val) {
                    return val.toLocaleString() + " vnd"
                }
            }
        }
    };

    chart = new ApexCharts(document.querySelector("#" + id), options);
    chart.render();
}


function getWalletFlut() {

}

$(document).ready(function () {
    editor.plugins.get('FileRepository').createUploadAdapter = (loader) => {
        return {
            upload: () => {
                return loader.file
                    .then(file => new Promise((resolve, reject) => {
                        const reader = new FileReader();
                        reader.readAsDataURL(file);
                        reader.onload = () => resolve({
                            default: reader.result
                        });
                        reader.onerror = error => reject(error);
                    }));
            }
        };
    };
});

let editor;
ClassicEditor
    .create(document.querySelector('#editor'), {
        mediaEmbed: {
            previewsInData: true
        },
    })
    .then(newEditor => {
        editor = newEditor;
    })
    .catch(error => {
        console.error(error);
    });


let setting = {};
getRechargeSetting();
async function getRechargeSetting() {
    let _url = window.location.origin + '/recharge/setting';
    let _data = {};

    let res = await ajaxContants2(_url, 'GET', _data);
    setting = res.setting;
}



let setting_kind = '';
function onSetContentPayment(kind, key) {
    $('#content-usdt-inp').html('');
    setting_kind = kind;
    let content = JSON.stringify(setting[key].content);
    editor.setData(JSON.parse(content));

    if (kind == 2) {
        let data = JSON.stringify(setting[key].data);
        data = JSON.parse(data)
        $('#content-usdt-inp').html(`
            <div class="mb-3">
                        <label for="usdt_price_convert" class="form-label">Mệnh giá quy đổi trên mỗi USDT</label>
                        <input type="number" value="${data.price ?? 0}" class="form-control" id="usdt_price_convert">
                        <div id="usdt_price_convert_err" class="form-text">Lưu ý giá trị không được bé hơn 0</div>
                    </div>    
        `)
        $('#title-setting-modal').text(JSON.stringify(setting[key].title))
    }
}
// $('#setting-usdt').on('click', function () {
//     setting_kind = 2;
//     let content = JSON.stringify(setting.usdt.content);
//     let data = JSON.stringify(setting.usdt.data);
//     data = JSON.parse(data)

//     editor.setData(JSON.parse(content));
//     $('#content-usdt-inp').html(`
//         <div class="mb-3">
//                     <label for="usdt_price_convert" class="form-label">Mệnh giá quy đổi trên mỗi USDT</label>
//                     <input type="number" value="${data.price ?? 0}" class="form-control" id="usdt_price_convert">
//                     <div id="usdt_price_convert_err" class="form-text">Lưu ý giá trị không được bé hơn 0</div>
//                 </div>    
//     `)
//     $('#title-setting-modal').text('Cài đặt thanh toán qua USDT')
// });
// $('#setting-vnpay').on('click', function () {
//     $('#content-usdt-inp').html('');
//     setting_kind = 1;
//     let content = JSON.stringify(setting.vnpay.content);
//     editor.setData(JSON.parse(content));
//     $('#title-setting-modal').text('Cài đặt thanh toán qua VNPAY')
// });
// $('#setting-direct').on('click', function () {
//     $('#content-usdt-inp').html('');
//     setting_kind = 0;
//     let content = JSON.stringify(setting.direct.content);
//     editor.setData(JSON.parse(content));
//     $('#title-setting-modal').text('Cài đặt thanh toán trực tiếp')
// });

$('#save_setting').on('click', async function () {
    try {
        let _url = window.location.origin + '/recharge/setting';
        let _data = {
            kind: setting_kind,
            usdt_price_convert: $('#usdt_price_convert').val() ?? 0,
            content: editor.getData(),
        }

        let res = await ajaxContants2(_url, 'POST', _data);

        if (res.status == 200) {
            editor.getData('');
            getRechargeSetting();
        }
        showMessage(res.message);

    } catch (error) {
        showMessage({
            icon: 'error',
            title: 'Thông báo',
            text: 'Xảy ra lỗi không xác định'
        });
    }

})