let limit = 50, page = 1, _url = window.location.origin + '/initiallize-label-history';

$(document).ready(function () {
    $(".select2").select2();

    $('input[name="initiallize_label_history_daterange"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {
        onGetInitiallizeLabelHistories();
    });

    onGetInitiallizeLabelHistories();
});

$(document).on('click', '.btn-detail-initiallize-label-history', function () {
    const value = $(this).data();
    const result_call_api = value.result_call_api;
    const initiallize_label_history_kind = value.initiallize_label_history_kind;
    console.log(result_call_api);

    let html = '';
    switch (initiallize_label_history_kind) {
        case 0:
            html = `<p><b>Loại mã lỗi:</b> Không tìm thấy API thích hợp</p>`;
            break;
        case 1:
            html = `
                <div class="text-start p-3">
                    <p><b>Code:</b> ${result_call_api['status']}</p>
                    <p><b>Message:</b> ${result_call_api['message']}</p>
                </div> 
            `;
            break;
        case 2:
        case 3:
            html = `
                <div class="text-start p-3">
                    <p><b>Code:</b> ${result_call_api['errorCode']}</p>
                    <p><b>Message:</b> ${result_call_api['errorMessage']}</p>
                </div> 
            `;
            break;
        case 4:
        case 11:
        case 12:
            $.each(result_call_api['errors'], function (key, value) {
                html += `
                    <div class="text-start p-3 border-bottom">
                        <p><b>Code:</b> ${value['code']}</p>
                        <p><b>Message:</b> ${value['message']}</p>
                    </div>
                `;
            });
            break;
        case 5:
            $.each(result_call_api['errors'], function (key, value) {
                html += `
                    <div class="text-start p-3 border-bottom">
                        <p><b>Code:</b> ${value['code']}</p>
                        <p><b>Message:</b> ${value['message']}</p>
                    </div>
                `;
            });
            break;
        case 6:
        case 7:
        case 8:
            html = `
                <div class="text-start p-3">
                    <p><b>Code:</b> ${result_call_api['code']}</p>
                    <p><b>Message:</b> ${result_call_api['message']}</p>
                </div> 
            `;
            break;
    }

    Swal.fire({
        title: 'Thông tin chi tiết lỗi',
        html: `${html}`,
        icon: 'info',
    });
});

$(document).on('click', '.btn-delete-initiallize-label-history', function () {
    const value = $(this).data();
    const initiallize_label_history_id = value.initiallize_label_history_id;
    Swal.fire({
        title: 'Xác nhận xóa',
        text: "Bạn có chắc chắn muốn xóa lịch sử này không?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Xóa',
        cancelButtonText: 'Hủy',
    }).then(async (result) => {
        if (result.isConfirmed) {
            const result = await agreeDeleteInitiallizeLabelHistory(initiallize_label_history_id);
            onGetInitiallizeLabelHistories();
            showMessage(result.message);
        }
    });
});

async function agreeDeleteInitiallizeLabelHistory(initiallize_label_history_id) {
    try {
        const result = await sendRequest(`${_url}/delete`, 'POST', { 'initiallize_label_history_id': initiallize_label_history_id });
        return result;
    } catch (error) {
        showMessage(error.message);
    }
}

$(document).on('change', '[name="initiallize_label_history_keywords"]', function () {
    onGetInitiallizeLabelHistories();
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    onGetInitiallizeLabelHistories();
});

function getFilters() {
    return {
        date_range: {
            start_date: $('input[name="initiallize_label_history_daterange"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="initiallize_label_history_daterange"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        },
        keywords: $('[name="initiallize_label_history_keywords"]').val(),
    }
}

async function onGetInitiallizeLabelHistories() {
    $('#show_table_content').html('');
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    try {
        let data = {
            is_api: false,
            limit: limit,
            page: page,
            filters: JSON.stringify(Object.assign({}, getFilters())),
        };
        const result = await sendRequest(`${_url}/pagination`, 'POST', data);
        if (result.status == 200) {
            $('#show_table_content').html(result.html);
        }
        $('#loading_show_table_content').removeClass('d-block');
        $('#loading_show_table_content').addClass('d-none');
    } catch (error) {
        $('#loading_show_table_content').removeClass('d-block');
        $('#loading_show_table_content').addClass('d-none');
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}