let limit = 50;
let page = 1;

function getFilters() {
    return {
        keywords: $('#keywords').val(),
        filter_by: $('#filter_by').val(),
        debit_type: $('#debit_type').val(),
        debit_status: $('#debit_status').val(),
        debit_account: 0,
        date_range: {
            start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        },
        admin_confirm: $('#admin_confirm').val(),
    }
}

$(document).ready(function () {
    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {
        page = 1;
        fetchData();
    });

   

});


$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        page = 1;
        fetchData();
    }
})


$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    fetchData();
});

$('#debit_status, #debit_type, #admin_confirm').on('change', function () {
    page = 1;
    fetchData();
});

$(document).ready(function () {
    fetchData()
});

function fetchData(_url = null, _page = null, _limit = null, filters = null) {
    if (!_url) {
        _url = window.location.origin + '/debit/list'
    }

    let _data = {
        paginate: {
            limit: _limit === null ? limit : _limit,
            page: _page === null ? page : _page,
        },
        filters: filters === null ? getFilters() : filters,
    }

    const callback = (res) => {
        let header_debit = res.header_debit;
        $('#debit_pedding').text(`(${header_debit.number_pendding} đơn) ` + header_debit.price_pendding.toLocaleString() + ' vnd ');
        $('#debit_success').text(`(${header_debit.number_success} đơn) ` + header_debit.price_success.toLocaleString() + ' vnd ');
        $('#debit_warning').text(`(${header_debit.number_warning} đơn) ` + header_debit.price_warning.toLocaleString() + ' vnd ');

        let dataChart = res.chart;
        createChart(dataChart);
    }


    ajaxPostHTML(_url, _data, 'content', callback)
}


function onPaymentDebit(debit_no) {

    const callback = async () => {

        let _url = window.location.origin + '/debit/payment';
        let _data = {
            debit_no: debit_no
        }

        let res = await ajaxContants2(_url, "POST", _data);

        if (res.status === 200) {
            fetchData();
        } else {

        }
        showMessage(res.message)
    }

    onConfirmAction({
        icon: 'warning',
        title: 'Thông báo',
        text: 'Xác nhận thanh toán công nợ'
    }, callback)


}

async function getDataExcel() {
    $('#btn_excel').html(iconLoadingHtml())
    let _url = window.location.origin + '/debit/list'
    let data = {
        filters: getFilters(),
        export_excel: true
    };
    const result = await sendRequest(_url, 'POST', data);
    if (result.status == 200) {
        await exportExcel(result.excels);
    } else {
        showMessage(res.message)
    }
    $('#btn_excel').html('<i class="fas fa-file-excel"></i>')

}

async function exportExcel(_excels) {
    if (_excels.length < 1) {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Không có dữ liệu để xuất'
        })
    }

    let excels = [];

    _excels.forEach(function (item, index) {
        let _item = {
            ThoiGian: convertTimeFormat(item.created_at),
            DebitNo: item.debit_no,
            Company: item.customer_company,
            NguoiTao: item.creator_name,
            Loai: item.type_label,
            TrangThai: item.status_label,
            MaKhach: item.customer_code,
            TongVat: item.total_vat,
            TongTien: item.total_price,
        }
        excels.push(_item)
    })


    const worksheet = XLSX.utils.json_to_sheet(excels);


    // Đặt độ rộng cho các cột
    worksheet['!cols'] = [
        { wpx: 150 },
        { wpx: 150 },
        { wpx: 300 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
    ];


    // Tạo một workbook mới và thêm worksheet vào
    const workbook = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(workbook, worksheet, 'Sheet1');

    // Xuất workbook ra file Excel
    const excelBuffer = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });

    // Tạo một Blob và sử dụng FileSaver.js để lưu file
    const blob = new Blob([excelBuffer], { type: 'application/octet-stream' });
    saveAs(blob, 'debit.xlsx');
}

var chart = null;
function createChart(data) {
    if (chart) {
        chart.destroy();
    }
    var options = {
        series: data.series,
        chart: {
            width: 380,
            type: 'pie',
        },
        colors: data.colors,
        labels: data.labels,
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    width: 200
                },
                legend: {
                    position: 'bottom'
                }
            }
        }]
    };

    chart = new ApexCharts(document.querySelector("#pie_chart_1"), options);
    chart.render();
}

async function onAcountantConfimInDebit(id) {
    Swal.fire({
        title: "Thông báo",
        text: "Bạn có chắc chắn với việc duyệt tất cả đơn shipment trong này không?",
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Xác nhận",
        cancelButtonText: "Hủy",
    }).then(async (result) => {
        if (result.isConfirmed) {
            try {
                let url = window.location.origin + '/debit/accountant-confirm';
                let data = { debit_id: id };
                let res = await ajaxContants2(url, 'POST', data);
                console.log(res);

                if (res.status == 200) {
                    fetchData();
                }
                showMessage(res.message);
            } catch (error) {
                showMessage(res.message);
            }
        }
    });
}