let pub_limit = 50;
let pub_page = 1;

function getFilters() {
    return {
        keywords: $('#keywords').val(),
        debit_status: $('#debit_status').val(),
        date_range: {
            start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        },
    }
}

$(document).ready(function () {
    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {
        pub_page = 1;
        fetchData();
    });

});


$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        fetchData();
    }
})


$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();
});


$(document).ready(function () {
    fetchData()
});

function fetchData() {

    const url = window.location.origin + '/debit/fwd-paginate'

    const data = {
        paginate: {
            limit: pub_limit,
            page: pub_page,
        },
        filters: getFilters(),
    }

    ajaxPostHTML(url, data, 'content');
}




async function getDataExcel() {
    $('#btn_excel').html(iconLoadingHtml())
    let _url = window.location.origin + '/debit/list-fwd'
    let data = {
        filters: getFilters(),
        export_excel: true
    };
    const result = await sendRequest(_url, 'POST', data);
    if (result.status == 200) {
        await exportExcel(result.excels);
    } else {
        showMessage(res.message)
    }
    $('#btn_excel').html('<i class="fas fa-file-excel"></i>')

}

async function exportExcel(_excels) {
    if (_excels.length < 1) {
        return showMessage({
            icon: 'warning',
            title: 'Thông báo',
            text: 'Không có dữ liệu để xuất'
        })
    }

    let excels = [];

    _excels.forEach(function (item, index) {
        let _item = {
            ThoiGian: convertTimeFormat(item.created_at),
            DebitNo: item.debit_no,
            Company: item.customer_company,
            NguoiTao: item.creator_name,
            Loai: item.type_label,
            TrangThai: item.status_label,
            MaKhach: item.customer_code,
            TongVat: item.total_vat,
            TongTien: item.total_price,
        }
        excels.push(_item)
    })

    const worksheet = XLSX.utils.json_to_sheet(excels);


    // Đặt độ rộng cho các cột
    worksheet['!cols'] = [
        { wpx: 150 },
        { wpx: 150 },
        { wpx: 300 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
        { wpx: 100 },
    ];


    // Tạo một workbook mới và thêm worksheet vào
    const workbook = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(workbook, worksheet, 'Sheet1');

    // Xuất workbook ra file Excel
    const excelBuffer = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });

    // Tạo một Blob và sử dụng FileSaver.js để lưu file
    const blob = new Blob([excelBuffer], { type: 'application/octet-stream' });
    saveAs(blob, 'debit.xlsx');
}

