let limit = 50;
let page = 1;

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        fetchData();
    }
})

$(document).ready(function () {
    $('input[name="shipment_daterange"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {
    });
    fetchData()
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    fetchData();
});


function fetchData() {
    try {
        let url = window.location.origin + '/debit/detail-shipment';
        let data = {
            paginate: {
                limit: limit,
                page: page,
            },
            filters: {
                keywords: $('#keywords').val(),
                date_range: {
                    start_date: $('input[name="shipment_daterange"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
                    end_date: $('input[name="shipment_daterange"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
                },
                shipment_branch_id: $('[name="shipment_branch_id"]').val(),
                shipment_status: $('[name="shipment_status"]').val(),
            },
            user_id: pub_user_id
        }


        ajaxPostHTML(url, data, 'content')
        console.log(11111111111);
    } catch (error) {
        console.log(error);
    }
}