function htmlCountAccount() {
    let selectUser = $("#select-user").val();
    if (selectUser) {
        $(".card-user").addClass("d-none");
        $(".card-user").removeClass("d-block");
    } else {
        $(".card-user").addClass("d-block");
        $(".card-user").removeClass("d-none");
    }
}

$("#search-dashboard").click(function () {
    htmlCountAccount();
});

$(document).ready(function () {
    $(".select2").select2();
    $('input[name="datetimes"]').daterangepicker(
        {
            opens: "left",
            startDate: moment().subtract(3, "months").startOf("month"),
            endDate: moment().endOf("month"),
            locale: {
                format: "DD/MM/YYYY",
                applyLabel: "Áp dụng",
                cancelLabel: "Hủy",
                customRangeLabel: "Tùy chỉnh",
                daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                monthNames: [
                    "Tháng 1",
                    "Tháng 2",
                    "Tháng 3",
                    "Tháng 4",
                    "Tháng 5",
                    "Tháng 6",
                    "Tháng 7",
                    "Tháng 8",
                    "Tháng 9",
                    "Tháng 10",
                    "Tháng 11",
                    "Tháng 12",
                ],
            },
            ranges: {
                "Hôm nay": [moment(), moment()],
                "Tuần này": [moment().startOf("week"), moment().endOf("week")],
                "Tháng này": [
                    moment().startOf("month"),
                    moment().endOf("month"),
                ],
                "Tháng trước": [
                    moment().subtract(1, "month").startOf("month"),
                    moment().subtract(1, "month").endOf("month"),
                ],
                "3 tháng trước": [
                    moment().subtract(3, "month").startOf("month"),
                    moment().subtract(1, "month").endOf("month"),
                ],
                "6 tháng trước": [
                    moment().subtract(6, "month").startOf("month"),
                    moment().subtract(1, "month").endOf("month"),
                ],
                "Năm nay": [moment().startOf("year"), moment().endOf("year")],
                "Năm trước": [
                    moment().subtract(1, "year").startOf("year"),
                    moment().subtract(1, "year").endOf("year"),
                ],
            },
        },
        function (start, end, label) { }
    );

    fetchData();
    $(document).on(
        "change",
        "#datetimes-dashboard, #position_id, #shipment_status, #branch_id, #service_id, #chart-type-date, #chart-type-total",
        function () {
            fetchData();
        }
    );
});

async function fetchData() {
    try {
        let url = window.location.origin + "/dashboard";
        const startDate = $('input[name="datetimes"]').data(
            "daterangepicker"
        ).startDate;
        const endDate = $('input[name="datetimes"]').data(
            "daterangepicker"
        ).endDate;
        let data = {
            chart_type_date: $("#chart-type-date").val(),
            chart_type_total: $("#chart-type-total").val(),
            filters: {
                position_id: $("#position_id").val(),
                shipment_status: $("#shipment_status").val(),
                shipment_branch_id: $("#branch_id").val(),
                shipment_service_id: $("#service_id").val(),
                date_range: {
                    start_date: startDate.format("DD-MM-YYYY"),
                    end_date: endDate.format("DD-MM-YYYY"),
                },
            },
        };

        const result = await sendRequest(url, "POST", data);

        if (result.status === 200) {
            $("#title_chart_overview").html(
                `Biểu đồ tổng quan từ ${startDate.format(
                    "DD/MM/YYYY"
                )} đến ${endDate.format("DD/MM/YYYY")}`
            );
            const data = result.data;
            loadStackedColumnChart(data);

            $("#number_bill").html(
                formatNumberThousand(result.total_number_bill)
            );
            let total_weight = result.total_weight ?? 0;
            let total_price = result.total_price ?? 0;
            $("#total_weight").html(formatNumberThousand(total_weight.toFixed(1)));
            $("#total_price").html(formatNumberThousand(total_price.toFixed(1)));

            // $("#total_price_customer").html(
            //     formatNumberThousand(result.total_price_customer)
            // );

            $("#created").html(formatNumberThousand(result.total_created));
            $("#per_created").html(result.per_created);

            $("#imported").html(formatNumberThousand(result.total_imported));
            $("#per_imported").html(result.per_imported);

            $("#exported").html(formatNumberThousand(result.total_exported));
            $("#per_exported").html(result.per_exported);

            $("#returned").html(formatNumberThousand(result.total_returned));
            $("#per_returned").html(result.per_returned);

            if (result.user) {
                let user = result.user;
                $("#user_remaining_limit2").html(
                    user.user_remaining_limit.toLocaleString()
                );
                $("#user_limit_amount_for_sale2").html(
                    user.limit_amount_flg == 1
                        ? user.user_limit_amount_for_sale.toLocaleString()
                        : "Không giới hạn"
                );
                createChartLimit(
                    user.user_remaining_limit,
                    user.user_limit_amount_for_sale,
                    user.limit_amount_flg
                );
            }

            if (result.chart_credits) {
                const chart_credits = result.chart_credits;

                $('#total_value_packages').html(formatNumberThousand(chart_credits.total_value_packages ?? 0));
                $('#total_goods_compensations').html(formatNumberThousand(chart_credits.total_goods_compensations ?? 0));
                $('#total_credits').html(formatNumberThousand(chart_credits.total_credits ?? 0));
                createChartCredit(chart_credits.data);
            }
            if (result.chart_manager_money) {
                const chart_manager_money = result.chart_manager_money;
                loadManagerMoneyChart(chart_manager_money);
            }
        } else {
            showMessage(result.message);
        }
    } catch (error) {
        showMessage(error.message);
    }
}

let chart_limit = null;

function createChartLimit(start, end, limit_amount_flg) {
    let number = 100;
    if (!chart_limit) {
        // Tính giá trị phân số
        let fraction = start / end;

        // Chuyển đổi thành phần trăm
        let percentage = fraction * 100;

        // Làm tròn đến hai chữ số thập phân
        number = percentage.toFixed(2);
        number = limit_amount_flg == 1 ? number : 0;

        if (chart_limit) {
            chart_limit.destroy();
        }
        /*Gradient Chart*/
        var options3 = {
            series: [number],
            chart: {
                height: 350,
                type: "radialBar",
                toolbar: {
                    show: true,
                },
            },
            plotOptions: {
                radialBar: {
                    startAngle: -135,
                    endAngle: 225,
                    hollow: {
                        margin: 0,
                        size: "60%",
                        background: "#fff",
                        image: undefined,
                        imageOffsetX: 0,
                        imageOffsetY: 0,
                        position: "front",
                        dropShadow: {
                            enabled: true,
                            top: 3,
                            left: 0,
                            blur: 4,
                            opacity: 0.24,
                        },
                    },
                    track: {
                        background: "#fff",
                        strokeWidth: "67%",
                        margin: 0, // margin is in pixels
                        dropShadow: {
                            enabled: true,
                            top: -3,
                            left: 0,
                            blur: 4,
                            opacity: 0.35,
                        },
                    },

                    dataLabels: {
                        show: true,
                        name: {
                            offsetY: -10,
                            show: true,
                            color: "#888",
                            fontSize: "17px",
                        },
                        value: {
                            formatter: function (val) {
                                return parseInt(val) + " %";
                            },
                            color: "#111",
                            fontSize: "36px",
                            show: true,
                        },
                    },
                },
            },
            fill: {
                type: "gradient",
                gradient: {
                    shade: "dark",
                    type: "horizontal",
                    shadeIntensity: 0.5,
                    gradientToColors: ["#ABE5A1"],
                    inverseColors: true,
                    opacityFrom: 1,
                    opacityTo: 1,
                    stops: [0, 100],
                },
            },
            stroke: {
                lineCap: "round",
            },
            labels: ["Nợ/Giới hạn"],
            colors: ["#1ab7ea", "#0084ff", "#39539E", "#0077B5"],
        };

        chart_limit = new ApexCharts(
            document.querySelector("#chart_limit"),
            options3
        );
        chart_limit.render();
    }
}

var column_chart_2 = null;
async function loadStackedColumnChart(data) {
    if (column_chart_2) {
        column_chart_2.updateOptions({
            series: data.series,
            xaxis: {
                categories: data.categories,
            },
            legend: {
                show: true,
                position: "top",
            },
        });
    } else {
        var options1 = {
            series: data.series,
            chart: {
                type: "bar",
                height: 250,
                stacked: true,
                toolbar: {
                    show: true,
                },
                zoom: {
                    enabled: true,
                },
            },

            plotOptions: {
                bar: {
                    horizontal: false,
                    columnWidth: "35%",
                    borderRadius: 5,
                },
            },
            xaxis: {
                categories: data.categories,
            },
            legend: {
                show: true,
                position: "top",
            },
            colors: ["#007D88", "#25cba1", "#ebf3fe"],
            fill: {
                opacity: 1,
            },
            dataLabels: {
                enabled: false,
            },
        };
        column_chart_2 = new ApexCharts(
            document.querySelector("#column_chart_2"),
            options1
        );
        column_chart_2.render();
    }
}

var chart_area_credits = null;
function createChartCredit(data) {

    // Hàm xử lý dữ liệu
    function processStackedData(data, key) {
        return data.map(item => {
            return {
                x: item.date, // Sử dụng ngày làm nhãn trục X
                y: item[key]  // Giá trị của key
            };
        });
    }



    // Cấu hình biểu đồ
    var options3 = {
        series: [
            {
                name: "Giá trị gói",
                data: processStackedData(data, "value_packages")
            },
            {
                name: "Tiền bồi thường",
                data: processStackedData(data, "goods_compensations")
            }
        ],
        chart: {
            type: 'bar',
            height: 250,
            stacked: true,

            toolbar: {
                show: false, // Hiển thị toolbar
                tools: {
                    download: true, // Nút tải xuống (export)
                    selection: true, // Nút chọn vùng
                    zoom: true, // Nút phóng to
                    zoomin: true, // Nút zoom in
                    zoomout: true, // Nút zoom out
                    pan: true, // Nút di chuyển
                    reset: true // Nút đặt lại
                },
            }
        },
        plotOptions: {
            bar: {
                horizontal: false,
                columnWidth: "35%",
                borderRadius: 5,
            },
        },
        colors: ['#FF0000', '#00E396'],
        dataLabels: {
            enabled: false
        },
        stroke: {
            curve: 'smooth',
            width: 2
        },
        fill: {
            opacity: 1,
        },
        legend: {
            position: 'top',
            horizontalAlign: 'left'
        },
        xaxis: {
            type: 'category', // Sử dụng nhãn dạng danh mục (category)
            labels: {
                rotate: -45 // Xoay nhãn để tránh bị chồng lấn
            }
        },
        yaxis: {
            labels: {
                formatter: function (value) {
                    return formatNumberThousand(value); // Chia cho 1,000,000 và thêm "M"
                }
            },
        },
        tooltip: {
            y: {
                formatter: function (value) {
                    return value.toLocaleString(); // Định dạng giá trị trong tooltip với dấu phẩy
                }
            }
        }
    };

    if (chart_area_credits) {
        chart_area_credits.updateOptions(options3);
    } else {
        // Khởi tạo biểu đồ
        chart_area_credits = new ApexCharts(document.querySelector("#area_chart_credit"), options3);
        chart_area_credits.render();
    }


}

let managerMoneyChart = null;
async function loadManagerMoneyChart(data) {
    let fwd_cash = data.fwd_cash;
    let fwd_bank = data.fwd_bank;
    let sale_cash = data.sale_cash;
    let sale_bank = data.sale_bank;

    // $('#content_manager_money_chart').html('');
    var pub_chart = null;
    if (pub_chart) {
        pub_chart.destroy();
    }

    var options = {
        series: [fwd_cash, fwd_bank, sale_cash, sale_bank],
        chart: {
            type: 'pie',
        },
        colors: ['#ff3d3d', '#007D88', '#FFFF00', '#00FF00'],
        labels: ['Fwd tiền mặt', 'Fwd chyển khoản', 'Sale tiền mặt', 'Sale chyển khoản'],
        legend: {
            position: 'bottom' // Đặt labels ở phía dưới
        },
        tooltip: {
            y: {
                formatter: function (value) {
                    return value
                        .toLocaleString(); // Sử dụng hàm formatNumber đã định nghĩa trước đó
                }
            }
        },
        responsive: [{
            breakpoint: 480,
            options: {
                chart: {
                    width: 200
                },
                legend: {
                    position: 'bottom'
                }
            }
        }]
    };

    if (managerMoneyChart) {
        managerMoneyChart.updateOptions(options);
    } else {
        // Khởi tạo biểu đồ
        managerMoneyChart = new ApexCharts(document.querySelector("#content_manager_money_chart"), options);
        managerMoneyChart.render();
    }



    let total_cash = fwd_cash + fwd_bank + sale_cash + sale_bank;

    $('#fwd_cash').html(fwd_cash.toLocaleString() + ' vnd');
    $('#fwd_bank').html(fwd_bank.toLocaleString() + ' vnd');
    $('#sale_cash').html(sale_cash.toLocaleString() + ' vnd');
    $('#sale_bank').html(sale_bank.toLocaleString() + ' vnd');
    $('#total_cash').html(total_cash.toLocaleString() + ' vnd');
}

function parseDate(dateString) {
    let parts = dateString.split("-");
    if (parts.length === 3) {
        // Định dạng dd-mm-yyyy
        let [day, month, year] = parts;
        return new Date(Date.UTC(year, month - 1, day)).getTime();
    } else if (parts.length === 2) {
        // Định dạng mm-yyyy
        let [month, year] = parts;
        return new Date(Date.UTC(year, month - 1)).getTime();
    } else if (parts.length === 1) {
        // Định dạng yyyy
        let [year] = parts;
        return new Date(Date.UTC(year, 0)).getTime(); // Ngày mặc định là 1 tháng 1
    } else {
        console.error("Invalid date format:", dateString);
        return null; // Trả về null nếu định dạng không hợp lệ
    }
}