var register_type = 0;

$(document).ready(function () {
    $(".select2").each(function () {
        $(this).select2({
            dropdownParent: $(this).parent(),
        });
    });

    $(".nav-tabs .nav-item").on("click", function () {
        register_type = $(this).data("register_type");
    });

    $(document).on("click", "#openModalLocation", function () {
        $("#modalChooseLocation").modal("show");
    });

    $(document).on("click", "#openModalLocationStaff", function () {
        $("#modalChooseLocationStaff").modal("show");
    });

    $(document).on("click", "#onRegisterUser", async function () {
        $(this).attr("disabled", true);
        try {
            let formData = new FormData();
            if (register_type == 0) {
                formData.append("user_logo", $("#user_logo_fwd")[0].files[0] ?? null);
                formData.append("user_name", $('[name="user_name_fwd"]').val());
                formData.append("user_accountant_key", $('[name="user_accountant_key_fwd"]').val());
                formData.append("user_company_name", $('[name="user_company_name_fwd"]').val());
                formData.append("user_contact_name", $('[name="user_contact_name_fwd"]').val());
                formData.append("user_tax_code", $('[name="user_tax_code_fwd"]').val());
                formData.append("user_phone", $('[name="user_phone_fwd"]').val());
                formData.append("user_address_1", $('[name="city_of_registration"]').val());
                formData.append("user_address_2", $('[name="district_of_registration"]').val());
                formData.append("user_address_3", $('[name="ward_of_registration"]').val());
                formData.append("user_address", $('[name="user_address_fwd"]').val());
                formData.append("user_latitude", $("#lat").val());
                formData.append("user_longitude", $("#lng").val());
                formData.append("password", $('[name="password_fwd"]').val());
                formData.append("confirm_password", $('[name="confirm_password_fwd"]').val());
            }else if(register_type == 1){
                formData.append("user_name", $('[name="user_name_company"]').val());
                formData.append("user_phone", $('[name="user_phone_company"]').val());
                formData.append("user_contact_name", $('[name="user_contact_name_company"]').val());
                formData.append("user_address", $('[name="user_address_company"]').val());
                formData.append("position_id", $('[name="position_id_company"]').val());
                formData.append("branch_id", $('[name="branch_id_company"]').val());
                formData.append("password", $('[name="password_company"]').val());
                formData.append("confirm_password", $('[name="confirm_password_company"]').val());
            }
            formData.append("is_api", false);
            formData.append("is_customer", register_type == 0 ? true : false);

            const result = await sendRequest(`${window.location.origin}/register`, "POST", formData, true);
            
            window.location.reload();
        } catch (error) {
            if (error.status == 422) {
                const errors = Object.values(error.responseJSON.errors);
                showMessage({
                    icon: "warning",
                    title: "Cảnh báo!",
                    text: errors[0][0],
                });
            }else{
                showMessage(error.message);
            }
            $(this).attr("disabled", false);
        }
    });
});

document.getElementById("myForm").addEventListener("submit", function (event) {
    event.preventDefault(); // Ngăn chặn mặc định submit
    // onConfirmLogin()
});

function onLogin() {
    if (!$("#agree_terms_use_service").prop("checked")) {
        showMessage({
            icon: "warning",
            title: "Thông báo",
            text: "Bạn cần xác nhận với điều khoản của chúng tôi!",
        });
        return;
    }

    let _url = window.location.origin + "/login";
    let _data = {
        email: $("#email").val(),
        password: $("#password").val(),
        is_api: false,
    };

    const callback = (res) => {
        clearValErr();
        if (res.status == 200) {
            window.location.href =
                typeof res.route === undefined
                    ? window.location.origin
                    : res.route;
        } else if (res.status == 422) {
            var errors = res.error.responseJSON.errors; // Lấy thông điệp lỗi từ phản hồi JSON
            $.each(errors, function (key, value) {
                // Hiển thị thông điệp lỗi tương ứng với mỗi trường
                $("#" + key + "_err").text(value[0]);
                $("#" + key + "_err").addClass("d-block");
            });
        } else {
            // alert(res.message);
            let alert = {
                icon: "warning",
                title: "Cảnh báo",
                text: res.message,
            };
            showMessage(alert);
        }
        $("#login_btn").html("ĐĂNG NHẬP");
    };
    $("#login_btn").html(iconLoadingHtml());
    ajaxContants(_url, "POST", _data, callback);
}

function clearValErr() {
    $("#email_err").text("");
    $("#email_err").removeClass("d-block");
    $("#password_err").text("");
    $("#password_err").removeClass("d-block");
}

async function onForgotPassword() {
    $("#confirm-modal-forgot").html(iconLoadingHtml);
    let _url = window.location.origin + "/forgot-password";

    try {
        let data = {
            email: $("#email_forgot").val(),
        };
        console.log(1243);
        const callback = (res) => {
            if (res.status == 200) {
                showMessage({
                    icon: "success",
                    title: "Thông báo",
                    text: res.message,
                });
                $("#email_forgot").val("");
                document.getElementById("close-modal-forgot").click();
            } else {
                showMessage({
                    icon: "error",
                    title: "Cảnh báo",
                    text: res.message,
                });
            }
        };
        ajaxContants2(_url, "POST", data, callback);
    } catch (error) {
        console.log(error);
    }
    $("#confirm-modal-forgot").html("Xác nhận");
}

async function getBase64FromFile(file) {
    return new Promise((resolve, reject) => {
        var reader = new FileReader();

        reader.onload = function (e) {
            resolve(e.target.result); // Trả về kết quả Base64
        };

        reader.onerror = function (error) {
            reject(error); // Nếu có lỗi xảy ra, trả về lỗi
        };

        if (reader) {
            reader.readAsDataURL(file);
        }
    });
}

function displaySelectedImage(event, elementId) {
    const selectedImage = document.getElementById(elementId);
    const fileInput = event.target;

    if (fileInput.files && fileInput.files[0]) {
        const reader = new FileReader();

        reader.onload = function (e) {
            selectedImage.src = e.target.result;
        };

        reader.readAsDataURL(fileInput.files[0]);
    }
}

$("#city_of_registration").on("change", async function () {
    $("div.actions.clearfix").addClass("d-none");
    await getAreasInVietNam(
        $('[name="city_of_registration"]').val(),
        null,
        "district_of_registration",
        "ward_of_registration",
        false
    );
    $("div.actions.clearfix").removeClass("d-none");
});

$("#district_of_registration").on("change", async function () {
    $("div.actions.clearfix").addClass("d-none");
    await getAreasInVietNam(
        $('[name="city_of_registration"]').val(),
        $('[name="district_of_registration"]').val(),
        "district_of_registration",
        "ward_of_registration",
        false
    );
    $("div.actions.clearfix").removeClass("d-none");
});

async function getAreasInVietNam(
    key_city = null,
    key_district = null,
    key_element_district,
    key_element_ward,
    is_name = true
) {
    if (!key_district) {
        $(
            is_name
                ? `[name="${key_element_district}"]`
                : `#${key_element_district}`
        )
            .find("option")
            .not('[value=""]')
            .remove();
        $(
            is_name
                ? `[name="${key_element_district}"]`
                : `#${key_element_district}`
        ).attr("disabled", true);
    }
    $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`)
        .find("option")
        .not('[value=""]')
        .remove();
    $(is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`).attr(
        "disabled",
        true
    );
    try {
        let data = {
            city: key_city,
            district: key_district,
        };
        const result = await sendRequest(
            `${window.location.origin}/areas-in-viet-nam`,
            "POST",
            data
        );
        if (result.status == 200) {
            if (!key_district) {
                $.each(result.areas.districts, function (key, district) {
                    $(
                        is_name
                            ? `[name="${key_element_district}"]`
                            : `#${key_element_district}`
                    ).append(
                        $("<option>", {
                            value: key,
                            text: `${district}`,
                        })
                    );
                });
            }
            $.each(result.areas.wards, function (key, ward) {
                $(
                    is_name
                        ? `[name="${key_element_ward}"]`
                        : `#${key_element_ward}`
                ).append(
                    $("<option>", {
                        value: key,
                        text: `${ward}`,
                    })
                );
            });
        } else {
            showMessage(result.message);
        }
        $(
            is_name
                ? `[name="${key_element_district}"]`
                : `#${key_element_district}`
        ).attr("disabled", false);
        $(
            is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`
        ).attr("disabled", false);
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
        $(
            is_name
                ? `[name="${key_element_district}"]`
                : `#${key_element_district}`
        ).attr("disabled", false);
        $(
            is_name ? `[name="${key_element_ward}"]` : `#${key_element_ward}`
        ).attr("disabled", false);
    }
}
