let limit = 50, page = 1, _url = window.location.origin + '/audit-epacket';

$(document).ready(function () {
    $(".select2").select2();

    $('input[name="shipment_daterange"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function (start, end, label) {
        onGetDataShipments();
    });

    onGetDataShipments();
});

$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    onGetDataShipments();
});

function getFilters() {
    return {
        date_range: {
            start_date: $('input[name="shipment_daterange"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="shipment_daterange"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        },
        shipment_branch_id: $('[name="shipment_branch_id"]').val(),
        shipment_service_id: $('[name="shipment_service_id"]').val(),
        shipment_status: $('[name="shipment_status"]').val(),
        shipment_payment_status: $('[name="shipment_payment_status"]').val(),
        keywords: $('[name="shipment_keywords"]').val(),
        filter_by: $('[name="filter_by"]').val(),
        active_flg: $('[name="shipment_active_flg"]').val(),
    }
}

$('[name="shipment_daterange"]').on('apply.daterangepicker', function (ev, picker) {
    onGetDataShipments();
});

$('[name="shipment_branch_id"], [name="shipment_service_id"], [name="shipment_status"], [name="filter_by"], [name="shipment_payment_status"], [name="shipment_active_flg"]').on('change', function () {
    onGetDataShipments();
});

$(document).on('change', '.change_shipment_note', async function () {
    try {
        const data = {
            shipment_code: $(this).data('shipment_code'),
            shipment_note: $(this).val(),
        };

        const response = await sendRequest(`${_url}/update-note`, 'POST', data);
    } catch (error) {
        showMessage(error.message);
    }
});

let typingTimer = null;
let previousValue = $('[name="shipment_keywords"]').val();
$('[name="shipment_keywords"]').on('keyup', function (event) {
    clearTimeout(typingTimer);
    let currentValue = $(this).val();
    if (currentValue !== previousValue || event.key === 'Enter') {
        typingTimer = setTimeout(onGetDataShipments, 500);
        previousValue = currentValue;
    }
});

async function onGetDataShipments() {
    $('#show_table_content').html('');
    $('#loading_show_table_content').addClass('d-block');
    $('#loading_show_table_content').removeClass('d-none');
    try {
        let data = {
            is_api: false,
            limit: limit,
            page: page,
            filters: JSON.stringify(Object.assign({}, getFilters())),
        };
        
        const result = await sendRequest(`${_url}/pagination`, 'POST', data);
        if (result.status == 200) {
            $('#show_table_content').html(result.html);
        }
        $('#loading_show_table_content').removeClass('d-block');
        $('#loading_show_table_content').addClass('d-none');
    } catch (error) {
        $('#loading_show_table_content').removeClass('d-block');
        $('#loading_show_table_content').addClass('d-none');
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function showShipmentDetail(key) {
    const icon = $(`#btn_shipment_${key} span i`).attr('class');
    if (icon == "fa fa-plus") {
        $(`#btn_shipment_${key} span i`).removeClass('fa-plus');
        $(`#btn_shipment_${key} span i`).addClass('fa-minus');
        $(`#btn_shipment_${key}`).removeClass('btn-flush-success');
        $(`#btn_shipment_${key}`).addClass('btn-flush-danger');
    } else {
        $(`#btn_shipment_${key} span i`).removeClass('fa-minus');
        $(`#btn_shipment_${key} span i`).addClass('fa-plus');
        $(`#btn_shipment_${key}`).removeClass('btn-flush-danger');
        $(`#btn_shipment_${key}`).addClass('btn-flush-success');
    }
}

async function onExportExcel(){
    let data = {
        is_api: false,
        export_excel: true,
        filters: JSON.stringify(Object.assign({}, getFilters())),
    };
    let url = `${_url}/pagination`;
    const file_name = 'ListAditEpacket.xlsx';
    fetchExportExcel(url, data, '#btn_excel_sm', file_name)
}