


let editor;
ClassicEditor.create(document.querySelector('#editor'), {
    mediaEmbed: {
        previewsInData: true
    },
})
    .then(newEditor => {
        editor = newEditor;
    })
    .catch(error => {
        console.error(error);
    });


async function onCreateApi() {
    try {
        onBtnLoading('#btn_handle_document', true);
        let url = window.location.origin + '/api-documents/handle';
        let data = {
            title: $('#api_title').val(),
            short_des: $('#api_short_des').val(),
            content: editor.getData()
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status === 200) {
            window.location.href = res.route;
        } else {
            onBtnLoading('#btn_handle_document', false, 'Lưu');
            return showMessage(res.message);
        }
    } catch (error) {
        onBtnLoading('#btn_handle_document', false, 'Lưu');
        showMessage();
    }
}

async function onUpdateApi() {
    try {
        onBtnLoading('#btn_handle_document', true);
        let url = window.location.origin + '/api-documents/handle';
        let data = {
            api_id: $('#api_id').val(),
            title: $('#api_title').val(),
            short_des: $('#api_short_des').val(),
            content: editor.getData()
        }
        let res = await ajaxContants2(url, 'POST', data);
        if (res.status === 200) {
            window.location.href = res.route;
        } else {
            onBtnLoading('#btn_handle_document', false, 'Lưu');
            return showMessage(res.message);
        }
    } catch (error) {
        onBtnLoading('#btn_handle_document', false, 'Lưu');
        showMessage();
    }
}