Dropzone.autoDiscover = false;
if (document.getElementById('statementFwdDropzone')) {

    var statementFwdDropzone = new Dropzone("#statementFwdDropzone", {
        url: "/upload",
        autoProcessQueue: false,
        paramName: "file",
        clickable: true,
        maxFilesize: 10, // MB
        addRemoveLinks: true,
        acceptedFiles: '.png,.jpg',
        dictDefaultMessage: "Tải hình ảnh ở đây",

        init: function () {
            var dropzone = this;
            dropzone.on("complete", function (file) {
            });
            dropzone.on("addedfile", function (file) {
            });
            dropzone.on("removedfile", function (file) {
            });
        }
    });

    function emptyValidate() {
        $('#statement_amount_err').html('')
        $('#statement_images_err').html('')
        $('#statement_note_err').html('')
    }

    function onPaymentStatement(statement_code) {
        try {
            if (Dropzone.forElement("#statementFwdDropzone").files.length <= 0) {
                $('#statement_images_err').html('Không được để trống hình ảnh');
                // showMessage({text: "Cần phải có bằng chứng"})
                return
            }

            var dataURLs = [];

            Dropzone.forElement("#statementFwdDropzone").files.forEach(async function (file) {
                let base64 = await readFileAsBase64(file);
                dataURLs.push(base64);
            })

            const callback = async () => {
                onLoadingSweet(true);
                emptyValidate();
                const url = window.location.origin + '/statement/payment';
                const data = {
                    statement_code: statement_code,
                    statement_images: JSON.stringify(dataURLs),
                    statement_note: $('#statement_note').val(),
                    statement_amount: convertStringToNumber($('#statement_amount').val()),
                    statement_amount_cash: convertStringToNumber($('#statement_amount_cash').val()),
                    statement_amount_bank: convertStringToNumber($('#statement_amount_bank').val()),
                    statement_payment_method: $('input[name="statement_payment_method"]:checked').val()
                }

                let res = await ajaxContants2(url, "POST", data);

                if (res.status === 200) {
                    location.reload();
                } else if (res.status == 422) {
                    var errors = res.error;
                    $.each(errors, function (key, value) {
                        // Hiển thị thông điệp lỗi tương ứng với mỗi trường
                        if ($('#' + key + '_err')) {
                            $('#' + key + '_err').html(value[0])
                        }
                    });
                }
                onLoadingSweet(false);
                showMessage(res.message);
            }

            onConfirmAction({
                icon: 'question',
                title: 'Thông báo',
                text: 'Xác nhận thanh toán'
            }, callback)
        } catch (error) {
            showMessage();
            onLoadingSweet(false);
        }

    }
}

$('#statement_amount_bank, #statement_amount_cash, #statement_amount').on('input', function () {
    let total_price = convertStringToNumber($('#statement_amount').val());
    let bank_price = convertStringToNumber($('#statement_amount_bank').val());
    let cash_price = convertStringToNumber($('#statement_amount_cash').val());

    let input_id = $(this).attr('id');
    
    if (input_id === 'statement_amount_bank') {
        $('#statement_amount_cash').val(formatNumber2(total_price - bank_price));
    } else if (input_id === 'statement_amount_cash') {
        $('#statement_amount_bank').val(formatNumber2(total_price - cash_price));
    }else{
        $('#statement_amount_cash').val(formatNumber2(total_price - bank_price))
    }
    
})
