let limit = 10, page = 1


$(window).ready(function () {
    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        }
    }, function (start, end, label) {
        fetchData();
    });
    $('#payment_status, #shipment_status').change(function (e) {
        page = 1;
        fetchData();
    })

    fetchData();
})


$(document).on('click', '.pagination a', function (event) {
    event.preventDefault();
    page = $(this).attr('href').split('page=')[1];
    fetchData();
});


function getFilters() {
    return {
        date_range: {
            start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        },
        // shipment_branch_id: $('[name="shipment_branch_id"]').val(),
        shipment_status: $('[name="shipment_status"]').val(),
        payment_status: $('[name="payment_status"]').val(),
        keywords: $('#keywords').val(),
        // filter_by: $('[name="filter_by"]').val(),
        // accountant_status: 0,
    }
}

$('#keywords').on('keypress', function (e) {
    if (e.which === 13) { // 13 là mã ASCII của phím Enter
        page = 1;
        fetchData();
    }
})


async function fetchData() {
    try {
        let url = window.location.origin + '/debit/fwd/shipment-fwd'
        let data = {
            is_api: false,
            limit: limit,
            page: page,
            filters: JSON.stringify(Object.assign({}, getFilters())),
        };
        ajaxPostHTML(url, data, 'content')
    } catch (error) {

        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

async function onCreateDebit() {
    try {
        onBtnLoading('#btn_create_debit', true);
        let url = window.location.origin + '/debit/fwd/create-debit';
        let data = {
            fwd_id: $('#select_fwd_id').val(),
        }
        
        let res = await ajaxContants2(url, "POST", data);

        if (res.status == 200) {
            $('#btn_close_modal').click();
        }
        onBtnLoading('#btn_create_debit', false, 'Tạo Debit');
        showMessage(res.message)
    } catch (error) {
        onBtnLoading('#btn_create_debit', false, 'Tạo Debit');
        if (error.responseJSON.message) {
            showMessage(error.responseJSON.message);
        } else {
            showMessage({
                icon: 'error',
                title: 'Thông báo',
                text: 'Xảy ra lỗi khi gọi lên serve'
            });
        }
    }

}