let limit = 30, page = 1;

$(document).ready(function(){
    initDataPicker();
    fetchListHangNhap();
    initPagination();
    initSearchInputBehaviour();
    initSearchButtonBehaviour();
});


async function fetchListHangNhap() {
    try {
        let url = window.location.origin + '/debit/fwd/imported-goods'
        let data = {
            is_api: false,
            limit: limit,
            page: page,
            filters: JSON.stringify(Object.assign({}, getFilters())),
        };
        ajaxPostHTML(url, data, 'content')
    } catch (error) {
        if (error.status != 422) {
            showMessage(error.message);
        }
    }
}

function getFilters() {
    return {
        status: $('#status').val(),
        keywords: $('#keywords').val(),
        date_range: {
            start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
            end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
        },
    }
}

function initSearchInputBehaviour() {
    $('#keywords').on('keypress', function (e) {
        if (e.which === 13) { // ASCII enter code
            fetchListHangNhap();
        }
    });
}
function initSearchButtonBehaviour() {
    $('#btn_search').on('click', function (e) {
        fetchListHangNhap();
    });
}

function initPagination() {
    $(document).on('click', '.pagination a', function (event) {
        event.preventDefault();
        page = $(this).attr('href').split('page=')[1];
        fetchListHangNhap();
    });
}

function initDataPicker(){
    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        },
        ranges: {
            'Tháng này': [moment().startOf('month'), moment().endOf('month')],
            'Tháng trước': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '3 tháng trước': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            '6 tháng trước': [moment().subtract(6, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Năm nay': [moment().startOf('year'), moment().endOf('year')],
            'Năm trước': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
        }
    }, function () {
        
    });

}