let pub_page = 1;
let pub_limit = 30;

const CONTENT_INFO = 0;
const CONTENT_LIST = 1;
let pub_content = CONTENT_LIST;

let pub_choosed_id = [];
let is_check_all = false;


$(document).on('click', '.pagination a', async function (event) {
    event.preventDefault();
    pub_page = $(this).attr('href').split('page=')[1];
    fetchData();
});

$(window).ready(function () {
    $(".select2").select2();
    $('input[name="datetimes"]').daterangepicker({
        opens: 'left',
        startDate: moment().subtract(3, 'months').startOf('month'),
        endDate: moment().endOf('month'),
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Áp dụng",
            cancelLabel: "Hủy",
            customRangeLabel: "Tùy chỉnh",
            daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
            monthNames: [
                "Tháng 1",
                "Tháng 2",
                "Tháng 3",
                "Tháng 4",
                "Tháng 5",
                "Tháng 6",
                "Tháng 7",
                "Tháng 8",
                "Tháng 9",
                "Tháng 10",
                "Tháng 11",
                "Tháng 12",
            ],
        }
    }, function (start, end, label) {
        fetchData();
    });

    fetchData();
})

$('#company_shipment_status , #company_shipment_payment, #shipment_service_id').change(function () {
    pub_page = 1;
    fetchData();
})

$('#keywords').change(function () {
    pub_page = 1;
    fetchData();
})

function fetchData() {

    const url = window.location.origin + '/debit/fwd/detail-sm-fwd';
    const data = {
        user_id: pub_company_id,
        page: pub_page,
        limit: pub_limit,
        choosed_id: pub_choosed_id,
        is_check_all: is_check_all,
        filters: {
            date_range: {
                start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
                end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
            },
            keywords: $('#keywords').val(),
            shipment_service_id: $('#shipment_service_id').val(),
            company_shipment_status: $('#company_shipment_status').val(),
            company_shipment_payment: $('#company_shipment_payment').val(),
        }
    }
    ajaxPostHTML(url, data, 'content-list');

}



function onChooseShipment(value) {
    let index = pub_choosed_id.indexOf(value);
    if (index === -1) {
        pub_choosed_id.push(value);
    } else {
        pub_choosed_id.splice(index, 1);
        // $('#check-all-user').prop('checked', false);
    }
}
$('#is_check_all').on('click', function () {

})
async function onCheckAll() {
    try {
        onLoadingSweet(true);
        is_check_all = document.getElementById('is_check_all').checked;
        const url = window.location.origin + '/debit/fwd/detail-sm-fwd';
        const data = {
            user_id: pub_company_id,
            choosed_id: pub_choosed_id,
            is_check_all: is_check_all,
            pluck_id: true,
            filters: {
                date_range: {
                    start_date: $('input[name="datetimes"]').data('daterangepicker').startDate.format('DD-MM-YYYY'),
                    end_date: $('input[name="datetimes"]').data('daterangepicker').endDate.format('DD-MM-YYYY'),
                },
                keywords: $('#keywords').val(),
                shipment_service_id: $('#shipment_service_id').val(),
            }
        }
        let res = await ajaxContants2(url, 'POST', data);

        if (res.status == 200) {
            pub_choosed_id = res.shipment_ids
            fetchData();
        } else {
            showMessage(res.message)
        }
        onLoadingSweet(false);
    } catch (error) {
        showMessage();
        onLoadingSweet(false);
    }
}


async function onCreateDebit() {
    if (pub_choosed_id.length < 1) {
        return showMessage({
            icon: 'warning',
            text: 'Vui lòng đơn muốn tạo debit!'
        });
    }
    Swal.fire({
        title: "Thông báo",
        icon: "question",
        html: `
            <p class="px-3">Bạn có chắc chắn muốn tạo debit từ những những đơn đã chọn không?</p>
            <div class="px-3 mt-3">
                <div class="mb-3 text-start">
                    <label class="form-label" for="">Phụ phí xăng dầu (%)</label>
                    <input class="form-control" type="number" id="debit_fsc" max="100" min="0">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="" id="has_fsc">
                        <label class="form-check-label" for="has_fsc">
                            Xác nhận thêm phụ phí xăng đầu
                        </label>
                    </div>
                </div>
                <div class="form-check form-switch text-start mb-3">
                    <input class="form-check-input" type="checkbox" role="switch" id="debit_vat">
                    <label class="form-check-label" for="debit_vat">Tạo debit với VAT 8%</label>
                </div>
            </div>
        `,
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Xác nhận",
        cancelButtonText: "Hủy",
    }).then(async (result) => {
        if (result.isConfirmed) {
            try {
                let url = window.location.origin + '/debit/fwd/create-debit2';
                let data = {
                    shipment_ids: pub_choosed_id,
                    fwd_id: pub_company_id,
                    debit_vat: $('#debit_vat').is(':checked') ? 8 : 0,
                    has_fsc: $('#has_fsc').is(':checked'),
                    debit_fsc: $('#debit_fsc').val(),
                }

                let res = await ajaxContants2(url, 'POST', data);

                if (res.status == 200) {
                    is_check_all = false;
                    pub_choosed_id = [];
                    fetchData();
                }
                showMessage(res.message);
            } catch (error) {
                console.log(error.responseJSON.message);
            }
        }
    });

}