<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>PRINT LABEL KANGO <?php echo e($shipment['shipment_code']); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>">
    <link rel="icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>" type="image/x-icon">
    <!-- CSS -->
    <link href="<?php echo e(asset('assets/dist/css/style.css')); ?>" rel="stylesheet" type="text/css">
    <style>
        body {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }


        .container-print-bill {
            transform: scale(0.8);
            transform-origin: 0 0 0;
        }

        .form-print {
            display: flex !important;
            justify-content: center !important;
            align-items: center !important;
            padding: auto !important;
        }

        @media print {
            @page {
                margin-left: 0in;
                margin-right: 0in;
                margin-top: 0in;
                margin-bottom: 0;
            }

            .pt-5 {
                padding-top: 1.3rem !important;
            }

            .fs-1 {
                font-size: 2.5rem !important;
                font-weight: 700;
            }

            .fs-2 {
                font-size: 2rem !important;
                font-weight: 600;
            }

            .fs-3 {
                font-size: 1.75rem !important;
                font-weight: 500;
            }

            .fs-4 {
                font-size: 1.0rem !important;
                font-weight: 400;
            }

            .fs-5 {
                font-size: 0.7rem !important;
            }

            .fs-6 {
                font-size: 0.7rem !important;
            }

            .fs-7 {
                font-size: 0.6rem !important;
            }

            .fs-8 {
                font-size: 0.5rem !important;
            }

            .form-print {
                display: flex !important;
                justify-content: center !important;
                align-items: center !important;
                margin: auto;
            }

            .container-print-bill {
                width: auto !important;
                transform: scale(1) !important;
                height: 100vh !important;
                page-break-before: always;
                /* Đảm bảo không bị chia nhỏ */
                page-break-inside: avoid;
                /* Căn giữa trên trang */

            }

            .form-print-bill {
                /* min-width: 100%;
                max-width: 100%;
                min-height: 100%;
                max-height: 100%; */
            }
        }
    </style>
</head>

<body>
    <?php $__currentLoopData = $shipment['packages']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key_package => $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-print">
            <div class="p-5 fs-4 d-flex justify-content-center container-print-bill">
                <div class="form-print-bill">
                    <div class="row row-cols-2 border border-dark">
                        <div class="col-6 border-end border-dark">
                            <div
                                style="width: 100%; height: 100%; display: flex; justify-content: center; align-items: center;">
                                <?php if(onCheckPositionAccount(SETTING_FWD_ACCOUNT, $shipment['user']['position_id'])): ?>
                                    <img src="<?php echo e($shipment['user']['user_logo'] ? asset($shipment['user']['user_logo']) : ''); ?>"
                                        alt="" style="max-width: 100%; max-height: 90px; object-fit: contain;">
                                <?php else: ?>
                                    <img src="<?php echo e(asset('assets/images/logo-kango.png')); ?>" alt=""
                                        style="max-width: 100%; max-height: 100%; object-fit: contain;">
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-6 d-flex justify-content-center align-items-center fw-bold text-dark p-3">
                            <div class="">
                                KSNPOST.COM
                                <div class="fs-5 text-center">
                                    DATE: <?php echo e(\Carbon\Carbon::now()->format('d/m/Y')); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row row-cols-2 border border-top-0 border-dark">
                        <div class="col-12 text-dark fs-4">
                            <div class="col-12 text-dark fw-bold mt-1">From</div>

                            <div class="col-12 d-flex justify-content-between align-items-center">
                                <div class="col-8">
                                    <div class="col-12 text-dark"><?php echo e($shipment['sender_contact_name']); ?></div>
                                    <div class="col-12 text-dark"><?php echo e($shipment['sender_company_name']); ?></div>
                                    <div class="col-12 text-dark">
                                        <?php if(onCheckPositionAccount(SETTING_SALE_ACCOUNT, $shipment['user']['position_id'])): ?>
                                            1900-9475
                                        <?php else: ?>
                                            <?php echo e($shipment['sender_telephone']); ?>

                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col d-flex justify-content-center align-items-center fw-bold text-dark">
                                    <?php echo $qrcode; ?>

                                </div>
                            </div>

                            <div class="">
                                <?php echo e($shipment['sender_address']); ?>,
                                <?php echo e($shipment['sender_ward_name']); ?>,
                                <?php echo e($shipment['sender_district_name']); ?>,
                                <?php echo e($shipment['sender_city_name']); ?>,
                                VIET NAM
                            </div>
                            <div class="col-12 text-dark fw-bold mt-3">Ship To</div>
                            <div class="col-12 text-dark"><?php echo e($shipment['receiver_contact_name']); ?></div>
                            <div class="col-12 text-dark"><?php echo e($shipment['receiver_company_name']); ?></div>
                            <div class="col-12 text-dark"><?php echo e($shipment['receiver_telephone']); ?></div>
                            <div class="col-12 text-dark">
                                <?php echo e($shipment['city']['city_name'] ?? ''); ?>,
                                <?php echo e(empty($shipment['receiver_state_name']) ? $shipment['state']['state_name'] : $shipment['receiver_state_name']); ?>,
                                <?php echo e($shipment['country']['country_name']); ?>

                            </div>
                            <div class="col-12 text-dark mb-3">
                                <?php echo e($shipment['receiver_address_1']); ?>,
                                <?php echo e($shipment['receiver_postal_code']); ?>,
                                <?php echo e($shipment['country']['country_name']); ?>

                            </div>
                        </div>

                    </div>
                    <div class="row row-cols-2 border border-top-0 border-dark">
                        <div class="col-4 p-1 text-dark text-center fw-bold border-end border-dark fs-5">
                            SERVICE
                        </div>
                        <div class="col-8 p-1 text-uppercase text-center fw-bold text-dark">
                            <?php echo e($shipment['service']['service_name']); ?>

                        </div>
                    </div>
                    <div class="row row-cols-2 border border-top-0 border-dark">
                        <div class="col-4 p-1 text-dark text-center fw-bold border-end border-dark fs-5">
                            AWB / TRACKING
                        </div>
                        <div class="col-8 p-1 text-uppercase text-center fw-bold text-dark">
                            <?php echo e($shipment['shipment_code']); ?>

                        </div>
                    </div>
                    <div class="row row-cols-2 border border-top-0 border-dark">
                        <div class="col-4 p-1 text-dark text-center fw-bold border-end border-dark fs-5">
                            HAWB
                        </div>
                        <div class="col-8 p-1 text-uppercase text-center fw-bold text-dark ">
                            <?php echo e($package['package_code']); ?>

                        </div>
                    </div>
                    <div class="row row-cols-1 border border-top-0 border-dark">
                        <div class="col p-2">
                            <div class="d-flex justify-content-center align-items-center fs-1">
                                <?php echo createBarCode($package['package_code'], 3, 70) ?? 'Lﾃｴﾌナ'; ?>

                            </div>
                        </div>
                    </div>
                    <div class="row row-cols-1 border border-top-0 border-dark">
                        <div class="col p-1 text-start">
                            Reference No: <?php echo e($shipment['shipment_reference_code']); ?>

                        </div>
                    </div>
                    <div class="row row-cols-2 border border-top-0 border-dark fs-6 text-dark fw-bold">
                        <div class="col p-3 text-center border-end border-dark">
                            Total Pcs: <?php echo e(count($shipment['packages'])); ?>

                        </div>
                        <div class="col p-3 text-center">
                            SPX
                        </div>
                    </div>
                    <div class="row row-cols-1 border border-top-0 border-dark">
                        <div class="col p-2 text-center fw-bold text-dark">
                            <?php echo e($key_package + 1); ?> / <?php echo e(count($shipment['packages'])); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <script>
        var is_printed = false;
        window.onload = async function() {
            await window.scrollTo(0, 0);
            if (window.scrollY == 0 && !is_printed) {
                is_printed = true;
                window.print();
            }
            window.addEventListener('scroll', function() {
                if (window.scrollY == 0 && !is_printed) {
                    is_printed = true;
                    window.print();
                }
            });
        }
    </script>
</body>

</html>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/shipment/prints/label.blade.php ENDPATH**/ ?>