<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th></th>
                <th>Mã</th>
                <th>Ngày</th>
                <th>Chi nhánh</th>
                <th>Số tiền</th>
                <th>Đối tác</th>
                <th>Phướng thức</th>
                <th>Ghi chú</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $financials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $financial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="odd <?php echo e($financial['financial_type'] == 0 ? 'table-success' : ''); ?>">
                    <td>
                        <button id="btn_financial_<?php echo e($key); ?>" onclick="onActionBtnShowClick(this)"
                            class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            data-bs-toggle="collapse" data-bs-target="#financial_<?php echo e($key); ?>"
                            aria-expanded="false">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </td>
                    <td>
                        <?php echo e($financial['financial_code']); ?>

                    </td>
                    <td><?php echo e(formatFullDate($financial['created_at'])); ?></td>
                    <td class="">
                        <?php echo e($financial['branch_name']); ?>

                    </td>
                    <td>
                        <?php echo e(number_format($financial['financial_amount'])); ?>

                    </td>
                    <td>
                        <?php echo e($financial['financial_customer_name']); ?>

                    </td>
                    <td>
                        <span class="text-primary fw-bold"><?php echo e($financial['financial_type_label']); ?></span>
                        (<?php echo e($financial['financial_method_label']); ?>)
                    </td>
                    <td>
                        <?php echo e($financial['financial_content']); ?>

                    </td>
                    <td>
                        <button class="btn btn-icon btn-success"
                            onclick="onShowModalFinancial('<?php echo e($financial['financial_code']); ?>')">
                            <span class="icon"><i class="fas fa-edit"></i></span>
                        </button>
                        <button class="btn btn-icon btn-danger"
                            onclick="onDeleteFinancial('<?php echo e($financial['financial_code']); ?>')">
                            <span class="icon"><i class="fas fa-trash"></i></span>
                        </button>
                    </td>
                </tr>
                <tr class="child collapse" id="financial_<?php echo e($key); ?>">
                    <td class="child" colspan="7">
                        <ul>
                            <li class="mb-3">
                                <span class="dtr-title">Người tạo: </span>
                                <span class="dtr-data">
                                    <?php echo e($financial['user_contact_name']); ?>

                                    [<span class="text-primary fw-bold"><?php echo e($financial['user_code']); ?></span>]
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Phiếu chi: </span>
                                <span class="dtr-data">
                                    <?php $__currentLoopData = onConvertStrArrImage($financial['financial_images']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e($image); ?>" target="_blank" class="m-1"><i
                                                class="fas fa-image"></i></a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Chi lương: </span>
                                <span class="dtr-data">
                                    <i
                                        class="ms-1 <?php echo e($financial['financial_is_salary'] == 0 ? 'far fa-square' : 'far fa-check-square'); ?>"></i>
                                </span>
                            </li>

                        </ul>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    <?php echo e($financials->links('components.pagination')); ?>

</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/accounting-management/financial/ajax/table-financial.blade.php ENDPATH**/ ?>