<?php
    $path = 'public/config/system-settings.json';
    $system_settings = json_decode(Storage::get($path), true);
    $url_facebook = collect($system_settings)->firstWhere('kind', SETTING_FACEBOOK)['value'] ?? '';
    $url_zalo = collect($system_settings)->firstWhere('kind', SETTING_ZALO)['value'] ?? '';
    $url_hotline = collect($system_settings)->firstWhere('kind', SETTING_HOTLINE)['value'] ?? '';
?>
<!-- Button Contact -->
<div id="button-contact-vr" class="">
    <div id="gom-all-in-one" style="display: none">
        <div id="zalo-vr" class="button-contact">
            <div class="phone-vr">
                <div class="phone-vr-circle-fill"></div>
                <div class="phone-vr-img-circle" title="Zalo: ">
                    <a target="_blank" href="<?php echo e($url_zalo); ?>" data-wpel-link="external"
                        rel="nofollow external noopener noreferrer">
                        <img src="<?php echo e(asset('assets/images/zalo.png')); ?>" />
                    </a>
                </div>
            </div>
        </div>
        <div id="facebook-vr" class="button-contact">
            <div class="phone-vr">
                <div class="phone-vr-circle-fill"></div>
                <div class="phone-vr-img-circle">
                    <a href="<?php echo e($url_facebook); ?>" target="_blank">
                        <img src="<?php echo e(asset('assets/images/facebook.png')); ?>" />
                    </a>
                </div>
            </div>
        </div>
        <div id="hotline-vr" class="button-contact">
            <div class="phone-vr">
                <div class="phone-vr-circle-fill"></div>
                <div class="phone-vr-img-circle" title="Hotline: <?php echo e($url_hotline); ?>">
                    <a href="tel:<?php echo e($url_hotline); ?>" data-wpel-link="external"
                        rel="nofollow external noopener noreferrer">
                        <img src="<?php echo e(asset('assets/images/phone.svg')); ?>" />
                    </a>
                </div>
            </div>
        </div>
    </div>
    <button id="toggle-contact-btn" class="toggle-btn btn btn-icon btn-rounded btn-primary btn-animated"><span
            class="icon"><i class="fas fas fa-headphones"></i></span></button>
</div>

<style>
    #button-contact-vr {
        position: fixed;
        bottom: 0;
        z-index: 99999;
        right: 0;
    }

    .toggle-btn {
        padding: 5px 10px;
        margin-bottom: 10px;
        cursor: pointer;
        position: fixed;
        bottom: -20;
        right: 8px;
        z-index: 100000;
    }

    #button-contact-vr .button-contact {
        position: relative;
    }

    #button-contact-vr .button-contact .phone-vr {
        position: relative;
        visibility: visible;
        background-color: transparent;
        width: 90px;
        height: 90px;
        cursor: pointer;
        z-index: 11;
        -webkit-backface-visibility: hidden;
        -webkit-transform: translateZ(0);
        transition: visibility .5s;
        left: 0;
        bottom: 0;
        display: block;
    }

    .phone-vr-circle-fill {
        width: 65px;
        height: 65px;
        top: 12px;
        left: 12px;
        position: absolute;
        box-shadow: 0 0 0 0 #c31d1d;
        background-color: rgba(230, 8, 8, 0.7);
        border-radius: 50%;
        border: 2px solid transparent;
        -webkit-animation: phone-vr-circle-fill 2.3s infinite ease-in-out;
        animation: phone-vr-circle-fill 2.3s infinite ease-in-out;
        transition: all .5s;
        -webkit-transform-origin: 50% 50%;
        -ms-transform-origin: 50% 50%;
        transform-origin: 50% 50%;
        -webkit-animuiion: zoom 1.3s infinite;
        animation: zoom 1.3s infinite;
    }

    .phone-vr-img-circle {
        background-color: #e60808;
        width: 40px;
        height: 40px;
        line-height: 40px;
        top: 25px;
        left: 25px;
        position: absolute;
        border-radius: 50%;
        display: flex;
        justify-content: center;
        -webkit-animation: phonering-alo-circle-img-anim 1s infinite ease-in-out;
        animation: phone-vr-circle-fill 1s infinite ease-in-out;
    }

    .phone-vr-img-circle a {
        display: block;
        line-height: 37px;
    }

    .phone-vr-img-circle img {
        max-height: 25px;
        max-width: 27px;
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        -moz-transform: translate(-50%, -50%);
        -webkit-transform: translate(-50%, -50%);
        -o-transform: translate(-50%, -50%);
    }


    @-webkit-keyframes phone-vr-circle-fill {
        0% {
            -webkit-transform: rotate(0) scale(1) skew(1deg);
        }

        10% {
            -webkit-transform: rotate(-25deg) scale(1) skew(1deg);
        }

        20% {
            -webkit-transform: rotate(25deg) scale(1) skew(1deg);
        }

        30% {
            -webkit-transform: rotate(-25deg) scale(1) skew(1deg);
        }

        40% {
            -webkit-transform: rotate(25deg) scale(1) skew(1deg);
        }

        50% {
            -webkit-transform: rotate(0) scale(1) skew(1deg);
        }

        100% {
            -webkit-transform: rotate(0) scale(1) skew(1deg);
        }
    }

    @-webkit-keyframes zoom {
        0% {
            transform: scale(.9)
        }

        70% {
            transform: scale(1);
            box-shadow: 0 0 0 15px transparent
        }

        100% {
            transform: scale(.9);
            box-shadow: 0 0 0 0 transparent
        }
    }

    @keyframes zoom {
        0% {
            transform: scale(.9)
        }

        70% {
            transform: scale(1);
            box-shadow: 0 0 0 15px transparent
        }

        100% {
            transform: scale(.9);
            box-shadow: 0 0 0 0 transparent
        }
    }

    .phone-bar a {
        position: fixed;
        bottom: 25px;
        left: 30px;
        z-index: -1;
        color: #fff;
        font-size: 16px;
        padding: 8px 15px 7px 50px;
        border-radius: 100px;
        white-space: nowrap;
    }

    .phone-bar a:hover {
        opacity: 0.8;
        color: #fff;
    }

    @media(max-width: 736px) {
        .phone-bar {
            display: none;
        }
    }

    #zalo-vr .phone-vr-circle-fill {
        box-shadow: 0 0 0 0 #2196F3;
        background-color: rgba(33, 150, 243, 0.7);
    }

    #zalo-vr .phone-vr-img-circle {
        background-color: #2196F3;
    }

    #facebook-vr .phone-vr-circle-fill {
        box-shadow: 0 0 0 0 #3B5998;
        background-color: rgba(59, 89, 152, 0.7);
    }

    #facebook-vr .phone-vr-img-circle {
        background-color: #3B5998;
    }

    #viber-vr .phone-vr-img-circle {
        background-color: #714497;
    }

    #contact-vr .phone-vr-circle-fill {
        box-shadow: 0 0 0 0 #2196F3;
        background-color: rgba(33, 150, 243, 0.7);
    }

    #contact-vr .phone-vr-img-circle {
        background-color: #2196F3;
    }

    .phone-bar a,
    #phone-vr .phone-vr-circle-fill,
    #phone-vr .phone-vr-img-circle,
    #phone-vr .phone-bar a {
        background-color: #dd3333;
    }

    #phone-vr .phone-vr-circle-fill {
        opacity: 0.7;
        box-shadow: 0 0 0 0 #dd3333;
    }

    #button-contact-vr {
        bottom: 12%;
        right: 8px;
    }

    #button-contact-vr {
        transform: scale(1);
    }
</style>

<?php $__env->startPush('scripts'); ?>
    <script>
        $('#toggle-contact-btn').click(function() {
            $('#gom-all-in-one').toggle(); // Ẩn/hiện phần liên hệ

            // Đổi icon dựa trên trạng thái hiển thị
            let icon = $(this).find('.icon i');
            if ($('#gom-all-in-one').is(':visible')) {
                icon.removeClass('fas fa-headphones').addClass('fas fa-headphones');
            } else {
                icon.removeClass('fas fa-headphones').addClass('fas fa-headphones');
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\Dev\Laravel\WebExpress\kango\resources\views/components/button-contact.blade.php ENDPATH**/ ?>