<div class="mb-3 row">
    <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-12 col-sm-12">
            <div class="card card-refresh">
                <div class="refresh-container">
                    <div class="loader-pendulums"></div>
                </div>
                <div class="card-header card-header-action">
                    <div class="card-title">
                        <a class="h5" href="<?php echo e(route('manages.sale.detail', ['sale_code' => $value->user_code])); ?>">
                            <i class="fas fa-user-tie"></i>
                            <?php echo e($value->user_contact_name); ?>

                        </a>
                        <p class="small">Ngày tạo: <?php echo e($value->created_at); ?></p>
                    </div>
                    <div class="card-action-wrap">
                        <?php if(isGetAllData()): ?>
                            <button class="btn btn-icon btn-flush-primary btn-sm" data-bs-toggle="modal"
                                data-bs-target="#modalAddLeader"
                                onclick="modalAddLeader(false, <?php echo e($value->sale_team_id); ?>, 'Team leader <?php echo e($value->user_contact_name); ?>')">
                                <span class="icon"><i class="fas fa-user-plus"></i></span></button>
                        <?php endif; ?>
                        <div class="d-flex dropdown">
                            <a class="btn btn-xs btn-icon btn-rounded btn-flush-dark flush-soft-hover dropdown dropdown-toggle no-caret"
                                data-bs-toggle="dropdown" href="#" aria-expanded="false"><span class="icon"><i
                                        class="fas fa-cog"></i></span></a>
                            <div class="dropdown-menu">
                                <?php if(isGetAllData()): ?>
                                    <a class="dropdown-item"
                                        href="<?php echo e(route('manages.sale.detail', ['sale_code' => $value->user_code])); ?>">
                                        <i class="fas fa-user-cog"></i> Thông tin chi tiết
                                    </a>
                                    <a class="dropdown-item" onclick="onDeleteTeam(<?php echo e($value->sale_team_id); ?>)">
                                        <i class="fas fa-trash"></i> Xóa
                                    </a>
                                <?php endif; ?>
                                <a class="dropdown-item" onclick="onExportSaleTeam(<?php echo e($value['sale_team_id']); ?>)">
                                    <i class="fas fa-download"></i> Export dữ liệu
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="collapse_<?php echo e($value->sale_team_id); ?>" class="collapse show">
                    <div class="card-body table-responsive">
                        <table class="table table-hover table-striped mb-0">
                            <thead>
                                <tr>
                                    <th class="fw-bold">Tên</th>
                                    <th class="fw-bold">Mã</th>
                                    <th class="fw-bold">Lợi nhuận</th>
                                    <?php if(!$check_edit): ?>
                                        <th></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = getTeamMember($value->sale_team_id, $filters); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <?php
                                            $check_leader = $member['member_kind'] == SALE_LEADER;
                                        ?>
                                        <td class="<?php echo e($check_leader ? 'fw-bold' : ''); ?>">
                                            <?php if(isGetAllData()): ?>
                                                <a
                                                    href="<?php echo e(route('manages.sale.detail', ['sale_code' => $member['user_code']])); ?>">
                                                    <i class="<?php echo e($check_leader ? 'fas fa-user-tie' : ''); ?>"></i>
                                                    <?php echo e($member['user_contact_name']); ?>

                                                </a>
                                            <?php else: ?>
                                                <span>
                                                    <i $check_leader ? 'fas fa-user-tie' : '' }}"></i>
                                                    <?php echo e($member['user_contact_name']); ?>

                                                </span>
                                            <?php endif; ?>

                                        </td>
                                        <td><?php echo e($member['user_code']); ?></td>
                                        <td class="fw-bold text-success">
                                            <?php echo e(number_format($member['member_profit'])); ?> VND
                                        </td>
                                        <?php if(!$check_edit): ?>
                                            <td class="">
                                                <div class="hstack flex-wrap gap-3 pb-0">
                                                    <?php if($member['member_kind'] == SALE_MEMBER): ?>
                                                        <button class="btn btn-icon btn-soft-primary btn-sm"
                                                            onclick="changeMemberToLeader(<?php echo e($value->sale_team_id); ?>, <?php echo e($member['sale_member_id']); ?>)">
                                                            <span class="icon"><i
                                                                    class="fas fa-user-tie"></i></span></button>
                                                        <button class="btn btn-icon btn-soft-info btn-sm"
                                                            onclick="transferMemberToTeam(<?php echo e($value->sale_team_id); ?>, <?php echo e($member['sale_member_id']); ?>)">
                                                            <span class="icon"><i
                                                                    class="fas fa-reply"></i></span></button>
                                                        <button class="btn btn-icon btn-soft-danger btn-sm"
                                                            onclick="kickMemberOutOfTeam(<?php echo e($value->sale_team_id); ?>, <?php echo e($member['sale_member_id']); ?>)">
                                                            <span class="icon"><i
                                                                    class="fas fa-sign-out-alt"></i></span></button>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<div class="text-center">
    <?php echo e($teams->links('components.pagination')); ?>

</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/manage/sale/leader/ajax/table-teams.blade.php ENDPATH**/ ?>