<div class="table-responsive">
    <table class="table nowrap w-100 mb-5 dataTable no-footer">
        <thead class="thead-dark">
            <tr role="row">
                <th rowspan="1" colspan="1"></th>
                <th class="sorting fw-bold">
                    MÃ HAWB
                </th>
                <th class="sorting fw-bold">
                    TYPE
                </th>
                <th class="sorting fw-bold">
                    WEIGHT(KG)
                </th>
                <th class="fw-bold">
                    CONVERTED WEIGHT
                </th>
                <th class="fw-bold">
                    CHARGED WEIGHT
                </th>
                <th class="fw-bold">
                    STATUS
                </th>
                <th class="fw-bold">
                    TRACKING CODE
                </th>
            </tr>
        </thead>
        <tbody>
            <?php
                $colors = ['secondary', 'info', 'success', 'danger', 'danger'];
            ?>
            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key_package => $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $is_epacket_imported = false;
                ?>
                <tr class="odd">
                    <td>
                        <button class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            onclick="onActionBtnShowClick(this)" data-bs-toggle="collapse"
                            data-bs-target="#package_<?php echo e($key_package); ?>" aria-expanded="false">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </td>
                    <td>
                        
                        <a class="fw-bold text-primary" href="<?php echo e(getUrlTracking($package['package_hawb_code'])); ?>">
                            <?php echo e($package['package_hawb_code']); ?>

                            <i class="ms-3 fas fa-map-marker-alt"></i>
                        </a>
                    </td>
                    <td><?php echo e($package['package_type_name']); ?></td>
                    <td class="fw-bold"><?php echo e($package['package_weight']); ?>kg</td>
                    <td>
                        <?php echo e($package['package_length']); ?>(<strong>L</strong>)
                        x
                        <?php echo e($package['package_width']); ?>(<strong>W</strong>)
                        x
                        <?php echo e($package['package_height']); ?>(<strong>H</strong>)
                        /
                        <?php echo e($shipment['service']['service_volumetric_mass']); ?>

                        =
                        <?php echo e($package['package_converted_weight']); ?>kg
                    </td>
                    <td class="fw-bold"><?php echo e($package['package_charged_weight']); ?>kg</td>
                    <td class="fw-bold">
                        <small class="badge badge-<?php echo e($colors[$package['package_status']]); ?>">
                            <i class="far fa-clock"></i>
                            <?php echo e($package['package_status_name']); ?>

                        </small>
                        <?php $__currentLoopData = onConvertStrArrImage($package['package_image']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a class="p-2" href="<?php echo e(asset($item)); ?>" target="_blank"><i
                                    class="fas fa-image"></i></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
                    <td class="fw-bold"><?php echo e($package['package_tracking_code']); ?></td>
                </tr>
                <tr class="child collapse" id="package_<?php echo e($key_package); ?>">
                    <td class="child" colspan="8">
                        <ul data-dtr-index="0" class="dtr-details">
                            <li data-dtr-index="8" data-dt-row="0" data-dt-column="8">
                                <span class="dtr-data">Nhân viên xử lý:</span>
                                <span class="dtr-title">
                                    <?php $__currentLoopData = $package->history_scans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $history_scan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <p><?php echo e($history_scan->user_contact_name); ?> <span
                                                class="fw-bold">(<?php echo e($history_scan->status_label); ?>sp)</span></p>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </span>
                            </li>
                            <li>
                                <span class="dtr-title">Phụ thu mặt hàng</span>
                                <?php if(
                                    $package['package_status'] != SHIPMENT_STATUS_CREATE &&
                                        !onCheckPositionAccounts([SETTING_FWD_ACCOUNT, SETTING_SALE_ACCOUNT], auth()->user()['position_id'])): ?>
                                    <button class="btn btn-icon btn-flush-primary btn-sm"
                                        onclick="getPackageDetail('<?php echo e($package['package_hawb_code']); ?>')"><span
                                            class="icon"><i class="fas fa-edit"></i></span></button>
                                <?php endif; ?>
                                <br>
                                <?php $__currentLoopData = $package['packages_sg']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <p><?php echo e($value['surcharge_goods_name'] ?? $value['external_surcharge_name']); ?> <span
                                            class="fw-bold">(<?php echo e($value['count']); ?>sp)</span> :
                                        <?php echo e(formatNumber($value['count'] * $value['price'])); ?></p>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </li>
                        </ul>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/shipment/ajax/table-packages.blade.php ENDPATH**/ ?>