<?php $__env->startSection('content'); ?>
    <?php
        $path = 'public/config/terms-interface.json';
        $content = Illuminate\Support\Facades\Storage::get($path);
        $content = isset($content) ? $content : '';
        $path_image_login = 'public/config/setting-images.json';
        $image_login = json_decode(Illuminate\Support\Facades\Storage::get($path_image_login), true)['image_login'] ?? 'assets/images/kango_logo2.jpg';
    ?>
    <!-- Wrapper -->
    <div class="hk-wrapper hk-pg-auth" data-footer="simple">
        <!-- Main Content -->
        <div class="hk-pg-wrapper py-0">
            <div class="hk-pg-body py-0">
                <!-- Container -->
                <div class="container-fluid">
                    <!-- Row -->
                    <div class="row auth-split">
                        <div class="col-xl-5 col-lg-6 col-md-7 position-relative mx-auto">
                            <div class="auth-content flex-column pt-8 pb-md-8 pb-13">
                                <div class="text-center mb-3">
                                    <a class="navbar-brand me-0" href="index.html">
                                        <img class="brand-img d-inline-block" width="170"
                                            src="<?php echo e(asset('assets/images/logo-export.png')); ?>" alt="brand">
                                    </a>
                                </div>
                                <form class="w-100" id="myForm">
                                    <div class="row">
                                        <div class="col-xl-7 col-sm-10 mx-auto">
                                            <div class="text-center mb-4">
                                                <h4>Đăng nhập vào tài khoản của bạn</h4>
                                                <p>Quản lý tài khoản của bạn</p>
                                            </div>
                                            <div class="row gx-3">
                                                <div class="form-group col-lg-12">
                                                    <div class="form-label-group">
                                                        <label>Tài khoản</label>
                                                    </div>
                                                    <input class="form-control" placeholder="Nhập tài khoản của bạn"
                                                        type="text" id="email">
                                                    <div id="email_err" class="invalid-feedback"></div>
                                                </div>
                                                <div class="form-group col-lg-12">
                                                    <div class="form-label-group">
                                                        <label>Mật khẩu</label>
                                                        <a type="button" class="" data-bs-toggle="modal"
                                                            data-bs-target="#forgot-password" class="fs-7 fw-medium">Quên
                                                            mật khẩu ?</a>
                                                    </div>
                                                    <div class="input-group password-check">
                                                        <span class="input-affix-wrapper affix-wth-text">
                                                            <input class="form-control" placeholder="Nhập mật khẩu của bạn"
                                                                value="" type="password" id="password">
                                                            <a href="#"
                                                                class="input-suffix text-primary text-uppercase fs-8 fw-medium">
                                                                <span>Hiển thị</span>
                                                                <span class="d-none">Ẩn</span>
                                                            </a>
                                                        </span>
                                                        <div id="password_err" class="invalid-feedback"></div>
                                                    </div>
                                                </div>
                                                <div class="form-group col-lg-12">
                                                    <div class="form-check form-check-sm">
                                                        <input type="checkbox" class="form-check-input"
                                                            id="agree_terms_use_service" checked>
                                                        <label class="form-check-label text-muted fs-7"
                                                            for="agree_terms_use_service">
                                                            Tuân Thủ
                                                            <a href="javascript:void(0)" data-bs-toggle="modal"
                                                                data-bs-target="#viewTermsUseService">
                                                                Điều Khoản Sử Dụng Dịch Vụ của KANGO EXPRESS!
                                                            </a>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <button class="btn btn-primary btn-uppercase btn-block mt-1" onclick="onLogin()"
                                                id="login_btn">Đăng nhập</button>

                                            <div style="padding-top: 1.0rem">
                                                <p class="d-inline-block me-1">Chưa có tài khoản?</p>
                                                <a class="d-inline-block" href="javascript:void(0)" data-bs-toggle="modal"
                                                    data-bs-target="#registerModal">
                                                    Đăng ký
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                                <div class=" mt-5"></div>
                                

                            </div>
                            <!-- Page Footer -->
                            <div class="hk-footer border-0">
                                <footer class="container-xxl footer">
                                    <div class="row">
                                        <div class="col-xl-8 text-center">
                                            <p class="footer-text pb-0"><span class="copy-text">Kango Express © 2024 All
                                                rights reserved.</span></p>
                                        </div>
                                    </div>
                                </footer>
                            </div>
                            <!-- / Page Footer -->
                        </div>
                        <div
                            class="col-xl-7 col-lg-6 col-md-5 col-sm-10 d-md-block d-none position-relative bg-primary-light-5 p-0">
                            <div class="vh-100">
                                <img src="<?php echo e(asset($image_login)); ?>" style="height: 100%; width: 100%;" />
                            </div>
                        </div>
                    </div>
                    <!-- /Row -->
                </div>
                <!-- /Container -->
            </div>
            <!-- /Page Body -->
        </div>
        <!-- /Main Content -->
    </div>
    <!-- /Wrapper -->

    <div class="modal fade" id="forgot-password" tabindex="-1" role="dialog" aria-labelledby="forgot-password"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Quên mật khẩu</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <label for="" class="control-label">Email</label>
                    <input type="email" class="form-control" id="email_forgot" placeholder="Nhập email tài khoản của bạn">

                    <div class="d-flex flex-row justify-content-end mt-3">
                        <button type="button" class="btn btn-secondary me-1" id="close-modal-forgot"
                            data-bs-dismiss="modal">Đóng</button>
                        <button type="button" class="btn btn-primary" id="confirm-modal-forgot"
                            onclick="onForgotPassword()">Xác nhận</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="viewTermsUseService" tabindex="-1" role="dialog"
        aria-labelledby="viewTermsUseServiceTitle" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header bg-primary">
                    <h5 class="modal-title text-white">Điều khoản</h5>
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal" aria-label="Close"><i class="fas fa-times"></i></button>
                  </div>
                <div class="modal-body">
                    <?php echo $content; ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Modal đăng ký -->
    <div class="modal fade" id="registerModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="registerModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="registerModalLabel">
                        REGISTER USER FOR KANGO SYSTEM
                    </h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <ul class="nav nav-tabs nav-icon nav-light">
                        <li class="nav-item" data-register_type="0">
                            <a class="nav-link active" data-bs-toggle="tab" href="#tab_register_account_fwd">
                                <span class="nav-icon-wrap">
                                    <span class="feather-icon">
                                        <i class="fa fa-building"></i>
                                    </span>
                                </span>
                                <span class="nav-link-text">
                                    Customer
                                </span>
                            </a>
                        </li>
                        <li class="nav-item" data-register_type="1">
                            <a class="nav-link" data-bs-toggle="tab" href="#tab_register_account_company">
                                <span class="nav-icon-wrap">
                                    <span class="feather-icon">
                                        <i class="fa fa-home"></i>
                                    </span>
                                </span>
                                <span class="nav-link-text">
                                    Kango Staff
                                </span>
                            </a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="tab_register_account_fwd">
                            <form id="myFormRegisterAccountFWD">
                                <div class="row">
                                    <div class="col-lg-4 d-flex justify-content-center align-items-center">
                                        <div class="form-group col-lg-12">
                                            <div class="d-flex justify-content-center">
                                                <label class="text-primary" for="user_logo_fwd">
                                                    Upload Logo Công ty *
                                                    <i class="fa fa-upload"></i>
                                                </label>
                                                <input accept="image/*" type="file" class="form-control d-none"
                                                    name="user_logo_fwd" id="user_logo_fwd"
                                                    onchange="displaySelectedImage(event, 'user_logo_preview')">
                                            </div>
                                            <div class="d-flex justify-content-center">
                                                <img id="user_logo_preview" src=""
                                                    style="max-width: 100%; max-height: 200px; object-fit: cover;"
                                                    alt="logo company">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-8">
                                        <div class="form-group">
                                            <div class="form-label-group">
                                                <label>Email *</label>
                                            </div>
                                            <input class="form-control" placeholder="Nhập email" type="text"
                                                name="user_name_fwd">
                                        </div>
                                        <div class="form-group">
                                            <div class="form-label-group">
                                                <label>Mã kế toán *</label>
                                            </div>
                                            <input class="form-control"
                                                placeholder="Ít nhất 10 ký tự gồm chữ thường, hoa, số" type="text"
                                                name="user_accountant_key_fwd">
                                        </div>
                                        <div class="form-group">
                                            <div class="form-label-group">
                                                <label>Tên công ty *</label>
                                            </div>
                                            <input class="form-control" placeholder="Nhập tên công ty" type="text"
                                                name="user_company_name_fwd">
                                        </div>
                                        <div class="form-group">
                                            <div class="form-label-group">
                                                <label>Tên liên hệ *</label>
                                            </div>
                                            <input class="form-control" placeholder="Nhập tên liên hệ" type="text"
                                                name="user_contact_name_fwd">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-lg-6">
                                        <div class="form-label-group">
                                            <label>Mã số thuế *</label>
                                        </div>
                                        <input class="form-control" placeholder="Nhập mã số thuế" type="text"
                                            name="user_tax_code_fwd">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <div class="form-label-group">
                                            <label>Điện thoại *</label>
                                        </div>
                                        <input class="form-control" placeholder="Nhập số điện thoại" type="number"
                                            name="user_phone_fwd">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label class="form-label">Tỉnh/Thành phố *</label>
                                        <select class="form-control select2 required" id="city_of_registration"
                                            name="city_of_registration">
                                            <option value="">Chọn Tỉnh/Thành phố</option>
                                            <?php $__currentLoopData = $address['cities']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key_city => $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key_city); ?>">
                                                    <?php echo e($city); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label class="form-label">Quận/Huyện *</label>
                                        <select class="form-control select2 required" id="district_of_registration"
                                            name="district_of_registration">
                                            <option value="">Chọn Quận/Huyện</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label class="form-label">Phường/Xã *</label>
                                        <select class="form-control select2 required" id="ward_of_registration"
                                            name="ward_of_registration">
                                            <option value="">Phường/Xã</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <div class="form-label-group">
                                            <label>Địa chỉ *</label>
                                            <a id="openModalLocation" href="javascript:void(0)" class="fs-7 fw-medium">
                                                Mở bản đồ
                                            </a>
                                        </div>
                                        <input class="form-control pac-target-input"
                                            placeholder="Mở bản đồ để chọn địa chỉ" type="text"
                                            name="user_address_fwd" id="user_address_fwd" 
                                            autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <div class="form-label-group">
                                            <label>Mật khẩu *</label>
                                        </div>
                                        <div class="input-group password-check">
                                            <span class="input-affix-wrapper affix-wth-text">
                                                <input class="form-control" placeholder="Nhập mật khẩu" value=""
                                                    type="password" name="password_fwd">
                                                <a href="javascript:void(0)"
                                                    class="input-suffix text-primary text-uppercase fs-8 fw-medium">
                                                    <span>Hiển thị</span>
                                                    <span class="d-none">Ẩn</span>
                                                </a>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <div class="form-label-group">
                                            <label>Nhập lại mật khẩu *</label>
                                        </div>
                                        <div class="input-group password-check">
                                            <span class="input-affix-wrapper affix-wth-text">
                                                <input class="form-control" placeholder="Nhập lại mật khẩu"
                                                    value="" type="password" name="confirm_password_fwd">
                                                <a href="javascript:void(0)"
                                                    class="input-suffix text-primary text-uppercase fs-8 fw-medium">
                                                    <span>Hiển thị</span>
                                                    <span class="d-none">Ẩn</span>
                                                </a>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="tab-pane fade" id="tab_register_account_company">
                            <form id="myFormRegisterAccountCompany">
                                <div class="row">
                                    <div class="form-group col-lg-6">
                                        <div class="form-group">
                                            <div class="form-label-group">
                                                <label>Email *</label>
                                            </div>
                                            <input class="form-control" placeholder="Nhập email" type="text"
                                                name="user_name_company">
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <div class="form-label-group">
                                            <label>Điện thoại *</label>
                                        </div>
                                        <input class="form-control" placeholder="Nhập số điện thoại" type="text"
                                            id="user_phone_company" name="user_phone_company">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <div class="form-label-group">
                                            <label>Tên liên hệ *</label>
                                        </div>
                                        <input class="form-control" placeholder="Nhập tên liên hệ" type="text"
                                            name="user_contact_name_company">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <div class="form-label-group">
                                            <label>Địa chỉ *</label>
                                        </div>
                                        <input class="form-control" placeholder="Nhập địa chỉ" type="text"
                                            name="user_address_company">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label class="form-label">Chức vụ *</label>
                                        <select class="form-control required" id="position_id_company"
                                            name="position_id_company">
                                            <option value="">Chọn chức vụ</option>
                                            <?php $__currentLoopData = $positions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $position): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($position['position_id']); ?>">
                                                    <?php echo e($position['position_name']); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label class="form-label">Chi nhánh *</label>
                                        <select class="form-control required" id="branch_id_company"
                                            name="branch_id_company">
                                            <option value="">Chọn chi nhánh</option>
                                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($branch['branch_id']); ?>">
                                                    <?php echo e($branch['branch_name']); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <div class="form-label-group">
                                            <label>Mật khẩu</label>
                                        </div>
                                        <div class="input-group password-check">
                                            <span class="input-affix-wrapper affix-wth-text">
                                                <input class="form-control" placeholder="Nhập mật khẩu" value=""
                                                    type="password" id="password_company" name="password_company">
                                                <a href="javascript:void(0)"
                                                    class="input-suffix text-primary text-uppercase fs-8 fw-medium">
                                                    <span>Hiển thị</span>
                                                    <span class="d-none">Ẩn</span>
                                                </a>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <div class="form-label-group">
                                            <label>Nhập lại mật khẩu</label>
                                        </div>
                                        <div class="input-group password-check">
                                            <span class="input-affix-wrapper affix-wth-text">
                                                <input class="form-control" placeholder="Nhập lại mật khẩu"
                                                    value="" type="password" id="confirm_password_company"
                                                    name="confirm_password_company">
                                                <a href="javascript:void(0)"
                                                    class="input-suffix text-primary text-uppercase fs-8 fw-medium">
                                                    <span>Hiển thị</span>
                                                    <span class="d-none">Ẩn</span>
                                                </a>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="modal-footer d-flex justify-content-center">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
                    <button type="button" class="btn btn-primary" id="onRegisterUser">
                        Đăng ký tài khoản
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalChooseLocation" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="modalChooseLocationLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Chọn vị trí</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <?php echo $__env->make('template.google-map.choose-and-input', [
                        'is_inp' => true,
                        'is_location' => false,
                        'new_inp_id' => 'user_address_fwd',
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="modal-footer d-flex justify-content-center">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Xong</button>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startPush('scripts'); ?>
        <script src="js/auth/login.js"></script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Dev\Laravel\WebExpress\kango\resources\views/auth/login.blade.php ENDPATH**/ ?>