<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th>Import scan time</th>
                <th>ID Bill</th>
                <th>N.V Scan</th>
                <th>Account tạo</th>
                <th>Company name sender</th>
                <th>Quốc gia</th>
                <th>Dịch vụ</th>
                <th>Kích thước</th>
                <th>Cân nặng</th>
                <th>Status</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php
                $colors = ['secondary', 'info', 'success', 'danger'];
            ?>
            <?php $__currentLoopData = $importedGoods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $goods): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="odd">
                    <td><?php echo e($goods['created_at']); ?></td>
                    <td>
                        <a href="<?php echo e(route('debit.fwd.imported-goods.detail', ['package_code' => $goods['package_code']])); ?>"
                            target="_blank">
                            <i class="fas fa-external-link-alt text-primary mr-2"></i>
                            <?php echo e($goods['package_code']); ?>

                        </a>
                    </td>
                    <td><?php echo e($goods['scan_by_name']); ?></td>
                    <td>
                        <?php if(onCheckPositionAccount(SETTING_FWD_ACCOUNT, $goods['creator_position_id'])): ?>
                            <a
                                href="<?php echo e(route('debit.fwd.detail.sm-fwd', ['company_code' => $goods['creator_code']])); ?>"><?php echo e($goods['creator_code']); ?></a>
                        <?php else: ?>
                            <?php echo e($goods['creator_code']); ?>

                        <?php endif; ?>
                        <?php echo $__env->make('components.badges-position-name', [
                            'position_id' => $goods['creator_position_id'],
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </td>
                    <td><?php echo e($goods['sender_company_name']); ?></td>
                    <td><?php echo e($goods['country_name']); ?></td>
                    <td><?php echo e($goods['service_name']); ?></td>
                    <td>
                        <?php echo e($goods['length']); ?> x
                        <?php echo e($goods['width']); ?> x
                        <?php echo e($goods['height']); ?>

                    </td>
                    <td><?php echo e($goods['weight']); ?> kg</td>
                    <td class="dtr-data fw-bold text-<?php echo e($goods['status'] == 0 ? 'danger' : 'success'); ?>">
                        <?php echo e($goods['status'] == 0 ? 'Chưa thanh toán' : 'Đã thanh toán'); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    <?php echo e($importedGoods->links('components.pagination')); ?>

</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/accounting-management/manager-debit/ajax/table-imported-goods.blade.php ENDPATH**/ ?>