<style>
    #map {
        height: 400px;
        width: 100%;
        margin-top: 10px;
    }

    div.pac-container {
        z-index: 99999999999 !important;
    }
</style>
<?php
    $new_inp_id = isset($new_inp_id) ? $new_inp_id : null;
?>

<div class="card card-hover">
    <div class="card-body">
        <div class="mb-3 <?php echo e(isset($is_inp) && $is_inp ? 'd-block' : 'd-none'); ?>">
            <h6 class="text-primary">Nhập địa chỉ:</h6>
            <input id="autocomplete" placeholder="Nhập địa chỉ" type="text" class="form-control">
        </div>

        <div class="<?php echo e(isset($is_location) && $is_location ? 'd-block' : 'd-none'); ?>">
            <h6 class="text-primary">Hoặc nhập kinh độ, vĩ độ để cập nhật bản đồ:</h6>
            <div class="row">
                <div class="col-sm-4">
                    <label for="lat">Vĩ độ:</label>
                    <input type="text" id="lat" placeholder="Vĩ độ" value="10.762622"
                        class="form-control form-control-sm">
                </div>
                <div class="col-sm-4">
                    <label for="lng">Kinh độ:</label>
                    <input type="text" id="lng" placeholder="Kinh độ" value="106.660172"
                        class="form-control form-control-sm">
                </div>
                <div class="col-sm-4">
                    <button class="btn btn-sm btn-primary mt-4"onclick="updateMapWithLatLng()">Cập nhật bản đồ</button>
                </div>
            </div>
        </div>

        <div id="map"></div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script></script>
    <?php if(auth()->check()): ?>
        <script src="<?php echo e(url('/get-google-maps-key')); ?>" async defer></script>
    <?php else: ?>
        <script src="<?php echo e(url('/data-register-account-address')); ?>" async defer></script>
    <?php endif; ?>

    <script>
        const new_id_complete = <?php echo json_encode($new_inp_id, 15, 512) ?>;
        let map, marker, autocomplete;
        let pub_latitude_map = null;
        let pub_longitude_map = null;
        let pub_address_map = null;

        $(document).ready(function() {
            $('#' + new_id_complete ? new_id_complete : 'autocomplete').keydown(function(event) {
                if (event.key === "Enter") {
                    event.preventDefault(); // Ngăn chặn sự kiện mặc định của phím Enter
                }
            });

        });

        function initAutocomplete() {
            // Tạo bản đồ mặc định
            map = new google.maps.Map(document.getElementById('map'), {
                center: {
                    lat: 10.762622,
                    lng: 106.660172
                },
                zoom: 13
            });

            marker = new google.maps.Marker({
                map: map,
                draggable: true
            });

            // Khởi tạo autocomplete và gắn vào input
            if (new_id_complete) {
                autocomplete = new google.maps.places.Autocomplete(document.getElementById(new_id_complete));
            } else {
                autocomplete = new google.maps.places.Autocomplete(document.getElementById('autocomplete'));
            }

            autocomplete.setFields(['geometry', 'formatted_address']);
            autocomplete.addListener('place_changed', onPlaceChanged);

            // Cập nhật vị trí khi kéo thả marker
            google.maps.event.addListener(marker, 'dragend', function() {
                let lat = marker.getPosition().lat();
                let lng = marker.getPosition().lng();

                pub_latitude_map = lat;
                pub_longitude_map = lng;

                // Cập nhật input kinh độ, vĩ độ
                document.getElementById('lat').value = lat;
                document.getElementById('lng').value = lng;

                // Cập nhật địa chỉ trong trường nhập
                getAddress(lat, lng);
            });

            // Cập nhật vị trí khi nhấp vào bản đồ
            google.maps.event.addListener(map, 'click', function(event) {
                let lat = event.latLng.lat();
                let lng = event.latLng.lng();

                marker.setPosition(event.latLng);

                pub_latitude_map = lat;
                pub_longitude_map = lng;

                document.getElementById('lat').value = lat;
                document.getElementById('lng').value = lng;

                getAddress(lat, lng);
            });
        }

        function onPlaceChanged() {
            let place = autocomplete.getPlace();

            if (!place.geometry) {
                alert("Không tìm thấy địa chỉ này. Vui lòng thử lại.");
                return;
            }

            let lat = place.geometry.location.lat();
            let lng = place.geometry.location.lng();

            map.setCenter(place.geometry.location);
            marker.setPosition(place.geometry.location);

            pub_latitude_map = lat;
            pub_longitude_map = lng;

            document.getElementById('lat').value = lat;
            document.getElementById('lng').value = lng;
        }

        function updateMapWithLatLng(_lat = null, _lng = null) {
            if (_lat && _lng) {
                document.getElementById('lat').value = _lat;
                document.getElementById('lng').value = _lng;
            }
            let lat = _lat ? _lat : parseFloat(document.getElementById('lat').value);
            let lng = _lng ? _lng : parseFloat(document.getElementById('lng').value);

            let newPosition = new google.maps.LatLng(lat, lng);
            map.setCenter(newPosition);
            marker.setPosition(newPosition);

            pub_latitude_map = lat;
            pub_longitude_map = lng;


            // Cập nhật địa chỉ trong trường nhập
            getAddress(lat, lng);
        }

        function getAddress(lat, lng) {
            let geocoder = new google.maps.Geocoder();
            let latlng = new google.maps.LatLng(lat, lng);

            geocoder.geocode({
                'location': latlng
            }, function(results, status) {
                if (status === 'OK') {
                    if (results[0]) {
                        pub_address_map = results[0].formatted_address;
                        if (new_id_complete) {
                            document.getElementById(new_id_complete).value = results[0].formatted_address;
                        } else {
                            document.getElementById('autocomplete').value = results[0].formatted_address;
                        }
                    } else {
                        alert("Không tìm thấy địa chỉ");
                    }
                } else {
                    alert("Geocoder failed due to: " + status);
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\Dev\Laravel\kango\kango\resources\views/template/google-map/choose-and-input.blade.php ENDPATH**/ ?>