<?php
    $is_show_modal = session()->has('is_show_modal_' . auth()->id())
        ? session()->get('is_show_modal_' . auth()->id())
        : false;
    $modal_notifications = [];
    $modal_notification_ids = [];
    if ($is_show_modal) {
        $modal_notifications = \App\Models\Notification::isActive(ACTIVE)
            ->isDelete(NO_DELETE)
            ->where('notification_important', NOTIFICATION_IMPORTANT)
            ->orderBy('created_at', 'desc')
            ->select('notification_id', 'notification_title', 'notification_content', 'created_at')
            ->get()
            ->toArray();
        $modal_notification_ids = collect($modal_notifications)->pluck('notification_id')->toArray();
    }
?>
<?php if($is_show_modal): ?>
    <?php $__currentLoopData = $modal_notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modal_notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="modal fade" id="exampleModalNotification<?php echo e($modal_notification['notification_id']); ?>" tabindex="-1"
            aria-labelledby="exampleModalLabel<?php echo e($modal_notification['notification_id']); ?>" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="exampleModalLabel<?php echo e($modal_notification['notification_id']); ?>">
                            <?php echo e($modal_notification['notification_title']); ?>

                        </h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body ck-content">
                        <?php echo $modal_notification['notification_content']; ?>

                    </div>
                    <div class="modal-footer d-flex justify-content-start">
                        <?php echo e(formatFullDate($modal_notification['created_at'])); ?>

                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        var modal_notification_ids = <?php echo json_encode($modal_notification_ids, 15, 512) ?>;
    </script>
    <script src="<?php echo e(asset('js/layouts/notifications.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\Dev\Laravel\WebExpress\kango\resources\views/layouts/notifications.blade.php ENDPATH**/ ?>