<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title><?php echo e($meta['title'] ?? 'Kango'); ?></title>

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="keywords" content="<?php echo e(isset($meta['keywords']) ? $meta['keywords'] : ''); ?>">
    <meta name="description" content="<?php echo e(isset($meta['description']) ? $meta['description'] : ''); ?>">
    <meta property="og:title" content="<?php echo e(isset($meta['title']) ? $meta['title'] : ''); ?>" />
    <meta property="og:type" content="article" />
    <meta property="og:url" content="<?php echo e(isset($meta['url']) ? $meta['url'] : ''); ?>" />
    <meta property="og:image" content="<?php echo e(isset($meta['image']) ? $meta['image'] : ''); ?>" />
    <meta property="og:description" content="<?php echo e(isset($meta['description']) ? $meta['description'] : ''); ?>" />
    <meta property="og:site_name" content="<?php echo e(isset($meta['site_name']) ? $meta['site_name'] : ''); ?>" />

    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>">
    <link rel="icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>" type="image/x-icon">
    <link href="<?php echo e(asset('assets/boxicons/css/boxicons.min.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/vendors/daterangepicker/daterangepicker.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/dist/css/style.css')); ?>" rel="stylesheet" type="text/css">

</head>

<body>

    <div class="hk-wrapper" data-layout="vertical" data-layout-style="default" data-menu="light" data-footer="simple">
        <div class="hk-pg-wrapper">
            <div class="container-xxl">
                <!-- Page Body -->
                <div class="hk-pg-body">
                    <div class="row">
                        <div class="col-xl-7 col-lg-6 d-lg-block d-none">
                            <div class="auth-content py-md-0 py-8">
                                <div class="row">
                                    <div class="col-xl-12 text-center">
                                        <img src="<?php echo e(asset('assets/dist/img/macaroni-fatal-error.png')); ?>"
                                            class="img-fluid w-sm-80 w-50" alt="login" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-5 col-lg-6 col-md-7 col-sm-10">
                            <div class="auth-content py-md-0 py-8">
                                <div class="w-100">
                                    <div class="row">
                                        <div class="col-xxl-9 col-xl-8 col-lg-11">
                                            <h1 class="display-4 fw-bold mb-2" style="font-size: 150px">404</h1>
                                            <p class="p-lg">Xin lỗi, chúng tôi không thể tìm thấy trang yêu cầu, xin
                                                vui lòng tìm với địa chỉ khác.</p>
                                            <a href="<?php echo e(url()->previous()); ?>" class="btn btn-primary mt-4">Trở về</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /Page Body -->
            </div>

        </div>

    </div>

    <script src="<?php echo e(asset('assets/vendors/bootstrap/dist/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/dist/js/feather.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/dist/js/dropdown-bootstrap-extended.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/simplebar/dist/simplebar.min.js')); ?>"></script>
</body>

</html><?php /**PATH C:\Dev\Laravel\WebExpress\kango\resources\views/template/errors/404.blade.php ENDPATH**/ ?>