<?php $__env->startSection('content'); ?>
    <!-- Main Content -->
    <div class="hk-pg-wrapper">
        <div class="mx-3">
            <!-- Page Header -->
            <div class="hk-pg-header pt-7 pb-4">
                <h1 class="pg-title">Thông tin cá nhân</h1>
                <p>Thành phần Avatar được sử dụng để đại diện cho người dùng và hiển thị ảnh hồ sơ, tên viết tắt hoặc biểu
                    tượng dự phòng.</p>
            </div>
            <!-- /Page Header -->

            <!-- Page Body -->
            <div class="hk-pg-body">
                <div class="row edit-profile-wrap">
                    <div class="col-lg-2 col-sm-3 col-4">
                        <div class="nav-profile mt-4">
                            <div class="nav-header">
                                <span>Tài khoản</span>
                            </div>
                            <ul class="nav nav-light nav-vertical nav-tabs">
                                <li class="nav-item">
                                    <a data-bs-toggle="tab" href="#update" class="nav-link fs-6 active"
                                        onclick="window.location.href='?tab=update'">
                                        <span class="nav-link-text"><i class='bx bxs-user-rectangle me-1'></i>Cập nhật thông
                                            tin</span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a data-bs-toggle="tab" href="#security" class="nav-link fs-6"
                                        onclick="window.location.href='?tab=security'">
                                        <span class="nav-link-text"><i class='bx bxs-lock-open me-1'></i>Bảo mật</span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a data-bs-toggle="tab" href="#recharge_history" class="nav-link fs-6"
                                        onclick="getListRecharge()">
                                        <span class="nav-link-text"><i class='bx bx-money-withdraw me-1'></i>Lịch sử
                                            nạp</span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a data-bs-toggle="tab" href="#wallet_fluctuation" class="nav-link fs-6"
                                        onclick="getListWalletFlut()">
                                        <span class="nav-link-text"><i class='bx bxs-wallet me-1'></i>Biến động số
                                            dư</span>
                                    </a>
                                </li>

                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-10 col-sm-9 col-8">
                        <div class="tab-content">
                            <?php switch($tab):
                                case ('update'): ?>
                                    <div class="tab-pane fade show active" id="update">
                                        <form>
                                            <div class="row gx-3">
                                                <div class="col-sm-12">
                                                    <div class="form-group">
                                                        <div class="media align-items-center">
                                                            <div class="media-head me-5">
                                                                <div class="avatar avatar-rounded avatar-xxl" id="avatar">
                                                                    <img src="" alt="">
                                                                </div>
                                                            </div>
                                                            <div class="media-body">
                                                                <div class="btn btn-soft-primary btn-file mb-1">
                                                                    Tải ảnh
                                                                    <input type="file" class="upload" id="user_logo"
                                                                        onchange="onChangeFile('user_logo', 'avatar')"
                                                                        accept="image/*">
                                                                </div>
                                                                <div class="form-text text-muted">
                                                                    Để có bản xem trước tốt hơn, kích thước được đề xuất là 450px x
                                                                    450px. Kích thước tối đa 5mb.
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                                                <span>Tài khoản</span>
                                            </div>
                                            <div class="row gx-3">
                                                <div class="col-sm-4 mb-3 fw-bold">Email:</div>
                                                <div class="col-sm-8 mb-3" id="user_name"></div>
                                            </div>
                                            <div class="row gx-3">
                                                <div class="col-sm-4 mb-3 fw-bold">ID Account:</div>
                                                <div class="col-sm-8 mb-3" id="user_code"></div>
                                            </div>
                                            <div class="row gx-3">
                                                <div class="col-sm-4 mb-3 fw-bold">Key for Api:</div>
                                                <div class="col-sm-8 mb-3" id="user_api_key"></div>
                                            </div>
                                            <div class="col-sm-12 mb-3">
                                                <label class="form-label">User name</label>
                                                <input class="form-control" type="text" value="" id="user_contact_name" />
                                                <small class="text-danger" id="user_contact_name_err"></small>
                                            </div>
                                            <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                                                <span>Công ty</span>
                                            </div>
                                            <div class="row gx-3">
                                                
                                                <div class="col-sm-12">
                                                    <div class="form-group">
                                                        <label class="form-label">Tên công ty</label>
                                                        <input class="form-control" type="text" value=""
                                                            id="user_company_name" />
                                                    </div>
                                                    <small class="text-danger" id="user_company_name_err"></small>
                                                </div>
                                                <div class="col-sm-12">
                                                    <div class="form-group">
                                                        <label class="form-label">Mã số thuế</label>
                                                        <input class="form-control" type="text" value=""
                                                            id="user_tax_code" />
                                                    </div>
                                                    <small class="text-danger" id="user_tax_code_err"></small>
                                                </div>
                                                <div class="row gx-3">
                                                    <div class="col-sm-4 mb-3 fw-bold">Hạn mức nợ tối đa:</div>
                                                    <div class="col-sm-8 mb-3" id="user_limit_amount_for_sale"></div>
                                                </div>
                                                
                                                <div class="col-12">
                                                    <div class="d-flex justify-content-between">
                                                        <div class="form-check mb-3">
                                                            <input type="checkbox" name="agree_user_signature"
                                                                class="form-check-input" id="agree_user_signature">
                                                            <label class="form-check-label" for="agree_user_signature">
                                                                Xác nhận lưu và sử dụng chữ ký này!
                                                            </label>
                                                        </div>
                                                        <div class="" id="display_user_signature">

                                                        </div>
                                                    </div>
                                                    <div class="col-9" id="bcPaint"></div>
                                                </div>
                                            </div>
                                            <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                                                <span>Liên lạc</span>
                                            </div>
                                            <div class="row gx-3">
                                                <div class="col-sm-12 mb-3">
                                                    <div class="form-group">
                                                        <label class="form-label">Số điện thoại</label>
                                                        <input class="form-control" type="text" value=""
                                                            id="user_phone" />
                                                    </div>
                                                    <small class="text-danger" id="user_phone_err"></small>
                                                </div>
                                                <div class="col-sm-12 mb-3">
                                                    <div class="form-group">
                                                        <label class="form-label">Tỉnh/Thành phố</label>
                                                        <select class="form-control select2" id="address1">
                                                            <option value="">Chọn Tỉnh/Thành phố</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-sm-12 mb-3">
                                                    <div class="form-group">
                                                        <label class="form-label">Quận/Huyện</label>
                                                        <select class="form-control select2" id="address2">
                                                            <option value="">Chọn Quận/Huyện</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-sm-12 mb-3">
                                                    <div class="form-group">
                                                        <label class="form-label">Phường/Xã</label>
                                                        <select class="form-control select2" id="address3">
                                                            <option value="">Chọn Phường/Xã</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-sm-12 mb-3">
                                                    <div class="form-group">
                                                        <label class="form-label">Địa chỉ</label>
                                                        <input class="form-control" type="text" id="user_address" />
                                                    </div>
                                                    <small class="text-danger" id="user_address_err"></small>
                                                </div>
                                            </div>
                                            <div class="text-end">
                                                <button type="button" id="updateInfo" onclick="updateInfoUser()"
                                                    class="btn btn-primary mt-5">Cập nhật</button>
                                            </div>
                                        </form>
                                    </div>
                                <?php break; ?>

                                <?php case ('security'): ?>
                                    <div class="tab-pane fade" id="security">
                                        <div class="title-lg fs-4"><span>Đăng nhập & bảo mật</span></div>
                                        <form>
                                            <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                                                <span>Cài đặt mật khẩu</span>
                                            </div>
                                            <div class="row gx-3">
                                                <div class="col-sm-12">
                                                    <div class="form-group">
                                                        <label class="form-label">Mật khẩu cũ</label>
                                                        
                                                        <div class="input-group password-check">
                                                            <span class="input-affix-wrapper affix-wth-text">
                                                                <input class="form-control" placeholder="Nhập mật khẩu của bạn"
                                                                    value="" type="password" id="old_password">
                                                                <a href="#"
                                                                    class="input-suffix text-primary text-uppercase fs-8 fw-medium">
                                                                    <span>Hiển thị</span>
                                                                    <span class="d-none">Ẩn</span>
                                                                </a>
                                                            </span>
                                                            <small id="old_password_err" class="text-danger"></small>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-12">
                                                    <div class="form-group">
                                                        <label class="form-label">Mật khẩu mới</label>
                                                        
                                                        <div class="input-group password-check">
                                                            <span class="input-affix-wrapper affix-wth-text">
                                                                <input class="form-control" placeholder=""
                                                                    value="" type="password" id="password">
                                                                <a href="#"
                                                                    class="input-suffix text-primary text-uppercase fs-8 fw-medium">
                                                                    <span>Hiển thị</span>
                                                                    <span class="d-none">Ẩn</span>
                                                                </a>
                                                            </span>
                                                            <small id="password_err" class="text-danger"></small>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-12">
                                                    <div class="form-group">
                                                        <label class="form-label">Xác nhận mật khẩu</label>
                                                        
                                                        <div class="input-group password-check">
                                                            <span class="input-affix-wrapper affix-wth-text">
                                                                <input class="form-control" placeholder=""
                                                                    value="" type="password" id="confirm_password">
                                                                <a href="#"
                                                                    class="input-suffix text-primary text-uppercase fs-8 fw-medium">
                                                                    <span>Hiển thị</span>
                                                                    <span class="d-none">Ẩn</span>
                                                                </a>
                                                            </span>
                                                            <small id="confirm_password_err" class="text-danger"></small>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="text-end">
                                                    <button type="button" class="btn btn-primary mt-3" id="change_password">Đổi
                                                        mật khẩu</button>
                                                </div>
                                            </div>
                                            
                                        </form>
                                        <?php if(onCheckPositionAccount(SETTING_FWD_ACCOUNT, auth()->user()['position_id'])): ?>
                                            <form>
                                                <div class="title title-xs title-wth-divider text-primary text-uppercase my-4">
                                                    <span>Cài đặt mã kế toán</span>
                                                </div>
                                                <div class="row gx-3">
                                                    <div class="col-sm-12">
                                                        <div class="form-group">
                                                            <label class="form-label">Mã kế toán mới</label>
                                                            <input class="form-control" type="text" id="user_accountant_key" />
                                                            <small id="user_accountant_key_err" class="text-danger"></small>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-12">
                                                        <div class="form-group">
                                                            <label class="form-label">Mật khẩu hiện tại</label>
                                                            <div class="input-group">
                                                                <input class="form-control" type="password" id="current_password" />
                                                                <span class="input-group-text" id="password-toggle">
                                                                    <i class="fas fa-eye" id="password-icon"></i>
                                                                </span>
                                                            </div>
                                                            <small id="current_password_err" class="text-danger"></small>
                                                        </div>
                                                    </div>
                                                    <div class="text-end">
                                                        <button type="button" class="btn btn-primary mt-3"
                                                            id="change_user_accountant_key">Đổi
                                                            mã kế toán</button>
                                                    </div>
                                                </div>

                                            </form>
                                        <?php endif; ?>
                                    </div>
                                <?php break; ?>

                                <?php case ('recharge_history'): ?>
                                    <div class="tab-pane fade" id="recharge_history">
                                        <div class="title-lg fs-4"><span>Lịch sử nạp tiền</span></div>
                                        <div class="row gx-3">
                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label class="form-label">Chọn khoảng thời gian *</label>
                                                        <input type="text" name="discount_user_daterange"
                                                            class="form-control">
                                                        <small id="error_discount_user_daterange" class="text-danger"></small>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 mb-3">
                                                    <label for="" class="form-label">Tìm kiếm theo</label>
                                                    <div class="input-group">
                                                        <select name="" id="key_type" class="form-select">
                                                            <option value="">Chọn kiểu</option>
                                                            <option value="code">Mã</option>
                                                            <option value="note">Ghi chú</option>
                                                        </select>
                                                        <input id="keywords" type="text" class="form-control" placeholder=""
                                                            onchange="displayTabContent('recharge_history')">
                                                        <button class="btn btn-primary"
                                                            onclick="displayTabContent('recharge_history')" type="button"><i
                                                                class="fas fa-search"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="" id="content">

                                            </div>
                                        </div>
                                    </div>
                                <?php break; ?>

                                <?php case ('wallet_fluctuation'): ?>
                                    <div class="tab-pane fade" id="wallet_fluctuation">
                                        <div class="title-lg fs-4"><span>Biến động số dư</span></div>
                                        <div class="row gx-3">
                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label class="form-label">Chọn khoảng thời gian *</label>
                                                        <input type="text" name="discount_user_daterange"
                                                            class="form-control">
                                                        <small id="error_discount_user_daterange" class="text-danger"></small>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 mb-3">
                                                    <label for="" class="form-label">Tìm kiếm theo</label>
                                                    <div class="input-group">
                                                        <select name="" id="key_type" class="form-select">
                                                            <option value="">Chọn kiểu</option>
                                                            <option value="code">Mã</option>
                                                            <option value="note">Ghi chú</option>
                                                        </select>
                                                        <input id="keywords" type="text" class="form-control" placeholder=""
                                                            onchange="displayTabContent('wallet_fluctuation')">
                                                        <button class="btn btn-primary"
                                                            onclick="displayTabContent('wallet_fluctuation')" type="button"><i
                                                                class="fas fa-search"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="" id="content"></div>
                                        </div>
                                    </div>
                                <?php break; ?>

                                <?php default: ?>
                            <?php endswitch; ?>
                        </div>
                    </div>
                </div>
                <!-- /Page Body -->
            </div>
        </div>

        <div class="offcanvas w-md-50 offcanvas-end" tabindex="-1" id="offcanvasRecharge"
            aria-labelledby="offcanvasTopLabel">
            <div class="offcanvas-header bg-primary">
                <h5 id="offcanvasRechargeLabel" class="text-white">Chi tiết yêu cầu</h5>
                <button type="button" class="btn-close text-reset text-white" data-bs-dismiss="offcanvas"
                    aria-label="Close"></button>
            </div>
            <div class="offcanvas-body">
                <div id="content-recharge-detail">

                </div>
            </div>
        </div>
        

        <!-- /Main Content -->
        <?php $__env->startPush('scripts'); ?>
            <!-- Dropify JS -->
            

            <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/signaturepad/bcPaint.css')); ?>">
            <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/signaturepad/demo-page.css')); ?>">
            <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/signaturepad/bcPaint.mobile.css')); ?>">
            <script src="<?php echo e(asset('assets/vendors/signaturepad/bcPaint.js')); ?>"></script>

            <script type="text/javascript">
                $('#bcPaint').bcPaint();
                const user_id = <?php echo json_encode($user_id, 15, 512) ?>;
                $(".select2").select2();

                $('input[name="discount_user_daterange"]').daterangepicker({
                    opens: 'left',
                    startDate: moment().subtract(3, 'months').startOf('month'),
                    endDate: moment().endOf('month'),
                    locale: {
                        format: 'DD/MM/YYYY',
                        applyLabel: "Áp dụng",
                        cancelLabel: "Hủy",
                        customRangeLabel: "Tùy chỉnh",
                        daysOfWeek: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                        monthNames: [
                            "Tháng 1",
                            "Tháng 2",
                            "Tháng 3",
                            "Tháng 4",
                            "Tháng 5",
                            "Tháng 6",
                            "Tháng 7",
                            "Tháng 8",
                            "Tháng 9",
                            "Tháng 10",
                            "Tháng 11",
                            "Tháng 12",
                        ],
                    }
                }, function(start, end, label) {

                });
            </script>


            <script src="<?php echo e(asset('js/auth/profile.js')); ?>"></script>
        <?php $__env->stopPush(); ?>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/profile/index.blade.php ENDPATH**/ ?>