<div class="table-responsive" style="min-height:500px">
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">#</th>
                <th scope="col">Tài khoản</th>
                <th scope="col">Mã người dùng</th>
                <th scope="col">Công ty</th>
                <th scope="col">Số điện thoại</th>
                <th scope="col">Công nợ</th>
                
                <th scope="col">Hạn mức nợ</th>
                <th scope="col">Hạn mức còn lại</th>
                <th scope="col">Logo</th>
                <th scope="col">Sale quản lý</th>
                <th scope="col">Năm ký hợp đồng</th>
                <th scope="col">Ngày tạo</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="text-nowrap">
                    <th scope="row">
                        <?php echo e($loop->iteration); ?>.
                        <?php if(isGetAllData() && !onCheckDocumentAccount()): ?>
                            <div class="btn-group dropdown">
                                <button type="button" class="btn btn-icon btn-flush-secondary"
                                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <span class="icon"><i class="fas fa-cog"></i></span>
                                </button>
                                <div class="dropdown-menu dropdown-bordered">
                                    <button class="dropdown-item" onclick="onEditFWDUser(<?php echo e($user['user_id']); ?>)"><i
                                            class="dropdown-icon fas fa-pen"></i><span>Cập nhật</span></button>
                                    <div class="dropdown-divider"></div>

                                    <button class="dropdown-item"
                                        onclick="onLockUser(<?php echo e($user['user_id']); ?>, <?php echo e($user['active_flg']); ?>)"><i
                                            class="dropdown-icon fas <?php echo e($user['active_flg'] == ACTIVE ? 'fa-lock' : 'fa-unlock'); ?>">
                                        </i><span><?php echo e($user['active_flg'] == ACTIVE ? 'Khóa' : 'Mở'); ?> tài
                                            khoản</span></button>
                                    <div class="dropdown-divider"></div>

                                    <button class="dropdown-item"
                                        onclick="onLockExport(<?php echo e($user['user_id']); ?>, <?php echo e($user['is_export']); ?>)">
                                        <i
                                            class="dropdown-icon fas <?php echo e($user['is_export'] == ACTIVE ? 'fa-plane-arrival' : 'fa-plane-departure'); ?>">
                                        </i><span><?php echo e($user['is_export'] == ACTIVE ? 'Khóa' : 'Mở'); ?>

                                            Export</span></button>
                                    <div class="dropdown-divider"></div>

                                    <div class="dropdown-divider"></div>
                                    <?php if(onCheckAdminAccount()): ?>
                                        <button class="dropdown-item"
                                            onclick="onDeleteUserById(<?php echo e($user['user_id']); ?>)"><i
                                                class="dropdown-icon fas fa-trash"></i><span>Xóa tài
                                                khoản</span></button>
                                        <div class="dropdown-divider"></div>
                                    <?php endif; ?>

                                    <button class="dropdown-item"
                                        onclick="onDeductWallet(<?php echo e($user['user_id']); ?>, <?php echo e($user['wallet']['amount'] ?? null); ?> )">
                                        <i class="dropdown-icon fas fa-wallet text-danger"></i>
                                        <span>Trừ tiền trong ví</span>
                                    </button>
                                    <div class="dropdown-divider"></div>
                                    <button class="dropdown-item"
                                        onclick="onOpenResetDebitModal( <?php echo e($user['user_id']); ?>, '<?php echo e($user['user_contact_name']); ?>' )">
                                        <i class="dropdown-icon fas fa-wallet text-warning"></i>
                                        <span>Reset công nợ</span>
                                    </button>
                                    <div class="dropdown-divider"></div>
                                    <button class="dropdown-item"
                                        onclick="onDeductDebit( <?php echo e($user['user_id']); ?>, <?php echo e($user['user_remaining_limit']); ?> )">
                                        <i class="dropdown-icon fas fa-wallet text-warning"></i>
                                        <span>Trừ công nợ</span>
                                    </button>
                                </div>
                            </div>
                        <?php endif; ?>
                    </th>
                    <td>
                        <?php echo e($user['user_name']); ?>

                        <?php if($user['active_flg'] == INACTIVE): ?>
                            <i data-bs-toggle="tooltip" data-bs-placement="right" title="Tài khoản đã bị khóa"
                                class="ms-1 fas fa-lock"></i>
                        <?php endif; ?>
                        <?php if($user['is_export'] == INACTIVE): ?>
                            <i data-bs-toggle="tooltip" data-bs-placement="right"
                                title="Tài khoản đang bị khóa xuất đơn hàng" class="fas fa-plane-arrival"></i>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($user['user_code']); ?></td>
                    <td><?php echo e($user['user_company_name']); ?></td>
                    <td><?php echo e($user['user_phone']); ?></td>
                    <td><?php echo e($user['user_debit_type_name']); ?></td>
                    
                    <td>
                        <?php if($user['position']['limit_amount_flg'] == NO_LIMIT): ?>
                            Không giới hạn
                        <?php else: ?>
                            <?php echo e(formatNumber($user['user_limit_amount_for_sale'])); ?>đ
                        <?php endif; ?>
                    </td>
                    <td><?php echo e(formatNumber($user['user_remaining_limit'])); ?>đ</td>
                    <td class="text-center">
                        <?php if(isset($user['user_logo'])): ?>
                            <a href="<?php echo e(isset($user['user_logo']) ? asset($user['user_logo']) : 'javascript:void(0);'); ?>"
                                target="_blank" rel="noopener noreferrer">
                                <i class="zmdi zmdi-image"></i>
                            </a>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php echo e($user['saleLinkFwd']['saleAccount']['user_contact_name'] ?? ''); ?>

                    </td>
                    <td>
                        <?php echo e($user['contract_years'] ?? ''); ?>

                    </td>
                    <td>
                        <?php echo e(formatDate($user['created_at'])); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    <?php echo e($users->links('components.pagination')); ?>

</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/manage/admin/system/fwd-user/fwd-users-pagination.blade.php ENDPATH**/ ?>