<div class="row">
    <div class="col-sm-12 table-responsive">
        <table id="datable_1" class="table w-100 mb-5 no-footer">
            <thead class="thead-primary">
                <tr role="row">
                    <th tabindex="0" rowspan="1" colspan="1">Date </th>
                    <th tabindex="0">ID Bill</th>
                    <th colspan="1">Chi nhánh</th>
                    <th>Quốc gia</th>
                    <th>Dịch vụ</th>
                    <th class="text-white" colspan="1">Số
                        kiện</th>
                    <th class="text-white" colspan="1">
                        Charge Weight</th>
                    <th class="text-white" colspan="1">
                        Tổng tiền</th>
                    <th class="text-white" colspan="1">
                        phụ thu</th>
                    <th class="text-white" colspan="1">
                        Vat</th>
                    <th class="text-white" colspan="1">
                        Thanh toán</th>
                    <th class="text-white" colspan="1">
                        Trạng thái</th>
                    <th class="text-white" colspan="1">
                        Hoa hồng/Kg</th>
                    <th class="text-white" colspan="1">
                        Total cost</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $packages = $shipment['packages'] ?? [];
                        $weight = collect($packages)->sum('package_charged_weight') ?? 0;
                        $data_costs = getDataFwdCost(
                            $shipment['user_id']  ?? null,
                            $shipment['service']['service_id'],
                            $sale_team['member_kind'] ?? null,
                            $weight,
                        );
                    ?>
                    <tr class="odd">
                        <td>
                            <?php echo e(formatFullDate($shipment['created_at'])); ?>

                        </td>
                        <td>
                            <a
                                class="fw-bold text-primary"href="<?php echo e(route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']])); ?>">
                                <?php echo e($shipment['shipment_code']); ?>

                            </a>
                        </td>
                        <td><?php echo e($shipment['branch']['branch_name']); ?></td>
                        <td><?php echo e($shipment['country']['country_name']); ?></td>
                        <td>
                            <?php echo $__env->make('components.badges-promotion-name', [
                                'service_id' => $shipment['shipment_service_id'],
                                'promotion_flg' => $shipment['service']['promotion_flg'],
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo e($shipment['service']['service_name']); ?>

                        </td>
                        <td><?php echo e(collect($packages)->count()); ?></td>
                        <td>
                            <?php echo e(formatNumber($weight)); ?>

                        </td>
                        <td>
                            <?php echo e(formatNumber($shipment['shipment_final_amount'] ?? 0)); ?>

                        </td>
                        <td>
                            <?php echo e(formatNumber(getSurchargeGoodPackages($shipment['shipment_id'])['price'])); ?>

                        </td>
                        <td>
                            <?php echo e(formatNumber($shipment['shipment_amount_vat'])); ?>

                        </td>
                        <td>
                            <span
                                class="badge badge-<?php echo e($shipment['shipment_payment_status'] == 0 ? 'danger' : 'success'); ?> badge-pill">
                                <?php echo e($shipment['shipment_payment_status'] == 0 ? 'Chưa' : 'Đã'); ?> thanh toán
                            </span>
                        </td>
                        <td>
                            <?php echo e($shipment['shipment_status_name']); ?>

                        </td>
                        <td>
                            <?php echo e(formatNumber(checkHaveProfitShipment($shipment['shipment_status']) ? $data_costs['sale_cost'] : 0)); ?>

                        </td>
                        <td>
                            <?php echo e(formatNumber(checkHaveProfitShipment($shipment['shipment_status']) ? $data_costs['amount_weight'] : 0)); ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<div class="d-flex justify-content-center mt-3">
    <?php echo e($shipments->links('components.pagination') ?? ''); ?>

</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/manage/sale/ajax/fwd/table-shipment.blade.php ENDPATH**/ ?>