<div class="table-responsive">
    <table class="table">
        <thead class="thead-primary">
            <tr role="row">
                <th></th>
                <th>Ngày</th>
                <th>ID Bill</th>
                <th>Người tạo</th>
                <th>Công ty gửi</th>
                <th>Người nhận</th>
                <th>Quốc gia</th>
                <th>Dịch vụ</th>
                <th>Số kiện</th>
                <th>Cân nặng</th>
                <th>Trạng thái</th>
                <th>Debit</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $colors = ['secondary', 'info', 'success', 'danger'];
            ?>
            <?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="odd">
                    <td>
                        <button id="btn_shipment_<?php echo e($key); ?>" onclick="onActionBtnShowClick(this)"
                            class="btn btn-floating btn-icon btn-rounded btn-flush-success btn-xs"
                            data-bs-toggle="collapse" data-bs-target="#shipment_<?php echo e($key); ?>"
                            aria-expanded="false">
                            <span class="icon">
                                <i class="fa fa-plus"></i>
                            </span>
                        </button>
                    </td>
                    <td><?php echo e(formatFullDate($shipment['created_at'])); ?></td>
                    <td>
                        <a class="fw-bold text-primary" target="_blank"
                            href="<?php echo e(route('shipments.detail.show', ['shipment_code' => $shipment['shipment_code']])); ?>">
                            <?php echo e($shipment['shipment_code']); ?>

                        </a>
                    </td>
                    <td>
                        <a href="<?php echo e(route('debit.fwd.detail.sm-fwd', ['company_code' => $shipment['user_code']])); ?>">
                            <?php echo e($shipment['user_contact_name']); ?> [<?php echo e($shipment['user_code']); ?>]
                        </a>
                    </td>
                    <td>
                        <?php echo e($shipment['sender_company_name']); ?>

                    </td>
                    <td>
                        <?php echo e($shipment['receiver_contact_name']); ?>

                    </td>
                    <td><?php echo e($shipment['country']['country_name'] ?? ''); ?></td>
                    <td><?php echo e($shipment['service']['service_name'] ?? ''); ?></td>
                    <td>
                        <?php echo e(collect($shipment['packages'])->count('package_id')); ?>

                    </td>
                    <td>
                        <?php echo e(collect($shipment['packages'])->sum('package_weight')); ?>

                    </td>
                    <td>
                        <?php if($shipment['shipment_payment_status'] == 1): ?>
                            <span class="dtr-data fw-bold text-success">
                                Đã thanh toán
                            </span>
                        <?php else: ?>
                            <?php if($shipment['shipment_payment_step'] > 1): ?>
                                <span class="dtr-data fw-bold text-warning">
                                    Duyệt tạm ứng
                                </span>
                            <?php else: ?>
                                <span class="dtr-data fw-bold text-danger">
                                    Chưa thanh toàn
                                </span>
                            <?php endif; ?>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if(!empty($shipment['debit']['debit_no'])): ?>
                            <a class="fw-bold" href="<?php echo e(route('debit.detail', ['debit_code' => $shipment['debit']['debit_no']])); ?>">
                                <?php echo e($shipment['debit']['debit_no'] ?? ''); ?></a>
                        <?php endif; ?>
                        
                    <td>
                </tr>
                <tr class="child collapse" id="shipment_<?php echo e($key); ?>">
                    <td class="child" colspan="7">
                        <ul>
                            <li class="mb-3">
                                <span class="dtr-title">Trạng thái: </span>
                                <span class="dtr-data">
                                    <small class="badge badge-<?php echo e($colors[$shipment['shipment_status']]); ?>">
                                        <?php echo e($shipment['shipment_status_name']); ?>

                                    </small>
                                </span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Ref: </span>
                                <span class="dtr-data"><?php echo e($shipment['shipment_reference_code']); ?></span>
                            </li>
                            <li class="mb-3">
                                <span class="dtr-title">Tổng tiền: </span>
                                <span class="dtr-data">
                                    <?php echo e(formatNumber($shipment['shipment_final_amount'])); ?> VND
                                </span>
                            </li>
                            <li>
                                <span class="dtr-title"></span>
                                <span class="dtr-data">
                                    <a href="<?php echo e(route('shipments.edit.show', ['shipment_code' => $shipment['shipment_code']])); ?>"
                                        type="button" class="btn btn-warning btn-sm"><i class="far fa-edit"></i></a>
                                </span>
                            </li>
                        </ul>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    <?php echo e($shipments->links('components.pagination')); ?>

</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/accounting-management/manager-debit/ajax/table-shipment.blade.php ENDPATH**/ ?>