<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title><?php echo e($meta['title'] ?? 'Kango'); ?></title>

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="keywords" content="<?php echo e(isset($meta['keywords']) ? $meta['keywords'] : ''); ?>">
    <meta name="description" content="<?php echo e(isset($meta['description']) ? $meta['description'] : ''); ?>">
    <meta property="og:title" content="<?php echo e(isset($meta['title']) ? $meta['title'] : ''); ?>" />
    <meta property="og:type" content="article" />
    <meta property="og:url" content="<?php echo e(isset($meta['url']) ? $meta['url'] : ''); ?>" />
    <meta property="og:image" content="<?php echo e(isset($meta['image']) ? $meta['image'] : ''); ?>" />
    <meta property="og:description" content="<?php echo e(isset($meta['description']) ? $meta['description'] : ''); ?>" />
    <meta property="og:site_name" content="<?php echo e(isset($meta['site_name']) ? $meta['site_name'] : ''); ?>" />

    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>">
    <link rel="icon" href="<?php echo e(asset('assets/images/favicon.ico')); ?>" type="image/x-icon">

    <!-- Sweetalert2 CSS -->




    <!-- boxicons CSS -->
    <link href="<?php echo e(asset('assets/boxicons/css/boxicons.min.css')); ?>" rel="stylesheet" type="text/css">

    <!-- Daterangepicker CSS -->
    <link href="<?php echo e(asset('assets/vendors/daterangepicker/daterangepicker.css')); ?>" rel="stylesheet" type="text/css" />

    <!-- Data Table CSS -->
    <link href="<?php echo e(asset('assets/vendors/datatables.net-bs5/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet"
        type="text/css" />
    <link href="<?php echo e(asset('assets/vendors/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css')); ?>"
        rel="stylesheet" type="text/css" />

    <!-- CSS -->
    <link href="<?php echo e(asset('assets/dist/css/style.css')); ?>" rel="stylesheet" type="text/css">


    <link href="<?php echo e(asset('assets/vendors/select2/dist/css/select2.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/vendors/sweetalert2/dist/sweetalert2.min.css')); ?>" rel="stylesheet" type="text/css">

    <!-- drop zone -->
    <link href="<?php echo e(asset('assets/vendors/dropzone/dist/dropzone.min.css')); ?>" rel="stylesheet" type="text/css" />

    <link href="<?php echo e(asset('assets/css/content-styles.css')); ?>" rel="stylesheet" type="text/css" />
</head>

<body>
    <?php echo $__env->make('template.preload', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if(session('success')): ?>
        <div id="message_session_success" class="alert alert-success d-none">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div id="message_session_error" class="alert alert-success d-none">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>
    <?php if(auth()->check()): ?>
        <div class="hk-wrapper" data-layout="vertical" data-layout-style="default" data-menu="light"
            data-footer="simple">
            <!-- Top Navbar -->
            <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- /Top Navbar -->

            <!-- Vertical Nav -->
            <?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- /Vertical Nav -->

            <?php
                try {
                    $path = 'public/config/system-settings.json';
                    $position_ids = collect(json_decode(Storage::get($path), true))->firstWhere(
                        'kind',
                        SETTING_ACCOUNT_TICKET,
                    )['position_ids'];
                    $is_use_ticket = in_array(
                        auth()->user()['position_id'],
                        isset($position_ids) && $position_ids != '' ? $position_ids : [],
                    );
                    if ($is_use_ticket) {
                        $tiket_kinds = config('constans.constans.tiket_kinds');
                    }
                } catch (\Throwable $th) {
                    $is_use_ticket = false;
                }
            ?>
            <?php if($is_use_ticket): ?>
                <?php echo $__env->make('supports.tickets.me.popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>

            <!-- Main Content -->
            <?php echo $__env->yieldContent('content'); ?>
            <!-- /Main Content -->

            <?php echo $__env->make('components.button-contact', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('layouts.notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <!-- Fullscreen Search Modal -->
            <div class="modal fade" id="fullscreenSearchModal" tabindex="-1" aria-labelledby="fullscreenSearchLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-fullscreen">
                    <div class="modal-content fullscreen-search">
                        <div class="modal-header " style="background-color: #21235B">
                            <div class="d-flex justify-content-between align-items-center w-100">
                                <div class="">
                                    <img class="brand-img img-fluid mt-3" width="170px" src="<?php echo e(asset(LOGO)); ?>"
                                        alt="brand" />
                                </div>
                                <div class=""><button type="button" class="btn btn-danger"
                                        data-bs-dismiss="modal" aria-label="Close"><i class="fas fa-times"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="modal-body d-flex flex-column justify-content-center align-items-center bg-cover"
                            style="background-image: url('<?php echo e(asset('assets/images/bg-search.jpg')); ?>');">
                            <div class="w-100 text-center">
                                <h1>KSN POST</h1>
                                <h5>Track your shipment</h5>
                            </div>
                            <form class="w-50" action="<?php echo e(URL_TRACKING); ?>" method="GET" target="_blank">
                                <div class="input-group">
                                    <input type="search" class="form-control form-control-lg"
                                        placeholder="Input Your Tracking Number" name="code">
                                    <button class="btn btn-lg btn-primary" type="submit">TRACK</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <?php echo $__env->yieldContent('content'); ?>
    <?php endif; ?>

    <div id="toast-container" class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 1100;"></div>
    <script src="<?php echo e(asset('js/utils.js')); ?>"></script>
    <!-- jQuery -->
    <script src="<?php echo e(asset('assets/vendors/jquery/dist/jquery.min.js')); ?>"></script>

    <!-- Bootstrap Core JS -->
    <script src="<?php echo e(asset('assets/vendors/bootstrap/dist/js/bootstrap.bundle.min.js')); ?>"></script>

    <!-- FeatherIcons JS -->
    <script src="<?php echo e(asset('assets/dist/js/feather.min.js')); ?>"></script>

    <!-- Fancy Dropdown JS -->
    <script src="<?php echo e(asset('assets/dist/js/dropdown-bootstrap-extended.js')); ?>"></script>

    <!-- Simplebar JS -->
    <script src="<?php echo e(asset('assets/vendors/simplebar/dist/simplebar.min.js')); ?>"></script>



    <!-- Daterangepicker JS -->
    <script src="<?php echo e(asset('assets/vendors/moment/min/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendors/daterangepicker/daterangepicker.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/dist/js/daterangepicker-data.js')); ?>"></script>

    <!-- Sweetalert2 JS -->
    
    <script src="<?php echo e(asset('assets/vendors/sweetalert2/dist/sweetalert2.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/vendors/select2/dist/js/select2.full.min.js')); ?>"></script>

    <!-- Apex JS -->

    <!-- Init JS -->
    <script src="<?php echo e(asset('assets/dist/js/init.js')); ?>"></script>


    <!-- dropzone 5 -->
    <script src="<?php echo e(asset('assets/vendors/dropzone/dist/dropzone.min.js')); ?>"></script>
    <script>
        Dropzone.autoDiscover = false;
    </script>
    <?php echo $__env->make('components.loading.modal-loading', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script src="<?php echo e(asset('js/icons.js')); ?>"></script>
    <script src="<?php echo e(asset('js/sweetalert2.js')); ?>"></script>
    <script src="<?php echo e(asset('js/ajax-contants.js')); ?>"></script>

    <script src="<?php echo e(asset('js/other.js')); ?>"></script>
    <?php if(auth()->check()): ?>
        <script>
            getWalletUser();
        </script>
    <?php endif; ?>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH C:\Dev\Laravel\kango\kango\resources\views/layouts/app.blade.php ENDPATH**/ ?>