<div class="table-responsive">
    <?php
        $paycash_kind_name = config('constans.constans.payment_cash_kind');
    ?>
    <table class="table table-bordered mb-0">
        <thead>
            <tr>
                <th scope="col">
                    <?php if(onCheckPositionAccount(SETTING_ADMIN_ACCOUNT, auth()->user()['position_id'])): ?>
                        <input class="form-check-input" type="checkbox" id="is_check_all" onclick="onCheckAllPayCash()"
                            <?php echo e($is_check_all ? 'checked' : ''); ?>>
                    <?php endif; ?>
                    <label class="form-check-label" for="is_check_all">
                        Trạng thái
                    </label>
                </th>
                <th scope="col">Ngày tạo</th>
                <th scope="col">Mã hóa đơn</th>
                <th scope="col">SỐ TIỀN THỰC TẾ DB/ST</th>
                <th scope="col">Kế toán thu</th>
                <th scope="col">Loại</th>
                <th scope="col">Người thanh toán</th>
                <th scope="col">Chuyển khoản</th>
                <th scope="col">Tiền mặt</th>
                <th scope="col">Tổng tiền</th>
                
                <th scope="col">Ghi chú</th>
                <th scope="col">Bằng chứng</th>
                <th scope="col"></th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $paycashs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="<?php echo e($item['active_flg'] == ACTIVE ? '' : 'table-danger'); ?>">
                    <td>
                        <div class="form-check <?php echo e($item['active_flg'] == ACTIVE ? '' : 'd-none'); ?>">
                            <?php if($item['checked'] == 0 && onCheckPositionAccount(SETTING_ADMIN_ACCOUNT, auth()->user()['position_id'])): ?>
                                <input class="form-check-input" type="checkbox" id="<?php echo e($item['code']); ?>"
                                    onclick="onChoosePaymentCash('<?php echo e($item['id']); ?>')"
                                    <?php echo e($is_check_all || in_array($item['id'], $choosed_paycash) ? 'checked' : ''); ?>>
                            <?php endif; ?>
                            <?php if($item['checked'] == 1): ?>
                                <span class="badge badge-success">Đã duyệt</span>
                            <?php else: ?>
                                <label class="form-check-label" for="<?php echo e($item['code']); ?>">
                                    Chưa duyệt
                                </label>
                            <?php endif; ?>

                        </div>
                    </td>
                    <td>
                        <?php echo e(isset($item['payment_at']) ? formatDate($item['payment_at']) : 'Đơn thanh toán trước 6/11'); ?>

                    </td>
                    <td>
                        <?php switch($item['kind']):
                            case (0): ?>
                                <a class="fw-bold text-primary" target="_blank"
                                    href="<?php echo e(route('shipments.detail.show', ['shipment_code' => $item['code']])); ?>">
                                    <?php echo e($item['code']); ?>

                                </a>
                            <?php break; ?>

                            <?php case (1): ?>
                                <a class="fw-bold text-primary"
                                    href="<?php echo e(route('debit.detail', ['debit_code' => $item['code']])); ?>">
                                    <?php echo e($item['code']); ?>

                                </a>
                                <a href="<?php echo e(route('debit.fwd.export.bill.debit', ['debit_no' => $item['code']])); ?>"
                                    class="btn btn-icon btn-social btn-primary ms-1">
                                    <span class="icon"><i class="fas fa-download"></i></span>
                                </a>
                            <?php break; ?>

                            <?php case (2): ?>
                                <a class="fw-bold text-primary"
                                    href="<?php echo e(route('statement.detail.display', ['statement_code' => $item['code']])); ?>">
                                    <?php echo e($item['code']); ?>

                                </a>
                                <a href="<?php echo e(route('statement.detail.export', ['statement_code' => $item['code']])); ?>"
                                    target="_blank" class="btn btn-icon btn-social btn-primary ms-1"><span class="icon"><i
                                            class="fas fa-download"></i></span></a>
                            <?php break; ?>

                            <?php default: ?>
                        <?php endswitch; ?>
                    </td>
                    <td>
                        <?php
                            $check_difference = $item['amount'] != $item['origin_amount'];
                            $check_icon = $check_difference ? 'fas fa-exclamation-circle text-danger' : '';
                            $check_text = $check_difference ? 'Giá tiền có sự trên lệch' : '';
                        ?>
                        <?php switch($item['kind']):
                            case (1): ?>
                                <?php echo e(formatNumber($item['origin_amount'])); ?> <i title="<?php echo e($check_text); ?>"
                                    class="<?php echo e($check_icon); ?>"></i>
                            <?php break; ?>

                            <?php case (2): ?>
                                <?php echo e(formatNumber($item['origin_amount'])); ?> <i title="<?php echo e($check_text); ?>"
                                    class="<?php echo e($check_icon); ?>"></i>
                            <?php break; ?>

                            <?php default: ?>
                        <?php endswitch; ?>
                    </td>
                    <td>[<?php echo e($item['creator_code']); ?>] <?php echo e($item['creator_name']); ?> </td>
                    <td><?php echo e($paycash_kind_name[$item['kind']] ?? 'Không xác định'); ?></td>
                    <td>
                        <?php echo $__env->make('components.badges-position-name', [
                            'position_id' => $item['customer_position_id'],
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo e(onCheckPositionAccount(SETTING_FWD_ACCOUNT, $item['customer_position_id']) ? $item['customer_company'] : $item['customer_name']); ?>

                    </td>
                    <?php if($item['active_flg'] == ACTIVE): ?>
                        <td><?php echo e(formatNumber($item['amount_bank'])); ?></td>
                        <td><?php echo e(formatNumber($item['amount_cash'])); ?></td>
                        <td><?php echo e(formatNumber($item['amount'])); ?></td>
                        
                        <td><?php echo e($item['checked_note']); ?></td>
                        <td>
                            <?php $__currentLoopData = onConvertStrArrImage($item['images']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a class="p-2" href="<?php echo e(asset($image)); ?>" target="_blank"><i
                                        class="fas fa-image"></i></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <?php if(onCheckPositionAccount(SETTING_ADMIN_ACCOUNT, auth()->user()['position_id'])): ?>
                            <td>
                                <?php if($item['checked'] == 0): ?>
                                    <button class="btn btn-primary btn-sm m-1" data-bs-toggle="tooltip"
                                        data-bs-placement="bottom" data-bs-title="Duyệt đơn và chia tiền thanh toán"
                                        onclick="showModalCheckedPayment(<?php echo e($item['id']); ?>, <?php echo e($item['amount']); ?>, <?php echo e($item['amount_cash']); ?>, <?php echo e($item['amount_bank']); ?>)"><i
                                            class="fas fa-check"></i></button>
                                <?php endif; ?>
                                <?php if($item['checked'] == 1): ?>
                                    <button class="btn btn-warning btn-sm m-1" data-bs-toggle="tooltip"
                                        data-bs-placement="bottom" data-bs-title="Hoàn lại trạng thái đơn"
                                        onclick="onRefundCheckedPayment(<?php echo e($item['id']); ?>)"><i
                                            class="fas fa-undo"></i></button>
                                <?php endif; ?>
                                <button class="btn btn-danger btn-sm m-1"
                                    title="hoàn đơn về trạng thái chưa thanh toán"
                                    onclick="onRemoveCheckedPayment(<?php echo e($item['id']); ?>, <?php echo e($item['active_flg']); ?>)">
                                    <i class="fas fa-exclamation-circle"></i></button>
                            </td>
                        <?php endif; ?>
                    <?php else: ?>
                        <td colspan="5" class="fw-bold"><?php echo e($item['checked_note']); ?></td>
                        <td><button class="btn btn-danger btn-sm m-1" title="Xóa ghi chú"
                                onclick="onRemoveCheckedPayment(<?php echo e($item['id']); ?>, <?php echo e($item['active_flg']); ?>)"><i
                                    class="fas fa-trash"></i></button></td>
                    <?php endif; ?>

                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>

    </table>
</div>
<div class="d-flex justify-content-center mt-5">
    <?php echo e($paycashs->links('components.pagination')); ?>

</div>
<script>
    $(function() {
        let fwd_cash = <?php echo json_encode($chart['fwd_cash'], 15, 512) ?> ?? 0;
        let fwd_bank = <?php echo json_encode($chart['fwd_bank'], 15, 512) ?> ?? 0;
        let sale_cash = <?php echo json_encode($chart['sale_cash'], 15, 512) ?> ?? 0;
        let sale_bank = <?php echo json_encode($chart['sale_bank'], 15, 512) ?> ?? 0;

        $('#content_chart').html('');
        var pub_chart = null;
        if (pub_chart) {
            pub_chart.destroy();
        }

        var options = {
            series: [fwd_cash, fwd_bank, sale_cash, sale_bank],
            chart: {
                type: 'pie',
            },
            colors: ['#ff3d3d', '#007D88', '#FFFF00', '#00FF00'],
            labels: ['Fwd tiền mặt', 'Fwd chyển khoản', 'Sale tiền mặt', 'Sale chyển khoản'],
            legend: {
                position: 'bottom' // Đặt labels ở phía dưới
            },
            tooltip: {
                y: {
                    formatter: function(value) {
                        return value
                            .toLocaleString(); // Sử dụng hàm formatNumber đã định nghĩa trước đó
                    }
                }
            },
            responsive: [{
                breakpoint: 480,
                options: {
                    chart: {
                        width: 200
                    },
                    legend: {
                        position: 'bottom'
                    }
                }
            }]
        };

        pub_chart = new ApexCharts(document.querySelector("#content_chart"), options);
        pub_chart.render();

        let total_cash = fwd_cash + fwd_bank + sale_cash + sale_bank;

        $('#fwd_cash').html(fwd_cash.toLocaleString() + ' vnd');
        $('#fwd_bank').html(fwd_bank.toLocaleString() + ' vnd');
        $('#sale_cash').html(sale_cash.toLocaleString() + ' vnd');
        $('#sale_bank').html(sale_bank.toLocaleString() + ' vnd');
        $('#total_cash').html(total_cash.toLocaleString() + ' vnd');

    });
</script>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/manage/admin/system/manage-pay-cash/paginate.blade.php ENDPATH**/ ?>