<?php if($price_list_tranport_type == PRICE_LIST_TYPE_DELIVERY): ?>
    <div class="row gx-3">
        <div class="col-sm-12">
            <div class="form-group">
                <label class="form-label">Quốc gia</label>
                <select class="form-select select2" id="item_child_price_list_country_id" disabled>
                    <option selected value="">Chọn quốc gia</option>
                    <?php $__currentLoopData = $data['countries']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($country['country_id']); ?>"
                            <?php echo e(isset($data['country_id']) && $data['country_id'] == $country['country_id'] ? 'selected' : ''); ?>>
                            <?php echo e($country['country_name']); ?> - <?php echo e($country['country_code']); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php if($price_list_tranport_type == PRICE_LIST_TYPE_SERVICE): ?>
    <div class="fst-italic fs-8">
        <div class="text-danger">
            <strong>Lưu ý</strong>
        </div>
        <div class="text-danger">
            <span>- Đối với bảng giá loại bình thường thì sẽ có duy nhất 1 cột và sẽ tính theo cột đó.</span>
        </div>
        <div class="text-danger">
            <span>- Đối với bảng giá dịch vụ không phải loại bình thường có ít nhất và tối đa 1 cột để trống không thêm khu vực và sẽ được hiểu là của toàn bộ khu vực còn lại.</span>
        </div>
        <div class="text-danger">
            <span>- Không thể tạo bảng giá nếu bạn để trống hơn 1 cột không thêm khu vực hoặc bạn đã chọn đầy khu vực nhưng có tồn tại cột để trống không chọn khu vực.</span>
        </div>
        <div class="text-danger">
            <span>- Đối với bảng giá dịch vụ không phải loại bình thường nếu bạn không chọn hết các khu vực thì khi tính toán không tìm thấy khu vực đó trong bảng giá thì sẽ áp dụng cột để trống khu vực.</span>
        </div>
        <div class="d-flex flex-row">
            <span class="bg-warning rounded d-block d-flex justify-content-center align-items-center" style="width: 20px; height:20px">
                <i class="fa fa-pen text-white"></i> 
            </span>
            Đã thêm khu vực
            <span class="ms-2 bg-primary rounded d-block d-flex justify-content-center align-items-center" style="width: 20px; height:20px">
                <i class="fa fa-pen text-white"></i> 
            </span>
            Không có khu vực
        </div>
        <hr>
    </div>
    <div class="row gx-3">
        <div class="col-sm-6">
            <div class="form-group">
                <label class="form-label">Dịch vụ</label>
                <select class="form-select select2" id="item_child_price_list_service_id" disabled>
                    <option selected value="">Chọn dịch vụ</option>
                    <?php $__currentLoopData = $data['services']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($service['service_id']); ?>"
                            <?php echo e(isset($service['service_id']) && $data['service_id'] == $service['service_id'] ? 'selected' : ''); ?>>
                            <?php echo e($service['service_name']); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="form-group">
                <label class="form-label">Loại</label>
                <select class="form-select" name="sub_child_price_list_type">
                    <?php $__currentLoopData = $data['sub_child_price_list_types']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key_sub_child_price_list_type => $sub_child_price_list_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key_sub_child_price_list_type); ?>"
                            <?php echo e(isset($data['sub_child_price_list_type']) && $data['sub_child_price_list_type'] == $key_sub_child_price_list_type ? 'selected' : ''); ?>>
                            <?php echo e($sub_child_price_list_type); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>
<?php endif; ?>
<div class="row gx-3" id="form_excel_price_list">
    <div class="col-auto mb-3">
        <button type="button" class="btn btn-primary mb-0" onclick="exportToExcel()">
            <span>Xuất mẫu excel</span>
        </button>
    </div>
    <div class="col-auto mb-3">
        <div class="input-group">
            <input type="file" class="form-control" id="input_import_excel_price_list"
                aria-describedby="input_import_excel_price_list_addon" aria-label="Import file excel"
                accept="application/vnd.ms-excel, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet">
            <button class="btn btn-outline-primary mb-0" type="button" id="input_import_excel_price_list_addon">
                <span>Import file excel</span>
            </button>
        </div>
    </div>
</div>
<div id="content_item_child_price_list" class="gx-3 mb300">
    <div class="alert alert-danger" role="alert">
        Chưa chọn đầy đủ thông tin!
    </div>
</div>

<script src="<?php echo e(asset('assets/js/xlsx.full.min.js')); ?>"></script>
<script>
    $('.select2').each(function() {
        $(this).select2({
            dropdownParent: $(this).parent(),
        });
    });

    function exportToExcel() {
        localStorage.setItem("data", JSON.stringify(form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]));
        localStorage.setItem("kind", <?php echo json_encode($price_list_tranport_type, 15, 512) ?>);
        localStorage.setItem("sub_child_price_list_title", `${[0, 1].includes(form_price_list[key_form_price_list]['child_price_list_kind']) ? form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['country_name'] + ' - ' + form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['country_code'] : form_price_list[key_form_price_list]['item_child_price_list'][key_item_child_price_list]['title']}`);
        window.open(`${window.location.origin}/download/excel/item-sub-price-list`);
    }
</script>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/manage/admin/system/price-list/item-child-price-list/edit.blade.php ENDPATH**/ ?>