<div class="row">
    <div class="col-sm-12 table-responsive">
        <table id="datable_1" class="table w-100 mb-5 no-footer">
            <thead class="thead-primary">
                <tr role="row">
                    <th tabindex="0" rowspan="1" colspan="1">Date </th>
                    <th tabindex="0">
                        <input class="form-check-input" type="checkbox" id="is_check_all" onclick="onCheckAll()"
                            <?php echo e($is_check_all ? 'checked' : ''); ?>>
                        <label class="text-white" for="is_check_all">ID Bill</label>
                    </th>
                    <th colspan="1">Đất nước</th>
                    <th>Dịch vụ</th>
                    <th class="text-white" colspan="1">
                        Người nhận</th>
                    <th class="text-white" colspan="1">
                        Packages</th>
                    <th class="text-white" colspan="1">
                        Mawb</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="odd">
                        <td>
                            <?php echo e(formatFullDate($shipment['created_at'])); ?>

                        </td>
                        <td>
                            <div class="form-check">
                                <?php if(
                                    !isset($shipment['shipment_debit_id']) &&
                                        $shipment['shipment_payment_status'] != 1 &&
                                        !onCheckIsEpacket($shipment['shipment_service_id'], $shipment['service']['promotion_flg'])): ?>
                                    <input class="form-check-input" type="checkbox"
                                        <?php echo e(in_array($shipment['shipment_id'], $choosed_id) ? 'checked' : ''); ?>

                                        onclick="onChooseShipment(<?php echo e($shipment['shipment_id']); ?>)"
                                        id="choose_bill_<?php echo e($shipment['shipment_code']); ?>">
                                <?php elseif($shipment['shipment_payment_status'] == 1): ?>
                                    <span class="badge badge-primary">Đã thanh toán</span>
                                <?php elseif($shipment['shipment_payment_step'] == 0 && isset($shipment['shipment_debit_id'])): ?>
                                    <span class="badge badge-warning">Chờ thanh toán</span>
                                <?php elseif(
                                    $shipment['shipment_payment_step'] > 0 &&
                                        $shipment['shipment_payment_step'] < 3 &&
                                        $shipment['shipment_payment_status'] == 0): ?>
                                    <span class="badge badge-warning">Duyệt tạm ứng</span>
                                <?php elseif($shipment['shipment_payment_step'] > 2 && $shipment['shipment_payment_status'] == 0): ?>
                                    <span class="badge badge-success">Chờ xác nhận</span>
                                <?php endif; ?>
                                <label class="form-check-label fw-bold text-primary"
                                    for="choose_bill_<?php echo e($shipment['shipment_code']); ?>">
                                    <?php echo e($shipment['shipment_code']); ?>

                                </label>
                            </div>
                        </td>
                        <td><?php echo e($shipment['country']['country_name']); ?></td>
                        <td>
                            <?php echo $__env->make('components.badges-promotion-name', [
                                'service_id' => $shipment['shipment_service_id'],
                                'promotion_flg' => $shipment['service']['promotion_flg'],
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo e($shipment['service']['service_name']); ?>

                        </td>
                        <td class="align-items-center">
                            <?php echo e($shipment['receiver_contact_name']); ?>

                        </td>
                        <?php
                            $packages = getPackagesAndMawbByShipment($shipment['shipment_id']);
                            $colors = ['secondary', 'info', 'success', 'danger', 'danger'];
                        ?>
                        <td>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="mb-1">
                                    <a href="<?php echo e(route('debit.fwd.imported-goods.detail', ['package_code' => $package['package_code']])); ?>"
                                        target="_blank">
                                        <i class="fas fa-external-link-alt text-primary mr-2"></i>
                                        <?php echo e($package['package_code']); ?> - <?php echo e($package['package_charged_weight']); ?> kg
                                    </a>
                                    <small class="badge badge-<?php echo e($colors[$package['package_status']]); ?>">
                                        <i class="far fa-clock"></i>
                                        <?php echo e($package['package_status_name']); ?>

                                    </small>
                                </div>
                                <br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(isset($package['awb_code'])): ?>
                                    <a href="<?php echo e(route('mawb.bill-shipment', ['awb_code' => $package['awb_code']])); ?>"
                                        type="" class=""><?php echo e($package['awb_code']); ?></a><br>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<div class="d-flex justify-content-center mt-3">
    <?php echo e($shipments->links('components.pagination')); ?>

</div>
<?php /**PATH /home/archibui/logis.websitehoconline.com/resources/views/accounting-management/manager-debit/ajax/table-shipments-fwd.blade.php ENDPATH**/ ?>